<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>
<xsl:template match="/">client
dev tun
<xsl:choose>
<xsl:when test="/configuration/@protocol='openvpn_udp'">
proto udp
explicit-exit-notify
</xsl:when>
<xsl:otherwise>
proto tcp
</xsl:otherwise>
</xsl:choose>
<xsl:for-each select="/configuration/ips/ip">
remote <xsl:value-of select="./@destination"/>
</xsl:for-each>
resolv-retry infinite
remote-random
nobind
tun-mtu 1500
tun-mtu-extra 32
mssfix 1450
persist-key
ping 60
ping-restart 120
ping-timer-rem
reneg-sec 0
comp-lzo
remote-cert-tls server
auth-user-pass
verb 3
pull
fast-io
cipher AES-256-CBC
auth SHA512
&lt;ca&gt;
-----BEGIN CERTIFICATE-----
MIIFMDCCAxigAwIBAgIBATANBgkqhkiG9w0BAQ0FADA7MQswCQYDVQQGEwJWRzER
MA8GA1UEChMIQ3liZXJIb3AxGTAXBgNVBAMTEEN5YmVySG9wIFJvb3QgQ0EwHhcN
MTgwMTAxMDAwMDAwWhcNMjgwMTAxMDAwMDAwWjA7MQswCQYDVQQGEwJWRzERMA8G
A1UEChMIQ3liZXJIb3AxGTAXBgNVBAMTEEN5YmVySG9wIFJvb3QgQ0EwggIiMA0G
CSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQDnyzJH2GfoASW2oCRoz7MKUwVUYtMN
tRCv/vsyd0j+PKE7G2w0sqnBxyO19jXbI7MJGfYVEygxquKs9VopblbcTk//sV8k
oQ6Zd0vM5OhUE8R2mJQc1+xKMACmNeiKLDtfedWtETwg5x7yrIKbA3zaqIBodZCc
PQvuXM9hTeFVa+DnL9GG/cClVHJq0KqK95v1XUqaOzbM3KiW8PkYanSmE9beylva
9JeeDwN9Q+js4VNC90uEsUtWNga0Hu57aRw4ES9WSMuMy8xdx7hibfDCnyRwIINR
rNYtpMy72iaNE65nsRyy/Saw7WcfvBVpeCVEwJArHr/SAmdeTdmUIb5xRpaYegKO
1FsKLqJSVvOSh4eFFPofiCW+e3j1bZxtFWdcCCzCPnGlX1ySivQALoTBRVnn/ITh
3nIaf3TSlnoLnslo4LfFQw0LbhQE6xB9+eNsvzL3UcOxzaSNmDrIvFc8czUjEh4D
vmGxlaiHwX808ScvcWY0HcrwiqmzZLs4pTWc6FueQSlGVUubBM08EhQjmPNppfmE
qH9LzDdZlR4Wtt+QxPDgJyW2UsYWqaWENWjBSHYGqzQwZkyNpo90EBWSGquRnl5Q
3jEp1oK1ISn4SPUIFBy1Bn5BaJH5exbxSEWQaiFQ7+uvhOKuXiHL4+uyTO4m0qrJ
MDffczlqrJztswIDAQABoz8wPTAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBSC
wju8HeAD+x9KYGTlgKHSXsKmkTALBgNVHQ8EBAMCAQYwDQYJKoZIhvcNAQENBQAD
ggIBAOBazQYnqhgvDZzo4Ww6TLlBILQ4cEjhbj9gp8puTBeNhoqa4isgb79l4hFi
wLwiuD/mJp/GmS8L4Ba8RbFSZh+OHYj3Tl+54BhiwX6fCuVNfc/LGL771Ed5J9dG
g16BAfdj5v+MDpPMyRILwY0p7sX8N3UZ36bhsARVcyhRg7LNjc9yF/dy2dizEjab
TaY1+lGl0XiwGlXUIJcAODRGSjXLCXPkg0Ev8f5THksNtcdDpJOXmH1EJihbzfNP
HIh5DuWcEkv5kdyKEpmi3havLsRpLQXjOFcTMlD3IVW2zmERTj3Es88uOZiuFzE0
mavRwIT+lda/tgE6KqWwujXr148FYN+JiTShxqi26E5t9I+CVI3BNTp++aYre5Rt
FzijNEiqBH6fwUqNhAF7KU60p9Iy2wUbFRwSE1/eBz+AJk53NFlcb3tQiVPmu50d
Wd0/uZa1IH20vv3q8lINNKkFqM5CYJmaFPV+ZdM+JApbmaEbTxI4Iv2KLD9fMbyo
rL3tS/1Zg7zmCD2eEhPW2z3hgcWjyE43qx2Emn4kxp126gFR6xMdjNnwsrvhQy32
Mp+FWWiCHcVDbmccENmnXTx6VuSoOMo8LbN5+kutg9KAXL7i8zk9EvEZ4euA5R0U
gbEyQOazQ7LVGzHocQkh+ea89xSD8v+pQsaRBc1PvZOe0vIE
-----END CERTIFICATE-----
&lt;/ca&gt;
key-direction 1
&lt;tls-auth&gt;
#
# 2048 bit OpenVPN static key
#
-----BEGIN OpenVPN Static key V1-----
9ef75c027126966b57cc160c9ae2aa51
51bfeaff8d40bff34b9831060185747e
fa3edf9dbf660c8129102fc4f2568e43
1d4c40720983e29255ae090a24dd6173
e609686c07926670a30e9c958fa7d130
1ee97dfbf4daa1cdca67522630ab7189
2961fb34e2e7d8d07091130b126cddb8
10689c44720adb718d2744bdfc05b53f
a7a608e0b76634c76503e16c3f1f7bc6
598ec3d149d000fac94d91fe58ee03c9
d277411a3a3b872012169c805a3bc79a
3ce5aee7404b9258781185bec9ff569d
9d2e48fbfcc25a7ddbdd51b5fbb6e194
e29e1ca808a169a13390c8ea2ecd12a2
0e448552d51182592edecbd5d446a0c1
0f31f4ae25bb38f0233fba096b99b261
-----END OpenVPN Static key V1-----
&lt;/tls-auth&gt;
ifconfig-ipv6 fd00::1 fd00::2
route-ipv6 2000::/3

auth-retry nointeract
</xsl:template>
</xsl:stylesheet>