package com.amazon.kindle.search;

public class USearchManager {

    
    /**
     * Intent Uri to create the intent that will launch unified search from your app
     */
    public final static String SEARCH_INTENT_URI = "intent:#Intent;action=android.search.action.GLOBAL_SEARCH;end";
    
    /**
     * Extras for launching USearchManager
     * will use when querying your content provider for results based on user input
     * (e.g. looking for partial matches).
     * Typically you'll use this with a URI matcher.
     */
    
    /**
     * Domain field in the search intent
     */
    public final static String DOMAIN = "domain";
    /**
     * Domain field data in search Intent for launching search with library tab
     */
    public final static String LIBRARY = "library";
    /**
     * Domain field data in search Intent for launching search with store tab
     */
    public final static String STORE = "store";
    /**
     * Domain field data in search Intent for launching search with web tab
     */
    public final static String WEB = "web";
    
    /**
     * Uri path for queried search result data.  This is the path that the search manager
     * will use when querying your content provider for results based on user input
     * (e.g. looking for partial matches).
     * Typically you'll use this with a URI matcher.
     */
    public final static String SEARCH_QUERY = "query";
    
    
    /**
     * Query parameter added to search queries to limit the number of results returned.
     * Limit should be applied to each category.unit group if generating aggregate data.
     * (e.g. results has 10 matches Books.title and 10 matches for Books.author if limit is 10)
     */
    public final static String LIMIT = "limit";
    
    /**
     * Query parameter added to search queries to limit the results by category.
     * Results should all belong to the category requested. The category will one of
     * the defined categories in searchConfig.xml
     * (e.g. Books, Video)
     * can also be defined in search intent to launch search activity for a specific category
     */
    public final static String CATEGORY = "category";
    
    /**
     * Query parameter added to search queries to limit the results by unit.
     * If defined query will also contain a category.
     * Results should all belong to the category.unit requested. The Unit will be one of
     * the defined units in searchConfig.xml.
     * (e.g. title,author,Movies,TV)
     */
    public final static String UNIT = "unit";
    
    /**
     * cursor result column : Title to display. Required.
     */
    public final static String TITLE = "text";
    
    /**
     * cursor result column : SubTitle to display. optional.
     */
    public final static String SUBTITLE1 = "stext";
    
    /**
     * cursor result column : More SubTitle  to display. optional.
     */
    public final static String SUBTITLE2 = "sstext";

    /**
     * cursor result column : icon uri to display. optional.
     * Defaults to category/unit icon in search activity.
     * The data in the column must
     *  be a resource ID of a drawable, or an contentResolver file URI.
     *
     *
     * for more information on these schemes. 
     */
    public final static String ICON = "icon";

    /**
     * cursor result column : data id. String. optional.
     * If defined will be passed to the intent/verb when the result is clicked.
     * 
     */
    public final static String DATA_ID = "did";
    
    /**
     * cursor result column : result type. String. optional.
     * If defined will be used to lookup fields in searchconfig resultTypeList.
     * 
     */
    
    public static final String RESULT_TYPE = "rtype";
    
    /**
     * cursor result column : STATE. integer. optional.
     * If defined will be using CMS state rules to interpret as bitmkask.
     * Refer to https://wiki.corp.lab126.com/mediawiki-1.10/index.php/Otter/CMSDataSchema#Common_Item_Fields
     * 
     */
    public final static String STATE = "state";
    
    
    
    /**
     * cursor result column : Verb. String. optional.
     * If defined will be passed to the CMS operation service when the result is clicked.
     * 
     */
    public final static String VERB = "verb";
    
    /**
     * Intent Uri. String. optional.
     * If defined will be used to generate an intent on click.
     * If the Uri does not define an action, VIEW action will be used
     * In addition the data id will be passed as extra
     * 
     */
    public final static String INTENT_URI = "intentUri";
    
    /**
     * extra field for store Search Results intent.
     * String extra for the search suggestion that the user clicked
     * 
     */
    public final static String SEARCH_SUGGESTION = "term";
    
    /**
     * extra field for the search Results intent. optional. May not be defined.
     * String extra for the search alias/refinement of the suggestion clicked by user.
     * Can be ignored if not needed. May not be defined if the ISS service did
     * not set the value.
     */
    public final static String SEARCH_ALIAS = "alias";
    
    /**
     * extra field for the search Results intent. unused.
     * String extra for the search prefix typed by user.
     * May be used for logging and analytics.
     */
    public final static String SEARCH_PREFIX = "prefix";
    
}
