
#extension GL_OES_EGL_image_external : require
precision mediump float;
uniform samplerExternalOES  texture;
varying highp vec2 v_TexCoordinate;
uniform vec2 singleStepOffset;
uniform highp vec4 params;

const highp vec3 W = vec3(0.299,0.587,0.114);
const mat3 saturateMatrix = mat3(
		1.052,-0.0598,-0.061,
		-0.0774,1.0026,-0.1186,
		-0.0228,-0.0228,1.0872);

float hardlight(float color)
{
	if(color <= 0.5)
	{
		color = color * color * 1.2;
	}
	else
	{
		color = 1.0 - ((1.0 - color)*(1.0 - color) * 1.2);
	}
	return color;
}

void main(){
	vec2 blurCoordinates[12];
	blurCoordinates[0] = v_TexCoordinate.xy + singleStepOffset * vec2(5.0, -8.0);
	blurCoordinates[1] = v_TexCoordinate.xy + singleStepOffset * vec2(5.0, 8.0);
	blurCoordinates[2] = v_TexCoordinate.xy + singleStepOffset * vec2(-5.0, 8.0);
	blurCoordinates[3] = v_TexCoordinate.xy + singleStepOffset * vec2(-5.0, -8.0);

	blurCoordinates[4] = v_TexCoordinate.xy + singleStepOffset * vec2(8.0, -5.0);
	blurCoordinates[5] = v_TexCoordinate.xy + singleStepOffset * vec2(8.0, 5.0);
	blurCoordinates[6] = v_TexCoordinate.xy + singleStepOffset * vec2(-8.0, 5.0);
	blurCoordinates[7] = v_TexCoordinate.xy + singleStepOffset * vec2(-8.0, -5.0);

	blurCoordinates[8] = v_TexCoordinate.xy + singleStepOffset * vec2(-4.0, -4.0);
	blurCoordinates[9] = v_TexCoordinate.xy + singleStepOffset * vec2(-4.0, 4.0);
	blurCoordinates[10] = v_TexCoordinate.xy + singleStepOffset * vec2(4.0, -4.0);
	blurCoordinates[11] = v_TexCoordinate.xy + singleStepOffset * vec2(4.0, 4.0);

	float sampleColor = texture2D(texture, v_TexCoordinate).g * 10.0;

	sampleColor += texture2D(texture, blurCoordinates[0]).g;
	sampleColor += texture2D(texture, blurCoordinates[1]).g;
	sampleColor += texture2D(texture, blurCoordinates[2]).g;
	sampleColor += texture2D(texture, blurCoordinates[3]).g;
	sampleColor += texture2D(texture, blurCoordinates[4]).g;
	sampleColor += texture2D(texture, blurCoordinates[5]).g;
	sampleColor += texture2D(texture, blurCoordinates[6]).g;
	sampleColor += texture2D(texture, blurCoordinates[7]).g;

	sampleColor += texture2D(texture, blurCoordinates[8]).g * 2.0;
	sampleColor += texture2D(texture, blurCoordinates[9]).g * 2.0;
	sampleColor += texture2D(texture, blurCoordinates[10]).g * 2.0;
	sampleColor += texture2D(texture, blurCoordinates[11]).g * 2.0;

	sampleColor = sampleColor / 38.0;

	vec3 centralColor = texture2D(texture, v_TexCoordinate).rgb;

	float highpass = centralColor.g - sampleColor + 0.5;

	for(int i = 0; i < 5;i++)
	{
		highpass = hardlight(highpass);
	}
	float lumance = dot(centralColor, W);

	float alpha = pow(lumance, params.r);

	vec3 smoothColor = centralColor + (centralColor-vec3(highpass))*alpha*0.2;

	smoothColor.r = clamp(pow(smoothColor.r, params.g),0.0,1.0);
	smoothColor.g = clamp(pow(smoothColor.g, params.g),0.0,1.0);
	smoothColor.b = clamp(pow(smoothColor.b, params.g),0.0,1.0);

	vec3 lvse = vec3(1.0)-(vec3(1.0)-smoothColor)*(vec3(1.0)-centralColor);
	vec3 bianliang = max(smoothColor, centralColor);
	vec3 rouguang = 2.0*centralColor*smoothColor + centralColor*centralColor - 2.0*centralColor*centralColor*smoothColor;

	gl_FragColor = vec4(mix(centralColor, lvse, alpha), 1.0);
	gl_FragColor.rgb = mix(gl_FragColor.rgb, bianliang, alpha);
	gl_FragColor.rgb = mix(gl_FragColor.rgb, rouguang, params.b);
	vec3 satcolor = gl_FragColor.rgb * saturateMatrix;
	gl_FragColor.rgb = mix(gl_FragColor.rgb, satcolor, params.a);
}