
#extension GL_OES_EGL_image_external : require
precision mediump float;
uniform samplerExternalOES texture;
varying vec2 v_TexCoordinate;
uniform vec2 singleStepOffset;
float intensity = 1.0;
void main()
{
        vec2 blurCoordinates[20];
        blurCoordinates[0] = v_TexCoordinate + vec2(0.0, -10.0) * singleStepOffset;
        blurCoordinates[1] = v_TexCoordinate + vec2(5.0, -8.0) * singleStepOffset;
        blurCoordinates[2] = v_TexCoordinate + vec2(8.0, -5.0) * singleStepOffset;
        blurCoordinates[3] = v_TexCoordinate + vec2(10.0, 0.0) * singleStepOffset;
        blurCoordinates[4] = v_TexCoordinate + vec2(8.0, 5.0) * singleStepOffset;
        blurCoordinates[5] = v_TexCoordinate + vec2(5.0, 8.0) * singleStepOffset;
        blurCoordinates[6] = v_TexCoordinate + vec2(0.0, 10.0) * singleStepOffset;
        blurCoordinates[7] = v_TexCoordinate + vec2(-5.0, 8.0) * singleStepOffset;
        blurCoordinates[8] = v_TexCoordinate + vec2(-8.0, 5.0) * singleStepOffset;
        blurCoordinates[9] = v_TexCoordinate + vec2(-10.0, 0.0) * singleStepOffset;
        blurCoordinates[10] = v_TexCoordinate + vec2(-8.0, -5.0) * singleStepOffset;
        blurCoordinates[11] = v_TexCoordinate + vec2(-5.0, -8.0) * singleStepOffset;
        blurCoordinates[12] = v_TexCoordinate + vec2(0.0, -6.0) * singleStepOffset;
        blurCoordinates[13] = v_TexCoordinate + vec2(-4.0, -4.0) * singleStepOffset;
        blurCoordinates[14] = v_TexCoordinate + vec2(-6.0, 0.0) * singleStepOffset;
        blurCoordinates[15] = v_TexCoordinate + vec2(-4.0, 4.0) * singleStepOffset;
        blurCoordinates[16] = v_TexCoordinate + vec2(0.0, 6.0) * singleStepOffset;
        blurCoordinates[17] = v_TexCoordinate + vec2(4.0, 4.0) * singleStepOffset;
        blurCoordinates[18] = v_TexCoordinate + vec2(6.0, 0.0) * singleStepOffset;
        blurCoordinates[19] = v_TexCoordinate + vec2(4.0, -4.0) * singleStepOffset;
        
        vec3 centralColor = texture2D(texture, v_TexCoordinate).rgb;
        
        float sampleColor = centralColor.g * 24.0;
        
        sampleColor += texture2D(texture, blurCoordinates[0]).g;
        sampleColor += texture2D(texture, blurCoordinates[1]).g;
        sampleColor += texture2D(texture, blurCoordinates[2]).g;
        sampleColor += texture2D(texture, blurCoordinates[3]).g;
        sampleColor += texture2D(texture, blurCoordinates[4]).g;
        sampleColor += texture2D(texture, blurCoordinates[5]).g;
        sampleColor += texture2D(texture, blurCoordinates[6]).g;
        sampleColor += texture2D(texture, blurCoordinates[7]).g;
        sampleColor += texture2D(texture, blurCoordinates[8]).g;
        sampleColor += texture2D(texture, blurCoordinates[9]).g;
        sampleColor += texture2D(texture, blurCoordinates[10]).g;
        sampleColor += texture2D(texture, blurCoordinates[11]).g;
        sampleColor += texture2D(texture, blurCoordinates[12]).g;
        sampleColor += texture2D(texture, blurCoordinates[13]).g;
        sampleColor += texture2D(texture, blurCoordinates[14]).g;
        sampleColor += texture2D(texture, blurCoordinates[15]).g;
        sampleColor += texture2D(texture, blurCoordinates[16]).g;
        sampleColor += texture2D(texture, blurCoordinates[17]).g;
        sampleColor += texture2D(texture, blurCoordinates[18]).g;
        sampleColor += texture2D(texture, blurCoordinates[19]).g;
        
        sampleColor = sampleColor/44.0;
        
        float dis = centralColor.g - sampleColor + 0.5;
        
        if(dis <= 0.5)
        {
            dis = dis * dis * 2.0;
        }
        else
        {
            dis = 1.0 - ((1.0 - dis)*(1.0 - dis) * 2.0);
        }
        
        if(dis <= 0.5)
        {
            dis = dis * dis * 2.0;
        }
        else
        {
            dis = 1.0 - ((1.0 - dis)*(1.0 - dis) * 2.0);
        }
        
        if(dis <= 0.5)
        {
            dis = dis * dis * 2.0;
        }
        else
        {
            dis = 1.0 - ((1.0 - dis)*(1.0 - dis) * 2.0);
        }
        
        if(dis <= 0.5)
        {
            dis = dis * dis * 2.0;
        }
        else
        {
            dis = 1.0 - ((1.0 - dis)*(1.0 - dis) * 2.0);
        }
        
        if(dis <= 0.5)
        {
            dis = dis * dis * 2.0;
        }
        else
        {
            dis = 1.0 - ((1.0 - dis)*(1.0 - dis) * 2.0);
        }
        
        vec3 result = centralColor * 1.065 - dis * 0.065;
        
        float hue = dot(result, vec3(0.299,0.587,0.114)) - 0.3;
        
        hue = pow(clamp(hue, 0.0, 1.0), 0.3);
        
        result = centralColor * (1.0 - hue) + result * hue;
        result = (result - 0.8) * 1.06 + 0.8;
        
        result = pow(result, vec3(0.75));
        /*if ((result.r>=0.35 && result.g>0.156 && result.b>0.07 &&
            result.r>=result.g && result.r >= result.b) && abs(result.b - result.g)
                <= 0.12 && (result.r - result.g) >= 0.045) {*/
             result.r = result.r * 1.125;
        //}
        result = mix(centralColor, result, intensity);

        
        gl_FragColor = vec4(result, 1.0);
}