// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{html as e,css as t,when as n,createRef as i,ref as o,LitElement as r}from"../../common/lit.js";import l from"../../common/i18n.js";import{ActionName as u}from"../utils/histogram.js";import{voiceoverEnable as a}from"../utils/index.js";import{RecordBool as s}from"../../common/log.js";customElements.define("edge-topsite-input",class extends r{static get styles(){return t`
      :host {
        position: relative;
        display: inline-block;
        display: flex;
        align-items: center;
      }

      input {
        flex: 1;
        width: 0;
        margin-inline-end: 10px;
        font-size: 15rem;
        line-height: 20rem;
        border: none;
        outline: none;
        background: none;
        text-overflow: ellipsis;
        overflow: hidden;
        color: var(--text-dominant);
        caret-color: var(--accent-primary);
      }

      input::placeholder {
        font-size: 15rem;
        line-height: 20rem;
        color: var(--text-secondary);
      }

      .clear {
        margin-inline-end: -6px;
        fill: var(--text-secondary);
        outline: none;
      }

      .cancel {
        font-size: 15rem;
        line-height: 20rem;
        color: var(--color-brand-foreground1);
      }

      @media (prefers-color-scheme: dark) {
        input::placeholder {
          color: var(--text-primary);
        }

        .clear {
          fill: var(--text-primary);
        }

        .cancel {
          color: var(--color-brand-foreground2);
        }
      }
    `}static get properties(){return{inputFocus:{type:Boolean},inputValue:{type:String},inputName:{type:String},placeholder:{type:String},showCancel:{type:Boolean},icon:{type:String},onChange:{type:Function},hideTabIndex:{type:Boolean}}}constructor(){super(),this.inputRef=i()}connectedCallback(){super.connectedCallback();let e=null;this.onTouchOutside=t=>{e&&clearTimeout(e),e=setTimeout((()=>{if(e=null,!this.inputFocus)return;const n=t.touches[0].pageX,i=t.touches[0].pageY,o=this.getBoundingClientRect();(n<o.x||n>o.right||i<o.y||i>o.bottom)&&this.inputRef.value.blur()}),100)},document.addEventListener("touchstart",this.onTouchOutside)}disconnectedCallback(){super.disconnectedCallback(),document.removeEventListener("touchstart",this.onTouchOutside)}updated(e){if(super.updated(e),e.has("inputValue")){this.inputRef.value.value!==this.inputValue&&(this.inputRef.value.value=this.inputValue)}}updateInputValue(e){this.inputValue=e,this.onChange?.(e)}focusInput(){this.inputRef.value.focus()}onInputFocus(){this.inputFocus=!0,s(u.SearchClicked,!0)}onInputBlur(){this.inputFocus=!1}onInputChange(e){const t=e?.target?.value||"";t!==this.inputValue&&this.updateInputValue(t)}onCancel(){this.inputRef.value.blur()}onClear(){this.updateInputValue(""),this.inputRef.value.value="",setTimeout((()=>{this.focusInput()}),500)}onClearMouseDown(e){e.preventDefault()}renderClear(){return e`
      <svg class="clear" role="button" aria-label=${l.text("tsp_search_clear")} @mousedown=${this.onClearMouseDown} @click=${this.onClear} width="24" height="24"
        viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
        <path
          d="M12 4C16.4183 4 20 7.58172 20 12C20 16.4183 16.4183 20 12 20C7.58172 20 4 16.4183 4 12C4 7.58172 7.58172 4 12 4ZM9.80943 9.11372C9.61456 8.97872 9.34514 8.99801 9.17157 9.17157L9.11372 9.24082C8.97872 9.43569 8.99801 9.70511 9.17157 9.87868L11.2929 12L9.17157 14.1213L9.11372 14.1906C8.97872 14.3854 8.99801 14.6549 9.17157 14.8284L9.24082 14.8863C9.43569 15.0213 9.70511 15.002 9.87868 14.8284L12 12.7071L14.1213 14.8284L14.1906 14.8863C14.3854 15.0213 14.6549 15.002 14.8284 14.8284L14.8863 14.7592C15.0213 14.5643 15.002 14.2949 14.8284 14.1213L12.7071 12L14.8284 9.87868L14.8863 9.80943C15.0213 9.61456 15.002 9.34514 14.8284 9.17157L14.7592 9.11372C14.5643 8.97872 14.2949 8.99801 14.1213 9.17157L12 11.2929L9.87868 9.17157L9.80943 9.11372Z" />
      </svg>
    `}renderCancel(){return this.showCancel?e`
      <span class="cancel" role="button" @click=${this.onCancel}>
        ${l.text("common_cancel")}
      </span>
    `:null}render(){return e`
      <input 
        ${o(this.inputRef)} 
        value=${this.inputValue} 
        type="text" 
        tabindex=${this.hideTabIndex?"-1":"0"} 
        aria-hidden=${this.hideTabIndex}
        aria-label=${this.inputName} 
        @focus=${this.onInputFocus} 
        @blur=${this.onInputBlur} 
        @input=${this.onInputChange} 
        placeholder=${this.placeholder}
        autocorrect="off">
      ${n(a,(()=>n(this.inputValue?.length>0,(()=>this.renderClear()),(()=>n(this.inputFocus,(()=>this.renderCancel()),(()=>this.icon))))),(()=>n(this.inputFocus,(()=>n(this.inputValue?.length>0,(()=>this.renderClear()),(()=>this.renderCancel()))),(()=>this.icon))))}
    `}});