// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{isDarkMode as o}from"../../common/environment.js";import{LitElement as e,html as t,css as r,classMap as i,when as n}from"../../common/lit.js";import{FaviconValue as a,ActionName as s,SiteValue as c}from"../utils/histogram.js";import{RecordEnum as d,RecordTimes as h}from"../../common/log.js";import{getDefaultIconColor as p,getIconSrc as m,isImproveFaviconPerformanceEnabled as l,isNoBorderIconEnabled as u}from"../utils/index.js";customElements.define("edge-topsite-favicon",class extends e{static get properties(){return{item:{type:Object},iconLoad:{type:Boolean},iconError:{type:Boolean}}}static get styles(){return r`
      :host {
        width: 48px;
        height: 48px;
        border-radius: 12px;
        box-shadow: 0px 1px 2px rgba(0, 0, 0, 0.14), 0px 0px 2px rgba(0, 0, 0, 0.12);
        display: block;
        position: relative;
      }

      .container {
        width: 48px;
        height: 48px;
        border-radius: 12px;
        background-color: var(--surfaces-primary);
      }

      .noBorderContainer {
        width: 52px;
        height: 52px;
        border-radius: 0;
        mask-image: url('./resources/tp-item-background.png');
        mask-size: cover;
        mask-repeat: no-repeat;
      }

      .icon {
        position: absolute;
        left: 50%;
        top: 50%;
        transform: translate(-50%, -50%);
        width: 36px;
        height: 36px;
        border-radius: 6px;
        overflow: hidden;
        object-fit: cover;
        transition: opacity 200ms;
        pointer-events: none;
        opacity: 0;
      }

      .noBorderIcon {
        width: 52px;
        height: 52px;
        border-radius: 0;
      }

      .showIcon {
        opacity: 1;
      }

      .text {
        position: absolute;
        left: 50%;
        top: 50%;
        transform: translate(-50%, -50%);
        width: 36px;
        height: 36px;
        border-radius: 6px;
        color: #6E6E6E;
        background-color: var(--surfaces-secondary);
        font-size: 28px;
        display: flex;
        justify-content: center;
        align-items: center;
        font-weight: 600;
        opacity: 0;
      }
      
      .showTextIcon {
        opacity: 1;
      }

      .noBorderText {
        width: 52px;
        height: 52px;
        border-radius: 0;
        font-size: 45px;
        font-weight: 400;
      }

      @media (prefers-color-scheme: dark) {
        .container {
          background-color: var(--surfaces-quaternary);
        }

        .text {
          background-color: var(--divider-secondary);
        }
      }
    `}constructor(){super(),this.onIconLoad=this.onIconLoad.bind(this),this.onIconError=this.onIconError.bind(this),this.onThemeChange=this.onThemeChange.bind(this),this.startLoadTime=0}firstUpdated(){super.firstUpdated(),(this.item.iconUrl||o()&&this.item.iconUrlDark)&&d(s.FaviconLoad,a.Load,a.Max)}connectedCallback(){super.connectedCallback(),window.matchMedia("(prefers-color-scheme: dark)").addEventListener("change",this.onThemeChange)}disconnectedCallback(){window.matchMedia("(prefers-color-scheme: dark)").removeEventListener("change",this.onThemeChange),super.disconnectedCallback()}onIconLoad(){this.iconLoad=!0,h(s.FaviconLoadTime,performance.now()-this.startLoadTime)}onIconError(){this.iconError=!0;const{iconUrl:e,iconUrlDark:t,...r}=this.item;(e||o()&&t)&&(this.item=r,d(s.FaviconLoad,a.Failed,a.Max))}onThemeChange(){this.requestUpdate()}getHostInitial(){try{const o=new URL(this.item.url),e=o.hostname?.toUpperCase();if(!e)return"";if(e.match(/(\d{1,3}\.){3}\d{1,3}/))return"IP";const t=e.match(/^.*?([A-Z0-9\-]+)((\.(COM|EDU|GOV|NET|ORG)(\.[A-Z]{2})?)|(\.[^\.]+))?$/);return t?t[1].charAt(0):e.charAt(0)}catch(o){return""}}render(){this.item.site_id,c.FeatureShortcuts;const e={icon:!0,noBorderIcon:u,showIcon:this.iconLoad},r={text:!0,noBorderText:u,showTextIcon:this.iconError},n={container:!0,noBorderContainer:u},a=m(this.item),s=m(this.item,!0),[d,h]=p(this.item.defaultIconGroupId,o());return this.startLoadTime=performance.now(),t`
        <div class="${i(n)}">
          <div class="${i(r)}" aria-hidden="true"
               style="color: ${d}; background-color: ${h};">${this.getHostInitial()}
          </div>
          <picture>
            <source srcset=${s} media="(prefers-color-scheme: dark)"/>
            <img class=${i(e)} aria-hidden="true" src=${a} @load=${this.onIconLoad}
                 @error=${this.onIconError}>
          </picture>
        </div>
      `}});