// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{LitElement as t,html as e,css as i,choose as n,when as o}from"../../common/lit.js";import{ExtensionPage as r,InstallEventType as s,InstallState as a}from"../types.js";import"../../common/dewey/dewey-button.js";import"../../common/controls/edge-loading-skeleton.js";import{getInstallState as l,installExtension as c,proxyExtensionFetch as d,showInstallFailedToast as m}from"../action.js";import{isDarkMode as h}from"../../common/environment.js";import{getExtensionRatingString as g,getExtensionRatingCountString as p,loadRecommendCache as x,saveRecommendCache as u}from"../utils.js";import b from"../../common/i18n.js";customElements.define("recommend-view",class extends t{static get styles(){return i`
      .container {
        display: flex;
        border-radius: 12px;
        box-shadow: 0px 0px 2px 0px rgba(0, 0, 0, 0.12);
        padding: 16px;
        margin-top: 4px;
        margin-bottom: 4px;
        box-sizing: border-box;
        background-color: var(--surfaces-primary);
        justify-content: space-between;
      }
      img {
        width: 32px;
        height: 32px;
        margin-inline-end: 16px;
        object-fit: contain;
        pointer-events: none;
        background: var(--surfaces-quaternary)
      }
      img.loaded {
        background: none;
      }
      .content {
        flex: 1;
        display: flex;
        flex-direction: column;
        margin-right: 16px;
      }
      .title {
        font-size: 16rem;
        line-height: 24rem;
        font-weight: 500;
        color: var(--text-primary);
        overflow: hidden;
        text-overflow: ellipsis;
        display: -webkit-box;
        line-clamp: 1;
        -webkit-line-clamp: 1;
        -webkit-box-orient: vertical;
        word-break: break-all;
      }
      .desc {
        margin-top: 4px;
        font-size: 12rem;
        line-height: 16rem;
        min-height: 32rem;
        color: var(--text-secondary);
        overflow: hidden;
        text-overflow: ellipsis;
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        word-break: break-word;
        white-space: pre-wrap;
      }
      .extra {
        color: var(--text-secondary);
        height: 16px;
        margin-top: 4px;
        flex: 1;
        display: flex;
        flex-direction: row;
        align-items: center;
        justify-content: left;
      }
      .rating, .rating-count, .divider-info {
        font-size: 12rem;
        line-height: 16rem;
        margin-right: 6px;
        display: flex;
        align-items: center;
      }
      .author {
        font-size: 12rem;
        line-height: 16rem;
        display: flex;
        align-items: center;
        overflow: hidden;
        text-overflow: ellipsis;
        display: -webkit-box;
        line-clamp: 1;
        -webkit-line-clamp: 1;
        -webkit-box-orient: vertical;
        word-break: break-all;
      }
      .action-container {
        width: 54px;
        height: 28px;
      }
      .loading-container {
        width: 100%;
        height: 100%;
        display: flex;
        justify-content: center;
        align-items: center;
      }
      .get-button {
        width: 100%;
        height: 100%;
        --button-padding: 0;
        white-space: nowrap;
      }
      .gray-circle {
        border: solid 2px #616161;
      }
      .blue-circle {
        border: solid 2px #0078D4;
      }
      .loading-circle {
        width: 16px;
        height: 16px;
        margin: auto 0;
        border-radius: 50%;
        border-right-color: transparent;
        border-bottom-color: transparent;
        -webkit-transition: all 0.5s ease-in;
        -webkit-animation-name: rotate;
        -webkit-animation-duration: 1.0s;
        -webkit-animation-iteration-count: infinite;
        -webkit-animation-timing-function: linear;

        transition: all 0.5s ease-in;
        animation-name: rotate;
        animation-duration: 1.0s;
        animation-iteration-count: infinite;
        animation-timing-function: linear;
      }

      @keyframes rotate {
        from {
          transform: rotate(0deg);
        }
        to {
          transform: rotate(360deg);
        }
      }


      @-webkit-keyframes rotate {
        from {
          -webkit-transform: rotate(0deg);
        }
        to {
          -webkit-transform: rotate(360deg);
        }
      }

      @media (prefers-color-scheme: dark) {
        .container {
          background-color: var(--surfaces-tertiary);
        }
      }
    `}constructor(){super(),this.refreshedOnIconBroken=!1,this.isHidden=!1,this.onItemClick=()=>{this.extensionItem&&this.navigateDetail?.(this.extensionItem,!1)},this.onKeyUp=t=>{"Enter"===t.key&&this.onItemClick()},this.onIconLoaded=t=>{t.target.classList.add("loaded")},this.onGetClick=t=>{t.stopPropagation(),c(this.extensionId,r.RECOMMEND)},this.installState=a.STATE_IDLE,this.installObserver={onEvent:t=>{switch(t.id===this.extensionId&&(this.installState=t.newState),t.type){case s.INSTALL_FINISH:if(t.id===this.extensionId){this.installState=t.newState;const e=t.payload?.success;e||m(t.payload?.error)}case s.INSTALL_START:}}}}connectedCallback(){if(super.connectedCallback(),this.eventHub?.register(this.installObserver),l(this.extensionId).then((t=>{this.installState=t.state})),!this.extensionItem){const t=x(this.extensionId);if(t){const e=JSON.parse(t);this.extensionItem=e}d(this.extensionId).then((t=>{this.extensionItem={id:t.crxId,name:t.name,shortDescription:t.shortDescription,description:t.description,iconUrl:t.logoUrl,author:t.developer,rating:t.averageRating,ratingCount:t.ratingCount,version:t.version,lastUpdateDate:t.lastUpdateDate,privacyUrl:t.privacyUrl,publisherWebsiteUri:t.publisherWebsiteUri},u(this.extensionId,JSON.stringify(this.extensionItem))})).catch((()=>{this.extensionItem||(this.isHidden=!0)}))}}disconnectedCallback(){super.disconnectedCallback(),this.eventHub?.unregister(this.installObserver)}static get properties(){return{extensionId:{type:String},extensionItem:{type:Object},installState:{type:a},isHidden:{type:Boolean}}}getDescription(){return this.extensionItem?.shortDescription?this.extensionItem.shortDescription:this.extensionItem?.description}getRatingString(){return this.extensionItem?.rating?g(this.extensionItem.rating):"★".repeat(5)}getRatingCountString(){return this.extensionItem?.ratingCount?p(this.extensionItem.ratingCount):""}getA11yDescription(){return b.text("extension_detail_a11y_description",{name:this.extensionItem.name??"",description:this.getDescription()??"",rating:this.extensionItem.rating?.toString()??"",ratingCountString:this.getRatingCountString()??"",author:this.extensionItem.author??""})}getExtensionIcon(){return this.extensionItem.iconUrl?this.extensionItem.iconUrl:h()?"./resources/default_extention_icon_dark.svg":"./resources/default_extention_icon_light.svg"}render(){return this.isHidden?e``:e`
      ${o(!!this.extensionItem,(()=>e`
            <div class="container" @click=${this.onItemClick} @keyup=${this.onKeyUp} role="group" tabindex="0" aria-labelledby="container-summary">
            <div id="container-summary" hidden>
              ${this.getA11yDescription()}
            </div>
            <img class="icon" aria-hidden="true" src=${this.getExtensionIcon()} @load=${this.onIconLoaded}/>
            <div class="content" aria-hidden="true">
              <div class="title">${this.extensionItem.name}</div>
              <div class="desc">${this.getDescription()}</div>
              <div class="extra">
                <div class="rating">
                  ${this.getRatingString()}
                </div>
                <div class="rating-count">
                  ${this.getRatingCountString()}
                </div>
                <div class="divider-info">|</div>
                <div class="author">
                  ${this.extensionItem.author}
                </div>
              </div>
            </div>
            <div class="action-container" role="button">
              ${n(this.installState,[[a.STATE_IDLE,()=>e`
                  <dewey-button class="get-button" tabindex="0" size="small" type="outline-accent"
                    @click=${this.onGetClick}>${b.text("extension_action_get")}</dewey-button>`],[a.STATE_PENDING_INSTALL,()=>e`
                  <div class="loading-container"><div class="loading-circle gray-circle"></div></div>`],[a.STATE_INSTALLING,()=>e`
                  <div class="loading-container"><div class="loading-circle blue-circle"></div></div>`]])}
            </div>
          </div>
        `),(()=>e`<div class="container"><edge-loading-skeleton></edge-loading-skeleton></div>`))}
    `}});