// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import e from"../../common/i18n.js";import{css as t,html as n,LitElement as i}from"../../common/lit.js";import{closeKiwiLetter as o}from"../action.js";customElements.define("kiwi-banner",class extends i{constructor(){super(...arguments),this.isShow=!0,this.onItemClick=()=>{document.dispatchEvent(new CustomEvent("kiwi-show-letter"))},this.onCancelClick=()=>{o(),localStorage.setItem("kiwi-show-banner","false"),this.isShow=!1}}static get properties(){return{isShow:{type:Boolean}}}static get styles(){return t`
        .banner-item {
            display: flex;
            border-radius: 12px;
            box-shadow: 0px 0px 2px 0px rgba(0, 0, 0, 0.12);
            padding: 16px;
            margin: 16px;
            box-sizing: border-box;
            background-color: var(--surfaces-primary);
            justify-content: space-between;
        }

        .banner-icon {
            width: 61px;
            height: 45px;
        }

        .content {
            display: flex;
            align-items: center;
            text-align: left;
            margin-inline-start: 16px;
            margin-inline-end: 16px;
            color: var(--text-primary);
            flex-grow: 1;
        }

        .open-btn {
            min-width:50px;
            padding: 0 8px;
            color: #2169EB;
            border: none;
            background: none;
            font-weight: 600;
            font-size: 13px;
            line-height: 18px;
            letter-spacing: -0.08px;
            text-align: center;
            vertical-align: middle;
        }

        .close-btn {
            width: 20px;
            padding: 4px;
            cursor: pointer;
        }

        @media (prefers-color-scheme: dark) {
          .banner-item {
            background-color: var(--surfaces-tertiary);
          }
        }
    `}render(){return n`
      <div class="banner-item" style="display: ${this.isShow?"flex":"none"}">
        <img class="banner-icon" src="./resources/extension_mail_icon.webp" aria-hidden="true" />
        <div class="content">${e.text("extension_kiwi_campaign_letter_tip")}</div>
        <button class="open-btn" @click="${this.onItemClick}">${e.text("extension_kiwi_campaign_letter_open_button")}</button>
        <img class="close-btn" aria-label="${e.text("common_back")}" role="button" src="./resources/extension_close.svg" @click="${this.onCancelClick}"></img>
      </div>
    `}});