// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"../common/dewey/dewey-button.js";import e from"../common/i18n.js";import{css as t,html as r}from"../common/lit.js";import{sendMessage as i}from"../common/message.js";import{commonCss as n,FREBaseElement as o,scaleContainer as s}from"./edge-scfre-common.js";customElements.define("edge-scfre-extensions",class extends o{static get styles(){return t`
    ${n}
    .header-container {
      display: flex;
      justify-content: center;
      align-items: center;
      height: 40px;
      width: 100%;
      border-bottom: 0.5px solid #E1E1E1;
      padding: 6px 0px 8px 0px;
      margin-bottom: 8px;
      position: relative;
    }
    .header-text {
      color: var(--Text-Light-Primary, #212121);
      text-align: center;
      font-size: 18px;
      font-style: normal;
      font-weight: 600;
      line-height: 22px; /* 129.412% */
      letter-spacing: -0.408px;
    }
    .close-button {
      background-color: transparent;
      border: none;
      position: absolute;
      top: 50%;
      transform: translateY(-50%);
      right: calc(var(--right-margin) + 32px);
      width: 21px;
      height: 21px;
    }
    .close-button svg path {
      fill: #212121;
    }
    .image-container {
      display: inline-flex;
      justify-content: center;
      align-items: center;
      height: 742px;
      width: 1029px;
    }
    .image-container img {
      transform: translateZ(0);
    }
    .title-text {
      padding: 24px 16px 6px 16px;
      display: flex;
      justify-content: center;
      color: var(--Text-Light-Primary, #212121);
      text-align: center;
      font-size: 22px;
      font-style: normal;
      font-weight: 600;
      line-height: 26px; /* 118.182% */
      letter-spacing: 0.35px;
    }
    .subtitle-text {
      padding: 6px 16px 8px 16px;
      text-align: center;
      color: var(--Text-Light-Secondary, #6E6E6E);
      text-align: center;
      font-size: 15px;
      font-style: normal;
      font-weight: 400;
      line-height: 20px; /* 133.333% */
      letter-spacing: -0.24px;
    }
    .button-accept {
      display: flex;
      flex-direction: column;
      align-items: center;
      align-self: stretch;
      padding: 16px 16px;
    }
    .button-accept .primary {
      width: 100%;
    }

    @media (prefers-color-scheme: dark) {
      :host {
        background-color: var(--surfaces-primary);
      }
      .header-container {
        border-bottom: 0.5px solid #292929;
      }
      .header-text {
        color: var(--text-dark-primary, #E1E1E1);
      }
      .close-button svg path {
        fill: #E1E1E1;
      }
      .title-text {
        color: var(--text-dark-primary, #E1E1E1);
      }
      .subtitle-text {
        color: var(--text-dark-secondary, #919191);
      }
    }

    @media (min-aspect-ratio: 100/65) {
      .image-container {
        display: none;
      }
      .button-accept .primary {
        width: 343px;
      }
    }
    `}acceptButtonClicked(){i({action:"acceptButtonClicked"}),this.onDismiss()}declineButtonClicked(){i({action:"declineButtonClicked"}),this.onDismiss()}renderHeader(){return r`
      <div class="header-container" role="heading" aria-level="1">
        <div class="header-text">
          ${e.text(["scfre_common_whats_new_header"])}
        </div>
        ${this.renderCloseButton()}
      </div>
    `}renderCloseButton(){return r`
      <button class="close-button" @click=${this.declineButtonClicked}>
        <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
          <path d="M4.39705 4.26326L4.46967 4.17914C4.73594 3.91288 5.1526 3.88867 5.44621 4.10652L5.53033 4.17914L10.5 9.14847L15.4697 4.17914C15.7359 3.91288 16.1526 3.88867 16.4462 4.10652L16.5303 4.17914C16.7966 4.44541 16.8208 4.86207 16.6029 5.15568L16.5303 5.2398L11.561 10.2095L16.5303 15.1791C16.7966 15.4454 16.8208 15.8621 16.6029 16.1557L16.5303 16.2398C16.2641 16.5061 15.8474 16.5303 15.5538 16.3124L15.4697 16.2398L10.5 11.2705L5.53033 16.2398C5.26406 16.5061 4.8474 16.5303 4.55379 16.3124L4.46967 16.2398C4.2034 15.9735 4.1792 15.5569 4.39705 15.2633L4.46967 15.1791L9.439 10.2095L4.46967 5.2398C4.2034 4.97354 4.1792 4.55687 4.39705 4.26326L4.46967 4.17914L4.39705 4.26326Z"/>
        </svg>
      </button>
    `}renderImageExamples(){return r`
      <div class="image-container">
        <picture>
          <source srcset="./resources/extensions-dark.webp" media="(prefers-color-scheme: dark)" />
          <img src="./resources/extensions.webp" aria-hidden="true"/>
        </picture>
      </div>
    `}renderScaleContainer(){return s(r`
        ${this.renderImageExamples()}`,{callback:e=>{const t=e.children[0],r=(e.offsetWidth-32)/t.offsetWidth,i=e.offsetHeight/t.offsetHeight,n=10*Math.min(r,i)/10;t.style.transform=`translate(-50%, -50%) scale(${n})`}})}renderDescription(){return r`
      <div class="description-container">
        <div class="title-text">
          ${e.text(["scfre_extension_title"])}
        </div>
        <div class="subtitle-text">
          ${e.text(["scfre_extension_subtitle"])}
        </div>
      </div>
    `}renderButtons(){return r`
      <div class="button-accept">
        ${((t,i)=>r`
      <dewey-button class="primary" size=${t} type=${i} @click=${this.acceptButtonClicked}>
        ${e.text(["scfre_common_try_it_now"])}
      </dewey-button>
    `)("medium","accent")}
      </div>
    `}render(){return r`
    ${this.renderHeader()}
    ${this.renderScaleContainer()}
    ${this.renderDescription()}
    ${this.renderButtons()}
    `}});