// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"../common/dewey/dewey-button.js";import{urlQuery as t}from"../common/environment.js";import{init as e}from"../common/index.js";import i from"../common/i18n.js";import{css as o,html as n,LitElement as a,unsafeCSS as r}from"../common/lit.js";import{sendMessage as s}from"../common/message.js";const l="edge-mobile-personalization-upsell";customElements.define(l,class extends a{static get properties(){return{isMsaSignedIn:{type:Boolean}}}static get styles(){return o`
    :host {
      padding: 0px;
      background: transparent;
      bottom: 0px;
      position: static !important;

      box-sizing: border-box;
      width: 100%;
      height: 100%;
      display: flex;
      flex-direction: column;
      align-items: center;
      overflow: hidden;

      --safe-area-inset-top: max(env(safe-area-inset-top), ${r(t["safe-area-inset-top"]||0)}px);
      --safe-area-inset-bottom: max(env(safe-area-inset-bottom), ${r(t["safe-area-inset-bottom"]||0)}px);

      --top-max: max(calc(var(--safe-area-inset-top) + 60px), 80px);
      --bottom-max: max(var(--safe-area-inset-bottom), 20px);
      --top-min: 50px;
      --bottom-min: 20px;
      --invalid-value: calc((100vh - 500px) * 1000);

      --top-margin: clamp(var(--top-min), var(--invalid-value), var(--top-max));
      --bottom-margin: clamp(var(--bottom-min), var(--invalid-value), var(--bottom-max));
      --left-margin: env(safe-area-inset-left);
      --right-margin: env(safe-area-inset-right);
    }
    .personalization-dialog {
      bottom: 0;
      border-radius: 12px 12px 0px 0px;
      background: #FFFFFF;
      padding-bottom: 32px;
      transition: all 1s;
    }
    .personalization-image-title-container {
      display: flex;
      flex-direction: column;
      align-items: center;
      overflow: auto;
      width: 100%;
      gap: 2px;
      border-radius: 12px 12px 0px 0px;
      perspective: 1px;
      margin-top: 16px
    }
    .personalization-image-container {
      position: center;
      height: 40px;
      width: 40px;
      display: inline-block;
      justify-content: center;
      align-items: center;
    }
    .personalization-title-container {
      overflow: hidden;
      width: 90%;
      min-height: 22px;
      font-family: 'SF Pro Text';
      font-style: normal;
      font-size: 17px;
      line-height: 22px;
      text-align: center;
      letter-spacing: -0.408px;
      color: #212121;
      padding: 0px 0px 8px 0px
    }
    .personalization-description-container {
      display: flex;
      flex-direction: row;
      justify-content: center;
      align-items: flex-start;
      padding: 8px 0px 8px 0px;
      gap: 10px;

      width: 100%;
      overflow: auto;
      border-top:0.5px solid var(--divider-primary);
    }
    .personalization-description-body-container {
      width: 90%;
      overflow: hide;

      /* Caption 1/SF (12sp) */
      font-family: 'SF Pro Text';
      font-style: normal;
      font-weight: 400;
      font-size: 12px;
      line-height: 16px;
      /* or 133% */

      color: var(--text-light-secondary, #6E6E6E);
    }
    .action-text {
      display: inline;
      color: var(--accent-shade-10);
    }
    .button-portrait {
      display: flex;
      flex-direction: column;
      align-items: center;
      padding: 16px 0px 16px 0px;
      gap: 8px;

      width: 100%;
      overflow: auto;
    }
    .button-portrait .accept {
      width: 94%;
      overflow: auto;
      min-height: 40px;
    }
    .button-portrait .not-now {
      min-height: 40px;
      overflow: auto;
      width: 94%;
    }
    .button-landscape {
      display: none;
      align-items: center;
      box-sizing: border-box;
      padding: 12px 32px;
      align-self: stretch;
    }
    .button-landscape .accept {
      margin-inline-start: 26px;
    }
    .button-landscape > * {
      flex: 1;
    }
    @media (prefers-color-scheme: dark) {
      :host {
        background-color: var(--surfaces-primary);
      }
      .personalization-dialog {
        background: #212121
      }
      .personalization-title-container{
        color: var(--text-dark-primary, #E1E1E1);
      }
      .personalization-description-body-container {
        color: var(--text-dark-secondary, #919191);
      }
    }
    @media (orientation: landscape) {
      .personalization-dialog {
        padding-bottom: 8px;
      }
      .personalization-title-container {
        margin-bottom: 8px;
      }
      .personalization-description-container {
        margin-bottom: 10px;
      }
      .personalization-description-body-container {
        color: var(--text-light-secondary, #6E6E6E);
        font-size: 13rem;
        font-style: normal;
        font-weight: 500;
        letter-spacing: -0.078rem;
      }
      .button-landscape {
        display: flex;
      }
      .button-portrait {
        display: none;
      }
    }
    `}enablePersonalizationDataConsent(){s({action:"enablePersonalizationDataConsent"})}onClickLink(t){s({action:t})}dismiss(){s({action:"done"})}firstUpdated(){super.firstUpdated(),window.addEventListener("resize",(()=>{setTimeout((()=>{const t=this.renderRoot.querySelector("#personalization-dialog");s({action:"shownJsDialog",height:t.offsetHeight})}),1e3)}))}updated(){super.updated(),setTimeout((()=>{const t=this.renderRoot.querySelector("#personalization-dialog");s({action:"shownJsDialog",height:t.offsetHeight})}),1e3)}renderAvatarAndTitle(){return n`
    <div class="personalization-image-title-container">
      <div class="personalization-image-container">
        <picture>
          <source srcset="./resources/mobile-personalization-avatar-dark.png" \
                  media="(prefers-color-scheme: dark)" />
          <img src="./resources/mobile-personalization-avatar.png" \
               aria-hidden="true" height="40px" width="40px"/>
        </picture>
      </div>
      <div class="personalization-title-container">
        <div class="dalle3-copilot-text">
          ${i.text(["scfre_edge_personalization_title"])}
        </div>
      </div>
    </div>
    `}renderSubtitle(){return n`
    <div class="personalization-description-container">
        <div class="personalization-description-body-container">
            ${i.text(["scfre_edge_personalization_description"])}
            <edge-accessible-link class="action-text" @click=${()=>this.onClickLink("personalizationLearnMore")}>
            ${i.text(["common_learn_more"])}</edge-accessible-link> |
            <edge-accessible-link class="action-text" @click=${()=>this.onClickLink("privacyStatement")}>
            ${i.text(["common_microsoft_privacy_statement"])}
            </edge-accessible-link>
        </div>
    </div>
    `}renderButtons(){const e="true"===t.isDMA,o=(t,o)=>n`
      <dewey-button class="accept" size=${t} type=${o} \
                  @click=${this.enablePersonalizationDataConsent}>
          ${i.text([e?"common_yes_turn_on":"common_got_it_v2"])}
      </dewey-button>
    `,a=(t,o)=>n`
      <dewey-button class="not-now" size=${t} type=${o} \
                  @click=${this.dismiss}>
          ${i.text([e?"common_no_thanks":"common_not_now"])}
      </dewey-button>
    `;return n`
      <div class="button-portrait">
        ${o("medium",e?"outline-accent":"accent")}
        ${a("medium","outline-accent")}
      </div>
      <div class="button-landscape">
        ${a("medium","outline-accent")}
        ${o("medium",e?"outline-accent":"accent")}
      </div>
    `}render(){return n`
    <div class="personalization-dialog" id="personalization-dialog">
      ${this.renderAvatarAndTitle()}
      ${this.renderSubtitle()}
      ${this.renderButtons()}
    </div>
    `}}),e(l);