// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import C from"../../common/i18n.js";import t from"../../common/animation.js";import{html as e,css as i,when as o}from"../../common/lit.js";import{commonCss as r,voiceoverEnable as a,bottomBar as s,toolbarSVG as l,scaleContainer as n,colorTag as d,FREBaseElement as p}from"../edge-fre-common.js";customElements.define("edge-fre-adblocker",class extends p{static get styles(){return i`
    ${r}
    .head {
        align-self: flex-start;
        margin-inline-start: 32px;
        margin-inline-end: 32px;
    }
    .title {
        font-size: 26rem;
        line-height: 31rem;
        font-weight: 700;
        color: #212121;
        white-space: pre-wrap;
        text-align: start;
        margin-bottom: 12px;
    }
    .phone-wrap {
      overflow: hidden;
      width: 304px;
      height: 390px;
    }
    .phone {
        position: absolute;
        bottom: 0;
        width: 100%;
        height: calc(100% - 20px);
        box-sizing: border-box;
        border: 4px solid #F1F1F1;
        border-top-width: 0;
        border-bottom-right-radius: 33px;
        border-bottom-left-radius: 33px;
        display: flex;
        flex-direction: column;
        align-items: stretch;
    }
    .screen {
        position: absolute;
        width: 100%;
        flex-grow: 1;
        margin-top: 20px;
        display: flex;
        flex-direction: column;
        justify-content: flex-end;
        align-items: center;
        transform: translateY(25px);
        will-change: transform;
    }
    .phone-bar {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        height: 53px;
        background-color: #FFFFFF;
        border-top: 1px solid #E7E7E7;
        display: flex;
        justify-content: center;
        align-items: center;
        transform: translateZ(0px);
    }
    .ad-icon {
        width: 232px;
        height: 115px;
        position: relative;
        margin-bottom: 32px;
    }
    .ad-icon-left {
        position: absolute;
        top: 0;
        left: 0;
    }
    .ad-icon-right {
        position: absolute;
        bottom: 0;
        right: 0;
    }
    .ad-icon-tips {
        position: absolute;
        top: -21px;
        right: -22px;
        opacity: 0;
        transform: scale(0.5);
    }
    .ad-icon-line {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        opacity: 0;
    }
    .fake-text-wrap {
        flex-grow: 1;
        overflow: hidden;
        position: relative;
        display: flex;
        flex-direction: column;
    }
`}createAnimation(){const C=C=>()=>this.renderRoot.querySelector(C);return t({duration:300}).delay(1e3).add([{targets:C(".screen"),easing:"cubic-bezier(.5,0.5,.5,2.0)",transform:"translateX(0px)"},{targets:C(".ad-icon-tips"),easing:"cubic-bezier(.5,0.5,.5,2.0)",transform:"scale(1.0)",opacity:1}]).delay(500).add([{targets:C(".ad-icon-line"),opacity:1},{targets:C(".ad-icon-left"),delay:100,duration:250,transform:"translateX(-300px)"},{targets:C(".ad-icon-right"),delay:100,duration:250,transform:"translateX(300px)"},{targets:C(".ad-icon-tips"),delay:200,duration:250,opacity:0},{targets:C(".text"),delay:350,duration:1e3,easing:"ease-out",transform:"translateY(-145px)"}])}render(){return e`
      <div class="head">
        <div class="title" role="heading" aria-level="1" tabindex="0">${C.text("fre_adblocker_title")}</div>
        ${d(C.text("fre_adblocker_tag_title"))}
      </div>
      ${this.renderPhone()}
      ${o(a,(()=>s(this.onNext)),(()=>e`
          <edge-accessible-button class="skip-button" @click="${()=>this.onNext(!0)}">${C.text("fre_common_skip")}</edge-accessible-button>
        `))}
    `}renderPhone(){return n(e`
      <div class="phone-wrap">
        <div class="screen">
          ${this.adImage()}
          ${this.textSvg()}
        </div>
        <div class="phone-bar">${l()}</div>
        <div class="phone"></div>
      </div>
    `)}adImage(){return e`
        <div class="ad-icon">
          <svg class="ad-icon-left" width="232" height="69" viewBox="0 0 232 69" fill="none" xmlns="http://www.w3.org/2000/svg">
            <g clip-path="url(#clip0_1198_54409)">
              <mask id="mask0_1198_54409" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="-6" y="-4" width="263"
                height="73">
                <path d="M257 -3.5957L-6 69V-4L257 -3.5957Z" fill="#D9D9D9" />
              </mask>
              <g mask="url(#mask0_1198_54409)">
                <g clip-path="url(#clip1_1198_54409)">
                  <rect width="232" height="114.337" rx="8" fill="#1B325E" />
                  <path
                    d="M160.528 21.8595C160.182 20.1658 158.85 18.8304 157.123 18.4885C156.959 18.4559 156.959 18.2279 157.123 18.1953C158.834 17.8533 160.182 16.5342 160.528 14.8243C160.56 14.6614 160.791 14.6614 160.824 14.8243C161.169 16.5179 162.501 17.8533 164.228 18.1953C164.392 18.2279 164.392 18.4559 164.228 18.4885C162.517 18.8304 161.169 20.1496 160.824 21.8595C160.791 22.0224 160.56 22.0224 160.528 21.8595Z"
                    fill="url(#paint0_linear_1198_54409)" />
                  <path
                    d="M170.546 25.5881C170.382 24.725 169.691 24.0573 168.836 23.8945C168.754 23.8782 168.754 23.7642 168.836 23.7479C169.708 23.585 170.382 22.9011 170.546 22.0542C170.563 21.9728 170.678 21.9728 170.694 22.0542C170.859 22.9173 171.55 23.585 172.405 23.7479C172.487 23.7642 172.487 23.8782 172.405 23.8945C171.533 24.0573 170.859 24.7413 170.694 25.5881C170.678 25.6695 170.563 25.6695 170.546 25.5881Z"
                    fill="url(#paint1_linear_1198_54409)" />
                  <path
                    d="M166.772 36.7932C166.608 35.9301 165.917 35.2624 165.062 35.0995C164.979 35.0833 164.979 34.9693 165.062 34.953C165.933 34.7901 166.608 34.1061 166.772 33.2593C166.788 33.1779 166.904 33.1779 166.92 33.2593C167.084 34.1224 167.775 34.7901 168.63 34.953C168.713 34.9693 168.713 35.0833 168.63 35.0995C167.759 35.2624 167.084 35.9464 166.92 36.7932C166.904 36.8746 166.788 36.8746 166.772 36.7932Z"
                    fill="url(#paint2_linear_1198_54409)" />
                  <path
                    d="M108.656 76.2021H117.312L101.281 31.1084H92.2188L76.2188 76.2021H84.375L88.25 64.5459H104.844L108.656 76.2021ZM96.3125 39.5771H96.8438L102.969 58.3271H90.125L96.3125 39.5771ZM134.342 76.7646C139.092 76.7646 143.029 74.5459 144.967 70.7959H145.498V76.2021H152.998V28.8271H145.248V47.4834H144.717C142.904 43.7334 139.029 41.4834 134.342 41.4834C125.717 41.4834 120.279 48.2959 120.279 59.1084C120.279 69.9521 125.686 76.7646 134.342 76.7646ZM136.748 47.9521C142.061 47.9521 145.342 52.2334 145.342 59.1396C145.342 66.0771 142.092 70.3271 136.748 70.3271C131.436 70.3271 128.217 66.1396 128.217 59.1396C128.217 52.1709 131.467 47.9521 136.748 47.9521Z"
                    fill="#EBECEF" />
                </g>
              </g>
            </g>
            <defs>
              <linearGradient id="paint0_linear_1198_54409" x1="156.839" y1="22.1958" x2="161.656" y2="17.2591"
                gradientUnits="userSpaceOnUse">
                <stop stop-color="#FFA726" />
                <stop offset="0.9935" stop-color="#FFECB3" />
                <stop offset="0.9936" stop-color="#FFECB3" />
              </linearGradient>
              <linearGradient id="paint1_linear_1198_54409" x1="168.694" y1="25.7567" x2="171.113" y2="23.2774"
                gradientUnits="userSpaceOnUse">
                <stop stop-color="#FFA726" />
                <stop offset="0.9935" stop-color="#FFECB3" />
                <stop offset="0.9936" stop-color="#FFECB3" />
              </linearGradient>
              <linearGradient id="paint2_linear_1198_54409" x1="164.919" y1="36.9618" x2="167.338" y2="34.4825"
                gradientUnits="userSpaceOnUse">
                <stop stop-color="#FFA726" />
                <stop offset="0.9935" stop-color="#FFECB3" />
                <stop offset="0.9936" stop-color="#FFECB3" />
              </linearGradient>
              <clipPath id="clip0_1198_54409">
                <rect width="232" height="69" fill="white" />
              </clipPath>
              <clipPath id="clip1_1198_54409">
                <rect width="232" height="114.337" rx="8" fill="white" />
              </clipPath>
            </defs>
          </svg>
          <svg class="ad-icon-right" width="232" height="115" viewBox="0 0 232 115" fill="none"
            xmlns="http://www.w3.org/2000/svg">
            <g clip-path="url(#clip0_1198_54408)">
              <mask id="mask0_1198_54408" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="-14" y="-2" width="265"
                height="131">
                <path d="M251 -2L-14 70.5V128.5H251V-2Z" fill="#D9D9D9" />
              </mask>
              <g mask="url(#mask0_1198_54408)">
                <g clip-path="url(#clip1_1198_54408)">
                  <rect y="0.5" width="232" height="114.337" rx="8" fill="#1B325E" />
                  <path
                    d="M189.989 114.338C189.857 114.777 190.433 115.087 190.745 114.745C193.229 111.879 198.557 105.593 199.939 102.791C202.323 97.9874 200.859 94.144 200.859 94.144C200.859 94.144 196.88 95.4957 194.61 100.349C193.295 103.15 191.009 110.771 189.989 114.338Z"
                    fill="#2286C3" />
                  <path
                    d="M190.713 114.679C190.483 115.054 190.894 115.494 191.305 115.298C193.032 114.484 195.17 114.24 196.502 113.8C199.659 112.741 200.054 111.422 202.471 109.354C200.531 109.159 198.788 108.963 197.11 109.598C194.38 110.641 191.979 112.53 190.713 114.679Z"
                    fill="#2286C3" />
                  <path
                    d="M187.292 104.485C187.457 106.847 189.019 112.4 189.808 115.087C189.924 115.462 190.466 115.429 190.532 115.038C191.009 112.27 191.93 106.537 191.831 104.176C191.65 100.039 189.2 97.9712 189.2 97.9712C189.2 97.9712 187.013 100.365 187.292 104.485Z"
                    fill="#2286C3" />
                  <path d="M99.5338 115.347H77.0527C77.0527 115.347 69.422 97.4659 99.5338 115.347Z" fill="#9BE7FF" />
                  <path
                    d="M94.3531 115.349C94.3531 115.349 81.838 96.5562 96.5897 97.5008C111.341 98.4453 124.103 114.812 151.255 115.024L94.3531 115.349Z"
                    fill="#9BE7FF" />
                  <path
                    d="M45.79 102.352C43.8823 98.2645 40.5275 97.1245 40.5275 97.1245C40.5275 97.1245 39.294 100.365 41.3004 104.42C42.468 106.782 46.9577 112.074 49.0627 114.485C49.3258 114.778 49.8027 114.517 49.6876 114.143C48.816 111.146 46.8919 104.713 45.79 102.352Z"
                    fill="#2286C3" />
                  <path
                    d="M44.4581 110.511C43.0438 109.973 41.5801 110.136 39.9355 110.299C41.9748 112.042 42.3037 113.165 44.9679 114.045C46.0862 114.419 47.8952 114.615 49.3588 115.315C49.7042 115.478 50.0496 115.12 49.8522 114.794C48.7833 112.97 46.7604 111.374 44.4581 110.511Z"
                    fill="#2286C3" />
                  <path
                    d="M50.3458 100.349C50.3458 100.349 48.2901 102.092 48.1256 105.577C48.027 107.58 48.8164 112.4 49.2111 114.729C49.2604 115.055 49.7209 115.087 49.8195 114.762C50.4774 112.498 51.8094 107.824 51.941 105.821C52.1877 102.368 50.3458 100.349 50.3458 100.349Z"
                    fill="#64B5F6" />
                  <path
                    d="M168.967 115.348H155.087C155.087 115.348 154.955 109.746 161.55 112.905C163.852 114.012 166.648 115.185 168.967 115.348Z"
                    fill="#9BE7FF" />
                  <path
                    d="M137.161 115.348H123.281C123.281 115.348 123.15 109.746 129.745 112.905C132.047 114.012 134.843 115.185 137.161 115.348Z"
                    fill="#9BE7FF" />
                  <path
                    d="M27.8144 108.606C30.7418 110.267 32.189 113.117 32.8797 115.038C33.0277 115.462 33.6691 115.38 33.702 114.924C33.9157 112.156 33.6855 107.189 30.1004 103.883C28.1598 102.092 25.3312 101.88 23.5551 101.961C22.7986 101.994 22.3381 102.824 22.7657 103.46C23.7688 104.958 25.5943 107.335 27.8144 108.606Z"
                    fill="#2286C3" />
                  <path
                    d="M21.4665 101.033C22.848 105.674 25.7424 108.1 27.058 109.012C27.4198 109.257 27.9132 109.11 28.0777 108.703C28.6532 107.221 29.6729 103.655 28.1763 99.0621C27.0909 95.7074 22.0421 88.0533 19.2628 83.9983C18.8353 83.3795 17.865 83.7703 17.9965 84.5031C18.8681 89.1607 20.4798 97.6779 21.4665 101.033Z"
                    fill="#64B5F6" />
                  <path
                    d="M28.176 115.136C28.176 115.136 27.7484 107.515 25.7914 101.506C24.4922 97.4994 22.8477 94.2749 22.8477 94.2749"
                    stroke="#2286C3" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                  <path
                    d="M29.5898 98.8517C30.6424 103.558 33.8163 108.574 36.1681 113.101C36.3819 113.508 36.9903 113.346 36.9739 112.906C36.9246 108.313 36.793 102.63 35.2142 98.5749C34.211 95.9692 31.1686 99.7637 29.5898 98.8517Z"
                    fill="#64B5F6" />
                  <path
                    d="M32.2539 100.512C32.2539 100.512 33.9314 104.339 35.0003 107.547C35.7239 109.713 36.9573 112.905 36.5133 114.745"
                    stroke="#2286C3" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                  <path
                    d="M35.4612 99.161C35.3461 98.819 34.8198 98.1513 34.1456 98.3793C33.5371 98.591 32.353 100.887 31.6294 101.669C30.0506 103.395 26.8766 103.314 26.4326 102.874C26.4326 102.874 27.4851 102.907 28.1758 102.223C29.2448 101.164 27.9621 99.8938 29.327 99.0307C30.1822 98.4933 30.8894 98.7538 31.7281 98.3304C32.2215 98.0861 33.4878 97.0765 34.5567 97.6139C35.1652 97.9396 35.4612 99.161 35.4612 99.161Z"
                    fill="#9BE7FF" />
                  <path
                    d="M160.528 22.3595C160.182 20.6658 158.85 19.3304 157.123 18.9885C156.959 18.9559 156.959 18.7279 157.123 18.6953C158.834 18.3533 160.182 17.0342 160.528 15.3243C160.56 15.1614 160.791 15.1614 160.824 15.3243C161.169 17.0179 162.501 18.3533 164.228 18.6953C164.392 18.7279 164.392 18.9559 164.228 18.9885C162.517 19.3304 161.169 20.6496 160.824 22.3595C160.791 22.5224 160.56 22.5224 160.528 22.3595Z"
                    fill="url(#paint0_linear_1198_54408)" />
                  <path
                    d="M170.546 26.0881C170.382 25.225 169.691 24.5573 168.836 24.3945C168.754 24.3782 168.754 24.2642 168.836 24.2479C169.708 24.085 170.382 23.4011 170.546 22.5542C170.563 22.4728 170.678 22.4728 170.694 22.5542C170.859 23.4173 171.55 24.085 172.405 24.2479C172.487 24.2642 172.487 24.3782 172.405 24.3945C171.533 24.5573 170.859 25.2413 170.694 26.0881C170.678 26.1695 170.563 26.1695 170.546 26.0881Z"
                    fill="url(#paint1_linear_1198_54408)" />
                  <path
                    d="M166.772 37.2932C166.608 36.4301 165.917 35.7624 165.062 35.5995C164.979 35.5833 164.979 35.4693 165.062 35.453C165.933 35.2901 166.608 34.6061 166.772 33.7593C166.788 33.6779 166.904 33.6779 166.92 33.7593C167.084 34.6224 167.775 35.2901 168.63 35.453C168.713 35.4693 168.713 35.5833 168.63 35.5995C167.759 35.7624 167.084 36.4464 166.92 37.2932C166.904 37.3746 166.788 37.3746 166.772 37.2932Z"
                    fill="url(#paint2_linear_1198_54408)" />
                  <path d="M9 115.201H211" stroke="#3B3B3B" stroke-miterlimit="10" stroke-linecap="round"
                    stroke-linejoin="round" />
                  <path
                    d="M108.656 76.2021H117.312L101.281 31.1084H92.2188L76.2188 76.2021H84.375L88.25 64.5459H104.844L108.656 76.2021ZM96.3125 39.5771H96.8438L102.969 58.3271H90.125L96.3125 39.5771ZM134.342 76.7646C139.092 76.7646 143.029 74.5459 144.967 70.7959H145.498V76.2021H152.998V28.8271H145.248V47.4834H144.717C142.904 43.7334 139.029 41.4834 134.342 41.4834C125.717 41.4834 120.279 48.2959 120.279 59.1084C120.279 69.9521 125.686 76.7646 134.342 76.7646ZM136.748 47.9521C142.061 47.9521 145.342 52.2334 145.342 59.1396C145.342 66.0771 142.092 70.3271 136.748 70.3271C131.436 70.3271 128.217 66.1396 128.217 59.1396C128.217 52.1709 131.467 47.9521 136.748 47.9521Z"
                    fill="#EBECEF" />
                </g>
              </g>
            </g>
            <defs>
              <linearGradient id="paint0_linear_1198_54408" x1="156.839" y1="22.6958" x2="161.656" y2="17.7591"
                gradientUnits="userSpaceOnUse">
                <stop stop-color="#FFA726" />
                <stop offset="0.9935" stop-color="#FFECB3" />
                <stop offset="0.9936" stop-color="#FFECB3" />
              </linearGradient>
              <linearGradient id="paint1_linear_1198_54408" x1="168.694" y1="26.2567" x2="171.113" y2="23.7774"
                gradientUnits="userSpaceOnUse">
                <stop stop-color="#FFA726" />
                <stop offset="0.9935" stop-color="#FFECB3" />
                <stop offset="0.9936" stop-color="#FFECB3" />
              </linearGradient>
              <linearGradient id="paint2_linear_1198_54408" x1="164.919" y1="37.4618" x2="167.338" y2="34.9825"
                gradientUnits="userSpaceOnUse">
                <stop stop-color="#FFA726" />
                <stop offset="0.9935" stop-color="#FFECB3" />
                <stop offset="0.9936" stop-color="#FFECB3" />
              </linearGradient>
              <clipPath id="clip0_1198_54408">
                <rect width="232" height="115" fill="white" />
              </clipPath>
              <clipPath id="clip1_1198_54408">
                <rect y="0.5" width="232" height="114.337" rx="8" fill="white" />
              </clipPath>
            </defs>
          </svg>
          <svg class="ad-icon-tips" width="44" height="36" viewBox="0 0 44 36" fill="none" xmlns="http://www.w3.org/2000/svg">
            <g clip-path="url(#clip0_1059_53464)">
              <path
                d="M26.8043 15.0557C26.7078 15.0131 26.6197 14.9515 26.5316 14.8899C26.097 14.5161 26.0512 13.8361 26.4434 13.4176L29.6788 9.79457C30.0517 9.36756 30.7374 9.32884 31.1636 9.72162C31.5982 10.0954 31.644 10.7753 31.2519 11.1938L28.0164 14.8169C27.7048 15.1572 27.2096 15.2345 26.8043 15.0557Z"
                fill="url(#paint0_linear_1059_53464)" />
              <path
                d="M17.7316 10.8481C17.3842 10.6948 17.1402 10.3597 17.1009 9.97832L16.7813 5.94704C16.7321 5.3793 17.1662 4.86559 17.758 4.8309C18.3304 4.7877 18.8531 5.22305 18.8939 5.80983L19.1942 9.8326C19.2434 10.4003 18.8093 10.914 18.2175 10.9487C18.0572 10.9463 17.8667 10.9077 17.7316 10.8481Z"
                fill="url(#paint1_linear_1059_53464)" />
              <path
                d="M8.16199 14.4064C8.0269 14.3468 7.9086 14.2491 7.79871 14.1324L5.07161 11.0637C4.68994 10.6223 4.7213 9.97636 5.16294 9.60246C5.60458 9.22855 6.2567 9.26601 6.63837 9.7074L9.36547 12.7761C9.74714 13.2175 9.71578 13.8634 9.27414 14.2373C8.9685 14.512 8.52869 14.5682 8.16199 14.4064Z"
                fill="url(#paint2_linear_1059_53464)" />
              <path
                d="M32.484 23.8178C32.1366 23.6645 31.8732 23.3208 31.8508 22.9014C31.8292 22.3232 32.2743 21.837 32.8383 21.8128L36.9937 21.6442C37.577 21.6285 38.072 22.0744 38.102 22.6336C38.1319 23.1929 37.6785 23.6981 37.1144 23.7222L32.959 23.8909C32.8096 23.916 32.6384 23.8859 32.484 23.8178Z"
                fill="url(#paint3_linear_1059_53464)" />
              <path
                d="M32.8869 35.5525C32.829 35.527 32.7711 35.5014 32.7216 35.4568L29.9352 33.5677C29.4562 33.2426 29.3272 32.5942 29.6506 32.1226C29.9739 31.651 30.6269 31.5296 31.106 31.8547L33.8924 33.7439C34.3715 34.069 34.5004 34.7174 34.1771 35.189C33.879 35.6034 33.3308 35.7484 32.8869 35.5525Z"
                fill="url(#paint4_linear_1059_53464)" />
            </g>
            <defs>
              <linearGradient id="paint0_linear_1059_53464" x1="28.6947" y1="7.58907" x2="32.8976" y2="13.5936"
                gradientUnits="userSpaceOnUse">
                <stop stop-color="#FE7002" />
                <stop offset="0.9935" stop-color="#F8DA00" />
              </linearGradient>
              <linearGradient id="paint1_linear_1059_53464" x1="17.3518" y1="3.68834" x2="20.7913" y2="10.2994"
                gradientUnits="userSpaceOnUse">
                <stop stop-color="#FE7002" />
                <stop offset="0.9935" stop-color="#F8DA00" />
              </linearGradient>
              <linearGradient id="paint2_linear_1059_53464" x1="5.16558" y1="8.39066" x2="5.9148" y2="15.2771"
                gradientUnits="userSpaceOnUse">
                <stop stop-color="#FE7002" />
                <stop offset="0.9935" stop-color="#F8DA00" />
              </linearGradient>
              <linearGradient id="paint3_linear_1059_53464" x1="32.9595" y1="19.1734" x2="33.8371" y2="26.2174"
                gradientUnits="userSpaceOnUse">
                <stop stop-color="#FE7002" />
                <stop offset="0.9935" stop-color="#F8DA00" />
              </linearGradient>
              <linearGradient id="paint4_linear_1059_53464" x1="29.7972" y1="30.8643" x2="29.7974" y2="36.0491"
                gradientUnits="userSpaceOnUse">
                <stop stop-color="#FE7002" />
                <stop offset="0.9935" stop-color="#F8DA00" />
              </linearGradient>
              <clipPath id="clip0_1059_53464">
                <rect width="37" height="23" fill="white" transform="translate(9.28418) rotate(23.8069)" />
              </clipPath>
            </defs>
          </svg>
          <svg class="ad-icon-line" width="231" height="67" viewBox="0 0 231 67" fill="none" xmlns="http://www.w3.org/2000/svg">
            <line x1="-0.520549" y1="65.0684" x2="230.242" y2="2.86282" stroke="white" stroke-width="4" />
          </svg>
        </div>
        `}textSvg(){return e`
        <svg class="text" width="234" height="268" viewBox="0 0 234 268" fill="none" xmlns="http://www.w3.org/2000/svg">
          <path
            d="M1 4.15069C1.60102 4.93736 3.22923 6.41352 4.93394 6.02481C7.06482 5.53893 6.08134 0.333045 8.70397 1.8601C11.3266 3.38716 12.6379 7.82951 14.6049 6.92716C16.5718 6.02481 15.7523 1.37423 17.5553 2.90129C19.3584 4.42835 22.3088 7.34365 24.4397 5.74717C26.5706 4.15069 25.0954 1.65189 27.0624 2.90129C29.0293 4.15069 29.0293 5.74717 30.8324 5.3307C32.6354 4.91423 34.1107 2.55423 34.9302 3.526C35.7498 4.49776 36.4055 7.82951 38.0446 6.92716C39.6837 6.02481 39.8477 0.957762 41.3229 2.55423C42.7981 4.15069 43.4538 7.27422 45.2568 6.5107C47.0599 5.74717 46.5681 2.9013 48.699 3.526C50.8299 4.15069 51.3216 5.67777 52.469 5.3307C53.6164 4.98364 54.436 3.5954 55.9112 4.15069C57.0552 4.63729 59.3432 5.4645 59.3432 4.88059C59.3432 4.29667 60.4872 3.73423 61.0592 3.526L63.8047 4.15069"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M117 4.15069C116.399 4.93736 114.771 6.41352 113.067 6.02481C110.936 5.53893 111.919 0.333045 109.297 1.8601C106.674 3.38716 105.363 7.82951 103.396 6.92716C101.429 6.02481 102.248 1.37423 100.445 2.90129C98.6421 4.42835 95.6916 7.34365 93.5608 5.74717C91.4299 4.15069 92.9051 1.65189 90.9381 2.90129C88.9712 4.15069 88.9712 5.74717 87.1681 5.3307C85.3651 4.91423 83.8898 2.55423 83.0703 3.526C82.2507 4.49776 81.595 7.82951 79.9559 6.92716C78.3167 6.02481 78.1528 0.957762 76.6776 2.55423C75.2024 4.15069 74.5467 7.27422 72.7437 6.5107C70.9406 5.74717 71.4323 2.9013 69.3015 3.526C67.1706 4.15069 66.6788 5.67777 65.5314 5.3307C64.384 4.98364 62.1917 3.04197 60.7165 3.59727"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M233 4.51044C232.399 3.72377 230.771 2.24761 229.066 2.63632C226.935 3.1222 227.919 8.32809 225.296 6.80103C222.673 5.27397 221.362 0.831622 219.395 1.73397C217.428 2.63632 218.248 7.2869 216.445 5.75984C214.642 4.23278 211.691 1.31748 209.56 2.91396C207.429 4.51044 208.905 7.00924 206.938 5.75984C204.971 4.51044 204.971 2.91396 203.168 3.33043C201.365 3.7469 199.889 6.1069 199.07 5.13514C198.25 4.16337 197.595 0.831622 195.955 1.73397C194.316 2.63632 194.152 7.70337 192.677 6.1069C191.202 4.51044 190.546 1.38691 188.743 2.15043C186.94 2.91396 187.432 5.75983 185.301 5.13514C183.17 4.51044 182.678 2.98337 181.531 3.33043C180.384 3.67749 179.564 5.06574 178.089 4.51044C176.945 4.02384 174.657 3.19663 174.657 3.78054C174.657 4.36446 173.513 4.9269 172.941 5.13514L170.195 4.51044"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M117 4.12224C117.494 3.36377 118.83 1.94051 120.229 2.31529C121.978 2.78376 121.171 7.80309 123.323 6.33075C125.476 4.85842 126.552 0.575257 128.167 1.44527C129.781 2.31529 129.108 6.79921 130.588 5.32687C132.068 3.85454 134.49 1.0437 136.238 2.58297C137.987 4.12224 136.777 6.53151 138.391 5.32687C140.005 4.12224 140.005 2.58297 141.485 2.98452C142.965 3.38607 144.176 5.6615 144.848 4.72456C145.521 3.78761 146.059 0.575257 147.405 1.44527C148.75 2.31529 148.884 7.20076 150.095 5.6615C151.306 4.12224 151.844 1.11065 153.324 1.84681C154.804 2.58297 154.4 5.32687 156.149 4.72456C157.898 4.12224 158.302 2.64989 159.243 2.98452C160.185 3.31915 161.984 5.19124 163.195 4.65584"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M105.708 41.6836C105.217 42.4802 103.886 43.9749 102.493 43.5813C100.752 43.0893 101.555 37.8179 99.4119 39.3642C97.2686 40.9105 96.1969 45.4088 94.5894 44.4951C92.9819 43.5813 93.6516 38.8722 92.1781 40.4185C90.7045 41.9648 88.2933 44.9168 86.5518 43.3002C84.8103 41.6836 86.016 39.1534 84.4084 40.4185C82.8009 41.6836 82.8009 43.3002 81.3274 42.8785C79.8538 42.4568 78.6482 40.0671 77.9784 41.0511C77.3086 42.0351 76.7727 45.4088 75.4332 44.4951C74.0936 43.5813 73.9596 38.4505 72.754 40.0671C71.5483 41.6836 71.0125 44.8465 69.5389 44.0733C68.0654 43.3002 68.4673 40.4185 66.7258 41.0511C64.9843 41.6836 64.5824 43.2299 63.6447 42.8785C62.707 42.5271 62.0372 41.1213 60.8316 41.6836C59.8966 42.1764 58.0268 43.014 58.0268 42.4227C58.0268 41.8314 57.0919 41.2619 56.6244 41.0511L54.3806 41.6836"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M1 41.9113C1.60102 42.6824 3.22923 44.1294 4.93394 43.7483C7.06482 43.2721 6.08134 38.1692 8.70397 39.6661C11.3266 41.1629 12.6379 45.5173 14.6049 44.6328C16.5718 43.7483 15.7523 39.1898 17.5553 40.6866C19.3584 42.1835 22.3088 45.0411 24.4397 43.4762C26.5706 41.9113 25.0954 39.462 27.0624 40.6866C29.0293 41.9113 29.0293 43.4762 30.8324 43.068C32.6354 42.6597 34.1107 40.3464 34.9302 41.299C35.7498 42.2515 36.4055 45.5173 38.0446 44.6328C39.6837 43.7483 39.8477 38.7816 41.3229 40.3464C42.7981 41.9113 43.4538 44.973 45.2568 44.2246C47.0599 43.4762 46.5681 40.6866 48.699 41.299C50.8299 41.9113 51.3216 43.4082 52.469 43.068C53.6164 42.7278 55.8088 40.8245 57.284 41.3688"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M117 42.264C117.601 41.4929 119.229 40.0459 120.934 40.427C123.065 40.9032 122.081 46.0061 124.704 44.5092C127.327 43.0124 128.638 38.658 130.605 39.5425C132.572 40.427 131.752 44.9855 133.555 43.4887C135.358 41.9918 138.309 39.1342 140.44 40.6991C142.571 42.264 141.095 44.7133 143.062 43.4887C145.029 42.264 145.029 40.6991 146.832 41.1073C148.635 41.5156 150.111 43.8288 150.93 42.8763C151.75 41.9238 152.405 38.658 154.045 39.5425C155.684 40.427 155.848 45.3937 157.323 43.8288C158.798 42.264 159.454 39.2023 161.257 39.9507C163.06 40.6991 162.568 43.4886 164.699 42.8763C166.83 42.264 167.322 40.7671 168.469 41.1073C169.616 41.4475 170.436 42.8083 171.911 42.264C173.055 41.787 175.343 40.9762 175.343 41.5485C175.343 42.1209 176.487 42.6722 177.059 42.8763L179.805 42.264"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M233 42.264C232.399 41.4929 230.771 40.0459 229.066 40.427C226.935 40.9032 227.919 46.0061 225.296 44.5092C222.673 43.0124 221.362 38.658 219.395 39.5425C217.428 40.427 218.248 44.9855 216.445 43.4887C214.642 41.9918 211.691 39.1342 209.56 40.6991C207.429 42.264 208.905 44.7133 206.938 43.4887C204.971 42.264 204.971 40.6991 203.168 41.1073C201.365 41.5156 199.889 43.8288 199.07 42.8763C198.25 41.9238 197.595 38.658 195.955 39.5425C194.316 40.427 194.152 45.3937 192.677 43.8288C191.202 42.264 190.546 39.2023 188.743 39.9507C186.94 40.6991 187.432 43.4886 185.301 42.8763C183.17 42.264 182.678 40.7671 181.531 41.1073C180.384 41.4475 178.191 43.3508 176.716 42.8065"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M117 79.7864C116.538 78.9801 115.287 77.467 113.978 77.8654C112.341 78.3634 113.096 83.6997 111.082 82.1344C109.067 80.5691 108.06 76.0155 106.548 76.9404C105.037 77.8654 105.667 82.6324 104.282 81.0671C102.897 79.5018 100.63 76.5135 98.9932 78.15C97.3562 79.7864 98.4895 82.3478 96.9784 81.0671C95.4673 79.7864 95.4673 78.15 94.0822 78.5769C92.6971 79.0038 91.5638 81.4229 90.9342 80.4268C90.3045 79.4307 89.8009 76.0155 88.5416 76.9404C87.2824 77.8654 87.1565 83.0593 86.0232 81.4229C84.8899 79.7864 84.3862 76.5847 83.0011 77.3673C81.6159 78.15 81.9937 81.0671 80.3567 80.4268C78.7197 79.7864 78.342 78.2211 77.4605 78.5769C76.5791 78.9326 75.9494 80.3556 74.8161 79.7864C73.9373 79.2877 72.1797 78.4397 72.1797 79.0383C72.1797 79.6368 71.3008 80.2133 70.8614 80.4268L68.7522 79.7864"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M1 79.6904C1.60102 78.9098 3.22923 77.4451 4.93394 77.8308C7.06482 78.3129 6.08134 83.4785 8.70397 81.9633C11.3266 80.448 12.6379 76.0401 14.6049 76.9354C16.5718 77.8308 15.7523 82.4454 17.5553 80.9301C19.3584 79.4149 22.3088 76.5222 24.4397 78.1063C26.5706 79.6904 25.0954 82.1699 27.0624 80.9301C29.0293 79.6904 29.0293 78.1063 30.8324 78.5195C32.6354 78.9328 34.1107 81.2745 34.9302 80.3103C35.7498 79.346 36.4055 76.0401 38.0446 76.9354C39.6837 77.8308 39.8477 82.8586 41.3229 81.2745C42.7981 79.6904 43.4538 76.591 45.2568 77.3487C47.0599 78.1063 46.5681 80.9301 48.699 80.3103C50.8299 79.6904 51.3216 78.1751 52.469 78.5195C53.6164 78.8639 55.8088 80.7906 57.284 80.2395"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M117 79.3335C117.601 80.1141 119.229 81.5788 120.934 81.1931C123.065 80.711 122.081 75.5454 124.704 77.0607C127.327 78.5759 128.638 82.9839 130.605 82.0885C132.572 81.1931 131.752 76.5785 133.555 78.0938C135.358 79.609 138.309 82.5018 140.44 80.9176C142.571 79.3335 141.095 76.8541 143.062 78.0938C145.029 79.3335 145.029 80.9176 146.832 80.5044C148.635 80.0912 150.111 77.7494 150.93 78.7137C151.75 79.6779 152.405 82.9839 154.045 82.0885C155.684 81.1931 155.848 76.1653 157.323 77.7494C158.798 79.3335 159.454 82.4329 161.257 81.6753C163.06 80.9176 162.568 78.0938 164.699 78.7137C166.83 79.3335 167.322 80.8488 168.469 80.5044C169.616 80.16 170.436 78.7825 171.911 79.3335C173.055 79.8164 175.343 80.6372 175.343 80.0578C175.343 79.4784 176.487 78.9203 177.059 78.7137L179.805 79.3335"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M233 79.3335C232.399 80.1141 230.771 81.5788 229.066 81.1931C226.935 80.711 227.919 75.5454 225.296 77.0607C222.673 78.5759 221.362 82.9839 219.395 82.0885C217.428 81.1931 218.248 76.5785 216.445 78.0938C214.642 79.609 211.691 82.5018 209.56 80.9176C207.429 79.3335 208.905 76.8541 206.938 78.0938C204.971 79.3335 204.971 80.9176 203.168 80.5044C201.365 80.0912 199.889 77.7494 199.07 78.7137C198.25 79.6779 197.595 82.9839 195.955 82.0885C194.316 81.1931 194.152 76.1653 192.677 77.7494C191.202 79.3335 190.546 82.4329 188.743 81.6753C186.94 80.9176 187.432 78.0938 185.301 78.7137C183.17 79.3335 182.678 80.8488 181.531 80.5044C180.384 80.16 178.191 78.2334 176.716 78.7844"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M117 116.29C116.399 116.862 114.771 117.936 113.066 117.653C110.935 117.3 111.919 113.514 109.296 114.624C106.673 115.735 105.362 118.966 103.395 118.309C101.428 117.653 102.248 114.271 100.445 115.381C98.6416 116.492 95.6912 118.612 93.5603 117.451C91.4294 116.29 92.9046 114.473 90.9376 115.381C88.9707 116.29 88.9707 117.451 87.1676 117.148C85.3646 116.845 83.8893 115.129 83.0698 115.836C82.2502 116.542 81.5945 118.966 79.9554 118.309C78.3163 117.653 78.1523 113.968 76.6771 115.129C75.2019 116.29 74.5462 118.562 72.7432 118.006C70.9401 117.451 71.4319 115.381 69.301 115.836C67.1701 116.29 66.6784 117.401 65.531 117.148C64.3836 116.896 63.564 115.886 62.0888 116.29C60.9448 116.644 58.6568 117.246 58.6568 116.821C58.6568 116.396 57.5128 115.987 56.9408 115.836L54.1953 116.29"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M1 116.29C1.60102 116.862 3.22923 117.936 4.93394 117.653C7.06482 117.3 6.08134 113.514 8.70397 114.624C11.3266 115.735 12.6379 118.966 14.6049 118.309C16.5718 117.653 15.7523 114.271 17.5553 115.381C19.3584 116.492 22.3088 118.612 24.4397 117.451C26.5706 116.29 25.0954 114.473 27.0624 115.381C29.0293 116.29 29.0293 117.451 30.8324 117.148C32.6354 116.845 34.1107 115.129 34.9302 115.836C35.7498 116.542 36.4055 118.966 38.0446 118.309C39.6837 117.653 39.8477 113.968 41.3229 115.129C42.7981 116.29 43.4538 118.562 45.2568 118.006C47.0599 117.451 46.5681 115.381 48.699 115.836C50.8299 116.29 51.3216 117.401 52.469 117.148C53.6164 116.896 55.8088 115.484 57.284 115.888"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M117 116.552C117.601 115.98 119.229 114.906 120.934 115.189C123.065 115.542 122.081 119.328 124.704 118.218C127.327 117.107 128.638 113.876 130.605 114.532C132.572 115.189 131.752 118.571 133.555 117.46C135.358 116.35 138.309 114.23 140.44 115.391C142.571 116.552 141.095 118.369 143.062 117.46C145.029 116.552 145.029 115.391 146.832 115.694C148.635 115.996 150.111 117.713 150.93 117.006C151.75 116.299 152.405 113.876 154.045 114.532C155.684 115.189 155.848 118.874 157.323 117.713C158.798 116.552 159.454 114.28 161.257 114.835C163.06 115.391 162.568 117.46 164.699 117.006C166.83 116.552 167.322 115.441 168.469 115.694C169.616 115.946 170.436 116.956 171.911 116.552C173.055 116.198 175.343 115.596 175.343 116.021C175.343 116.446 176.487 116.855 177.059 117.006L179.805 116.552"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M233 116.552C232.399 115.98 230.771 114.906 229.066 115.189C226.935 115.542 227.919 119.328 225.296 118.218C222.673 117.107 221.362 113.876 219.395 114.532C217.428 115.189 218.248 118.571 216.445 117.46C214.642 116.35 211.691 114.23 209.56 115.391C207.429 116.552 208.905 118.369 206.938 117.46C204.971 116.552 204.971 115.391 203.168 115.694C201.365 115.996 199.889 117.713 199.07 117.006C198.25 116.299 197.595 113.876 195.955 114.532C194.316 115.189 194.152 118.874 192.677 117.713C191.202 116.552 190.546 114.28 188.743 114.835C186.94 115.391 187.432 117.46 185.301 117.006C183.17 116.552 182.678 115.441 181.531 115.694C180.384 115.946 178.191 117.358 176.716 116.954"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M1 152.509C1.60102 153.102 3.22923 154.216 4.93394 153.922C7.06482 153.556 6.08134 149.629 8.70397 150.781C11.3266 151.933 12.6379 155.284 14.6049 154.603C16.5718 153.922 15.7523 150.414 17.5553 151.566C19.3584 152.718 22.3088 154.917 24.4397 153.713C26.5706 152.509 25.0954 150.624 27.0624 151.566C29.0293 152.509 29.0293 153.713 30.8324 153.399C32.6354 153.085 34.1107 151.304 34.9302 152.038C35.7498 152.771 36.4055 155.284 38.0446 154.603C39.6837 153.922 39.8477 150.1 41.3229 151.304C42.7981 152.509 43.4538 154.865 45.2568 154.289C47.0599 153.713 46.5681 151.566 48.699 152.038C50.8299 152.509 51.3216 153.661 52.469 153.399C53.6164 153.137 54.436 152.09 55.9112 152.509C57.0552 152.876 59.3432 153.5 59.3432 153.059C59.3432 152.619 60.4872 152.195 61.0592 152.038L63.8047 152.509"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M117 152.509C116.399 153.102 114.771 154.216 113.066 153.922C110.935 153.556 111.919 149.629 109.296 150.781C106.673 151.933 105.362 155.284 103.395 154.603C101.428 153.922 102.248 150.414 100.445 151.566C98.6416 152.718 95.6912 154.917 93.5603 153.713C91.4294 152.509 92.9046 150.624 90.9376 151.566C88.9707 152.509 88.9707 153.713 87.1676 153.399C85.3646 153.085 83.8893 151.304 83.0698 152.038C82.2502 152.771 81.5945 155.284 79.9554 154.603C78.3163 153.922 78.1523 150.1 76.6771 151.304C75.2019 152.509 74.5462 154.865 72.7432 154.289C70.9401 153.713 71.4319 151.566 69.301 152.038C67.1701 152.509 66.6784 153.661 65.531 153.399C64.3836 153.137 62.1912 151.672 60.716 152.091"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M233 152.552C232.489 151.98 231.105 150.906 229.656 151.189C227.845 151.542 228.681 155.328 226.452 154.218C224.223 153.107 223.108 149.876 221.437 150.532C219.765 151.189 220.461 154.571 218.929 153.46C217.396 152.35 214.889 150.23 213.078 151.391C211.266 152.552 212.52 154.369 210.848 153.46C209.177 152.552 209.177 151.391 207.644 151.694C206.112 151.996 204.858 153.713 204.161 153.006C203.465 152.299 202.907 149.876 201.514 150.532C200.121 151.189 199.982 154.874 198.728 153.713C197.474 152.552 196.917 150.28 195.384 150.835C193.852 151.391 194.27 153.46 192.458 153.006C190.647 152.552 190.229 151.441 189.254 151.694C188.279 151.946 187.582 152.956 186.328 152.552C185.356 152.198 183.412 151.596 183.412 152.021C183.412 152.446 182.439 152.855 181.953 153.006L179.619 152.552"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M117 152.78C117.601 152.187 119.229 151.073 120.934 151.367C123.065 151.733 122.081 155.66 124.704 154.508C127.327 153.356 128.638 150.005 130.605 150.686C132.572 151.367 131.752 154.875 133.555 153.723C135.358 152.571 138.309 150.372 140.44 151.576C142.571 152.78 141.095 154.665 143.062 153.723C145.029 152.78 145.029 151.576 146.832 151.89C148.635 152.204 150.111 153.985 150.93 153.252C151.75 152.519 152.405 150.005 154.045 150.686C155.684 151.367 155.848 155.189 157.323 153.985C158.798 152.78 159.454 150.424 161.257 151C163.06 151.576 162.568 153.723 164.699 153.252C166.83 152.78 167.322 151.628 168.469 151.89C169.616 152.152 171.809 153.617 173.284 153.198"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M105.708 189.321C105.217 190.118 103.886 191.613 102.493 191.219C100.752 190.727 101.555 185.456 99.4119 187.002C97.2686 188.548 96.1969 193.046 94.5894 192.133C92.9819 191.219 93.6516 186.51 92.1781 188.056C90.7045 189.602 88.2933 192.554 86.5518 190.938C84.8103 189.321 86.016 186.791 84.4084 188.056C82.8009 189.321 82.8009 190.938 81.3274 190.516C79.8538 190.094 78.6482 187.705 77.9784 188.689C77.3086 189.673 76.7727 193.046 75.4332 192.133C74.0936 191.219 73.9596 186.088 72.754 187.705C71.5483 189.321 71.0125 192.484 69.5389 191.711C68.0654 190.938 68.4673 188.056 66.7258 188.689C64.9843 189.321 64.5824 190.868 63.6447 190.516C62.707 190.165 62.0372 188.759 60.8316 189.321C59.8966 189.814 58.0268 190.652 58.0268 190.06C58.0268 189.469 57.0919 188.9 56.6244 188.689L54.3806 189.321"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M1 189.549C1.60102 190.32 3.22923 191.767 4.93394 191.386C7.06482 190.91 6.08134 185.807 8.70397 187.304C11.3266 188.801 12.6379 193.155 14.6049 192.271C16.5718 191.386 15.7523 186.827 17.5553 188.324C19.3584 189.821 22.3088 192.679 24.4397 191.114C26.5706 189.549 25.0954 187.1 27.0624 188.324C29.0293 189.549 29.0293 191.114 30.8324 190.706C32.6354 190.297 34.1107 187.984 34.9302 188.937C35.7498 189.889 36.4055 193.155 38.0446 192.271C39.6837 191.386 39.8477 186.419 41.3229 187.984C42.7981 189.549 43.4538 192.611 45.2568 191.862C47.0599 191.114 46.5681 188.324 48.699 188.937C50.8299 189.549 51.3216 191.046 52.469 190.706C53.6164 190.365 55.8088 188.462 57.284 189.007"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M117 189.902C117.601 189.131 119.229 187.684 120.934 188.065C123.065 188.541 122.081 193.644 124.704 192.147C127.327 190.65 128.638 186.296 130.605 187.18C132.572 188.065 131.752 192.623 133.555 191.126C135.358 189.63 138.309 186.772 140.44 188.337C142.571 189.902 141.095 192.351 143.062 191.126C145.029 189.902 145.029 188.337 146.832 188.745C148.635 189.153 150.111 191.467 150.93 190.514C151.75 189.561 152.405 186.296 154.045 187.18C155.684 188.065 155.848 193.031 157.323 191.467C158.798 189.902 159.454 186.84 161.257 187.588C163.06 188.337 162.568 191.126 164.699 190.514C166.83 189.902 167.322 188.405 168.469 188.745C169.616 189.085 170.436 190.446 171.911 189.902C173.055 189.425 175.343 188.614 175.343 189.186C175.343 189.759 176.487 190.31 177.059 190.514L179.805 189.902"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M233 189.902C232.399 189.131 230.771 187.684 229.066 188.065C226.935 188.541 227.919 193.644 225.296 192.147C222.673 190.65 221.362 186.296 219.395 187.18C217.428 188.065 218.248 192.623 216.445 191.126C214.642 189.63 211.691 186.772 209.56 188.337C207.429 189.902 208.905 192.351 206.938 191.126C204.971 189.902 204.971 188.337 203.168 188.745C201.365 189.153 199.889 191.467 199.07 190.514C198.25 189.561 197.595 186.296 195.955 187.18C194.316 188.065 194.152 193.031 192.677 191.467C191.202 189.902 190.546 186.84 188.743 187.588C186.94 188.337 187.432 191.126 185.301 190.514C183.17 189.902 182.678 188.405 181.531 188.745C180.384 189.085 178.191 190.988 176.716 190.444"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M1 226.631C1.60102 226.038 3.22923 224.924 4.93394 225.217C7.06482 225.584 6.08134 229.511 8.70397 228.359C11.3266 227.207 12.6379 223.856 14.6049 224.537C16.5718 225.217 15.7523 228.725 17.5553 227.573C19.3584 226.421 22.3088 224.222 24.4397 225.427C26.5706 226.631 25.0954 228.516 27.0624 227.573C29.0293 226.631 29.0293 225.427 30.8324 225.741C32.6354 226.055 34.1107 227.835 34.9302 227.102C35.7498 226.369 36.4055 223.856 38.0446 224.537C39.6837 225.217 39.8477 229.039 41.3229 227.835C42.7981 226.631 43.4538 224.275 45.2568 224.851C47.0599 225.427 46.5681 227.573 48.699 227.102C50.8299 226.631 51.3216 225.479 52.469 225.741C53.6164 226.003 54.436 227.05 55.9112 226.631C57.0552 226.264 59.3432 225.64 59.3432 226.08C59.3432 226.521 60.4872 226.945 61.0592 227.102L63.8047 226.631"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M117 226.631C116.399 226.038 114.771 224.924 113.066 225.217C110.935 225.584 111.919 229.511 109.296 228.359C106.673 227.207 105.362 223.856 103.395 224.537C101.428 225.217 102.248 228.725 100.445 227.573C98.6416 226.421 95.6912 224.222 93.5603 225.427C91.4294 226.631 92.9046 228.516 90.9376 227.573C88.9707 226.631 88.9707 225.427 87.1676 225.741C85.3646 226.055 83.8893 227.835 83.0698 227.102C82.2502 226.369 81.5945 223.856 79.9554 224.537C78.3163 225.217 78.1523 229.039 76.6771 227.835C75.2019 226.631 74.5462 224.275 72.7432 224.851C70.9401 225.427 71.4319 227.573 69.301 227.102C67.1701 226.631 66.6784 225.479 65.531 225.741C64.3836 226.003 62.1912 227.467 60.716 227.048"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M233 226.359C232.399 226.953 230.771 228.066 229.066 227.773C226.935 227.406 227.919 223.48 225.296 224.631C222.673 225.783 221.362 229.134 219.395 228.454C217.428 227.773 218.248 224.265 216.445 225.417C214.642 226.569 211.691 228.768 209.56 227.564C207.429 226.359 208.905 224.474 206.938 225.417C204.971 226.359 204.971 227.564 203.168 227.249C201.365 226.935 199.889 225.155 199.07 225.888C198.25 226.621 197.595 229.134 195.955 228.454C194.316 227.773 194.152 223.951 192.677 225.155C191.202 226.359 190.546 228.715 188.743 228.139C186.94 227.564 187.432 225.417 185.301 225.888C183.17 226.359 182.678 227.511 181.531 227.249C180.384 226.988 179.564 225.94 178.089 226.359C176.945 226.726 174.657 227.35 174.657 226.91C174.657 226.469 173.513 226.045 172.941 225.888L170.195 226.359"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M117 226.652C117.493 227.224 118.83 228.298 120.229 228.015C121.978 227.662 121.17 223.876 123.323 224.986C125.475 226.097 126.552 229.328 128.166 228.672C129.78 228.015 129.108 224.633 130.588 225.744C132.068 226.854 134.489 228.975 136.238 227.813C137.987 226.652 136.776 224.835 138.39 225.744C140.005 226.652 140.005 227.813 141.485 227.511C142.965 227.208 144.175 225.491 144.848 226.198C145.521 226.905 146.059 229.328 147.404 228.672C148.749 228.015 148.884 224.33 150.095 225.491C151.305 226.652 151.844 228.924 153.323 228.369C154.803 227.813 154.4 225.744 156.149 226.198C157.898 226.652 158.301 227.763 159.243 227.511C160.185 227.258 161.984 225.846 163.195 226.25"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M117 263.786C116.538 262.98 115.287 261.467 113.978 261.865C112.341 262.363 113.096 267.7 111.082 266.134C109.067 264.569 108.06 260.016 106.548 260.94C105.037 261.865 105.667 266.632 104.282 265.067C102.897 263.502 100.63 260.514 98.9932 262.15C97.3562 263.786 98.4895 266.348 96.9784 265.067C95.4673 263.786 95.4673 262.15 94.0822 262.577C92.6971 263.004 91.5638 265.423 90.9342 264.427C90.3045 263.431 89.8009 260.016 88.5416 260.94C87.2824 261.865 87.1565 267.059 86.0232 265.423C84.8899 263.786 84.3862 260.585 83.0011 261.367C81.6159 262.15 81.9937 265.067 80.3567 264.427C78.7197 263.786 78.342 262.221 77.4605 262.577C76.5791 262.933 75.9494 264.356 74.8161 263.786C73.9373 263.288 72.1797 262.44 72.1797 263.038C72.1797 263.637 71.3008 264.213 70.8614 264.427L68.7522 263.786"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M1 263.69C1.60102 262.91 3.22923 261.445 4.93394 261.831C7.06482 262.313 6.08134 267.479 8.70397 265.963C11.3266 264.448 12.6379 260.04 14.6049 260.935C16.5718 261.831 15.7523 266.445 17.5553 264.93C19.3584 263.415 22.3088 260.522 24.4397 262.106C26.5706 263.69 25.0954 266.17 27.0624 264.93C29.0293 263.69 29.0293 262.106 30.8324 262.52C32.6354 262.933 34.1107 265.275 34.9302 264.31C35.7498 263.346 36.4055 260.04 38.0446 260.935C39.6837 261.831 39.8477 266.859 41.3229 265.275C42.7981 263.69 43.4538 260.591 45.2568 261.349C47.0599 262.106 46.5681 264.93 48.699 264.31C50.8299 263.69 51.3216 262.175 52.469 262.52C53.6164 262.864 55.8088 264.791 57.284 264.24"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M117 263.334C117.601 264.114 119.229 265.579 120.934 265.193C123.065 264.711 122.081 259.545 124.704 261.061C127.327 262.576 128.638 266.984 130.605 266.089C132.572 265.193 131.752 260.579 133.555 262.094C135.358 263.609 138.309 266.502 140.44 264.918C142.571 263.334 141.095 260.854 143.062 262.094C145.029 263.334 145.029 264.918 146.832 264.504C148.635 264.091 150.111 261.749 150.93 262.714C151.75 263.678 152.405 266.984 154.045 266.089C155.684 265.193 155.848 260.165 157.323 261.749C158.798 263.334 159.454 266.433 161.257 265.675C163.06 264.918 162.568 262.094 164.699 262.714C166.83 263.334 167.322 264.849 168.469 264.504C169.616 264.16 170.436 262.783 171.911 263.334C173.055 263.816 175.343 264.637 175.343 264.058C175.343 263.478 176.487 262.92 177.059 262.714L179.805 263.334"
            stroke="#DBE2E7" stroke-width="2" />
          <path
            d="M233 263.334C232.399 264.114 230.771 265.579 229.066 265.193C226.935 264.711 227.919 259.545 225.296 261.061C222.673 262.576 221.362 266.984 219.395 266.089C217.428 265.193 218.248 260.579 216.445 262.094C214.642 263.609 211.691 266.502 209.56 264.918C207.429 263.334 208.905 260.854 206.938 262.094C204.971 263.334 204.971 264.918 203.168 264.504C201.365 264.091 199.889 261.749 199.07 262.714C198.25 263.678 197.595 266.984 195.955 266.089C194.316 265.193 194.152 260.165 192.677 261.749C191.202 263.334 190.546 266.433 188.743 265.675C186.94 264.918 187.432 262.094 185.301 262.714C183.17 263.334 182.678 264.849 181.531 264.504C180.384 264.16 178.191 262.233 176.716 262.784"
            stroke="#DBE2E7" stroke-width="2" />
        </svg>
        `}});