// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"../common/controls/control-base.js";import{urlQuery as t}from"../common/environment.js";import{css as e,html as a,LitElement as i,ref as r,unsafeCSS as n}from"../common/lit.js";function o(e,a){return n("true"===t.enableHalfScreenCss?e:a)}const l=e`
  /*
   * It is an excellent solution to use the media query to adapt the screen size.
   * However, there is a bug in WebKit. When the dom is reused and the screen size changes,
   * the media query will still be in the last state.
  :host {
    --top-margin: max(calc(env(safe-area-inset-top) + 50px), 70px);
    --bottom-margin: max(env(safe-area-inset-bottom), 20px);
    --left-margin: env(safe-area-inset-left);
    --right-margin: env(safe-area-inset-right);
  }

  @media screen and (max-height: 500px) {
    :host {
      --top-margin: 40px;
      --bottom-margin: 20px;
    }
  }
  */

  :host {
    --safe-area-inset-top: max(env(safe-area-inset-top), ${n(t["safe-area-inset-top"]||0)}px);
    --safe-area-inset-bottom: max(env(safe-area-inset-bottom), ${n(t["safe-area-inset-bottom"]||0)}px);

    --top-max: ${o("0px","max(calc(var(--safe-area-inset-top) + 60px), 100px)")};
    --bottom-max: max(var(--safe-area-inset-bottom), 20px);
    --top-min: ${o(0,50)}px;
    --bottom-min: 20px;
    --invalid-value: calc((100vh - 500px) * 1000);

    --top-margin: clamp(var(--top-min), var(--invalid-value), var(--top-max));
    --bottom-margin: clamp(var(--bottom-min), var(--invalid-value), var(--bottom-max));
    --left-margin: env(safe-area-inset-left);
    --right-margin: env(safe-area-inset-right);
  }
`,s="true"===t["tablet-layout"]?e`
  :host {
    --tablet-top-margin: 12vh;
    --tablet-bottom-margin: calc(3vh + var(--bottom-margin));
    --tablet-left-margin: calc(15vw + var(--left-margin));
    --tablet-right-margin: calc(15vw + var(--right-margin));
    padding: var(--tablet-top-margin) var(--tablet-right-margin) var(--tablet-bottom-margin) var(--tablet-left-margin);
  }
  .page-number {
    top: calc(var(--tablet-top-margin) - 52px);
    left: calc(var(--tablet-left-margin) + 32px);
    right: calc(var(--tablet-right-margin) + 32px);
  }
  .page-number-with-icon-container {
      top: calc(var(--tablet-top-margin) - 52px);
      left: calc(var(--tablet-left-margin) + 28px);
      right: calc(var(--tablet-right-margin) + 32px);
  }
  @media (orientation: landscape) {
    :host {;
      --tablet-left-margin: calc(30vw + var(--left-margin));
      --tablet-right-margin: calc(30vw + var(--right-margin));
      padding: var(--tablet-top-margin) var(--tablet-right-margin) var(--tablet-bottom-margin) var(--tablet-left-margin);
    }
  }
`:e``,c=e`
  ${l}
  :host {
    box-sizing: border-box;
    padding: var(--top-margin) var(--right-margin) var(--bottom-margin) var(--left-margin);
    position: absolute;
    width: 100%;
    height: 100%;
    display: flex;
    flex-direction: column;
    align-items: center;
    background-color: #FFFFFF;
    overflow: hidden;
  }
  .page-number {
    position: absolute;
    top: calc(var(--top-margin) - 52px);
    left: calc(var(--left-margin) + 32px);
    right: calc(var(--right-margin) + 32px);
    font-size: 13px;
    white-space: pre-wrap;
    color: var(--text-secondary);
  }
  .page-number-with-icon-container {
    position: absolute;
    display: flex;
    align-items: center;
    flex-direction: row;
    justify-content: between-space;
    top: calc(var(--top-margin) - 52px);
    left: calc(var(--left-margin) + 28px);
    right: calc(var(--right-margin) + 32px);
    height: 40px;
  }
  .page-icon {
    height: 40px;
    object-fit: contain;
    pointer-events: none;
    margin-inline-end: auto;
  }
  .page-number-with-icon {
    font-size: 13px;
    white-space: pre-wrap;
    color: var(--text-secondary);
  }
  .skip-button {
    color: #6E6E6E;
    height: 40px;
    font-weight: 500;
    font-size: 15rem;
    line-height: 20rem;
    display: flex;
    align-items: center;
    justify-content: center;
    box-sizing: border-box;
    padding: 0 20px;
    white-space: nowrap;
  }
  .skip-button:active {
    color: #C7E0F4;
  }
  .bottom-bar {
    align-self: stretch;
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0 32px 0 16px;
    font-weight: 500;
    font-size: 15rem;
    line-height: 20rem;
  }
  .bottom-bar > * {
    display: flex;
    align-items: center;
    justify-content: center;
    height: 40px;
    padding: 0 16px;
  }
  .bottom-bar-skip {
    color: #0078D4;
  }
  .bottom-bar-next {
    background: #0078D4;
    border-radius: 8px;
    color: white;
  }
  *:focus:not(.focus-visible) {
    outline: none;
  }
  @media screen and (max-height: 500px) {
    .page-number, .page-number-with-icon-container {
      top: 20px;
    }
    :host {
      padding-top: calc(var(--top-margin) + ${o(0,10)}px);
    }
  }
  ${s}
`;function p(t,e={}){const{callback:i,widthRadio:n=.8,heightRadio:o=.8}=e;let l;return a`
    <style>
      .scale-container {
        flex: 1;
        width: 100%;
        position: relative;
      }
      .scale-container > * {
        position: absolute;
        top: 50%;
        left: 50%;
      }
    </style>
    <div class="scale-container" aria-hidden="true" ${r((t=>{l&&l.disconnect(),t&&(l=new ResizeObserver((t=>{const e=t[0]?.target;e&&(i?i(e):(t=>{const e=t.children[0],a=t.offsetWidth*n/e.offsetWidth,i=t.offsetHeight*o/e.offsetHeight,r=Math.round(10*Math.min(a,i))/10;e.style.transform=`translate(-50%, -50%) scale(${r})`})(e))})),l.observe(t))}))}>
      ${t}
    </div>
  `}function m(t,e){return a`
  <div class=${e}>
    <div class="gradient-label">${t}</div>
  </div>
  <style>
    .gradient-label {
      --r:4px; /* radius */
      --b:1px; /* border width */

      background: linear-gradient(90deg, #5D00D4 0.01%, #38C3FF 99.98%);
      background-clip: text;
      color: transparent;
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;

      border-radius: var(--r);
      position: relative;
      padding: 4px 8px;
    }
    .gradient-label:before {
      content: "";
      position: absolute;
      inset: 0;
      border: var(--b) solid transparent;
      border-radius: var(--r);
      background: inherit;
      background-origin: border-box;
      background-clip: border-box;
      -webkit-mask: /*4*/
        linear-gradient(#fff 0 0) padding-box,
        linear-gradient(#fff 0 0);
      -webkit-mask-composite: xor;
        mask-composite: exclude;
      -webkit-mask-repeat: no-repeat;
    }
    @media (prefers-color-scheme: dark) {
      .gradient-label {
        background: linear-gradient(90deg, #B696FF 0.01%, #69A1FA 51.03%, #4CB4B7 99.98%);
        background-clip: text;
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
      }
    }
  </style>
  `}class g extends i{static get shadowRootOptions(){return{...i.shadowRootOptions,delegatesFocus:!0}}firstUpdated(){super.firstUpdated()}disconnectedCallback(){super.disconnectedCallback(),this.ariaTimer&&(clearInterval(this.ariaTimer),this.ariaTimer=null)}}export{l as constantCss,c as commonCss,p as scaleContainer,m as gradientLabel,g as FREBaseElement};