// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{html as t,css as e,repeat as i,when as o,LitElement as s,unsafeCSS as n}from"../../lit.js";import r from"../../animation.js";import{getOsType as a}from"../../environment.js";import{typographyStyles as d}from"../tokens/dewey-tokens.typography.js";import{durations as l,easings as c}from"../tokens/dewey-tokens.motion.js";import{deweyTokens as m}from"../tokens/dewey-tokens.js";customElements.define("dewey-snackbar",class extends s{static get styles(){const t="iOS"===a()?"--color-neutral-background-dark-static-transparency":"--color-neutral-background-dark-static-solid";return e`
      :host {
        position: fixed;
        left: 0;
        right: 0;
        bottom: 0px;
        display: flex;
        flex-direction: column;
        align-items: center;
      }
        
      .item {
        position: absolute;
        display: flex;
        align-items: center;
        padding: 14px 16px 14px 16px;
        width: min(80vw, 326px);
        border-radius: ${n(m.borderRadiusMedium)};
        box-shadow: 0px 8px 16px 0px rgba(0, 0, 0, 0.14), 0px 0px 2px 0px rgba(0, 0, 0, 0.12);
        background-color: var(${n(t)});
      }

      .icon {
        width: 24px;
        height: 24px;
        margin-inline-end: 16px;
        object-fit: contain;
        pointer-events: none;
      }

      .content {
        flex: 1;
        display: flex;
        flex-direction: column;
      }

      .text {
        overflow: hidden;
        text-overflow: ellipsis;
        display: -webkit-box;
        -webkit-box-orient: vertical;
        -webkit-line-clamp: 2;
        color: var(--color-neutral-foreground-static-inverted-solid);
        font-weight: ${n(d.body2.fontWeight)};
        font-size: ${n(d.body2.fontSize)};
        line-height: ${n(d.body2.lineHeight)};
      }

      .action {
        margin-inline-start: 8px;
        color: var(--color-brand-foreground2-dark);
        font-weight: ${n(d.body2Strong.fontWeight)};
        font-size: ${n(d.body2Strong.fontSize)};
        line-height: ${n(d.body2Strong.lineHeight)};
      }

      .close {
        margin-inline-start: 12px;
      }
    `}static get properties(){return{items:{type:Array}}}constructor(){super(),this.items=[],this.sequenceId=0,this.animation=r()}clearMoreItem(){const t=[...this.items];for(;t.length>1;){const e=t.shift();e.onClose?.()}this.items=t}checkEmpty(){0===this.items.length&&this.animation.isFinished()&&this.remove()}scheduleDismiss(t){t.timer&&clearTimeout(t.timer),t.timer=setTimeout((()=>{t.timer=void 0,this.dismissItem(t)}),t.duration||3e3)}appendItem(t){let e=this.items[0];return e?.timer?(e={...e,...t},this.items=[e]):(e={...t,id:"snackbar-"+ ++this.sequenceId},this.showItem(e)),this.scheduleDismiss(e),e}showItem(t){this.animation.add((()=>(this.items=[...this.items,t],this.clearMoreItem(),this.updateComplete))).add((()=>{const e=this.shadowRoot?.querySelector("#"+t.id),i=t.bottomMarginPx||40;e.style.marginBottom=`${i}px`,e.style.transform="translateY(20px)",e.style.position="relative",e.style.opacity="0"})).add(0).add({targets:()=>this.shadowRoot?.querySelector("#"+t.id),duration:l.durationMedium02,transform:"translateY(0px)",easing:c.easingDecelerate01,opacity:"1"}).run()}dismissItem(t){const e=this.shadowRoot?.querySelector("#"+t.id);e&&this.animation.add({targets:e,duration:l.durationShort03,easing:c.easingAccelerate01,transform:"translateY(20px)",opacity:"0"}).add((()=>(t.onClose?.(),this.items=this.items.filter((e=>e.id!==t.id)),this.updateComplete))).add((()=>{setTimeout((()=>{this.checkEmpty()}),1e3)})).run()}render(){return i(this.items,(t=>t.id),(e=>t`
      <div class="item" id=${e.id} role="log" aria-atomic="false" aria-relevant="additions">
        ${o(!!e.icon,(()=>t`<img class="icon" aria-hidden="true" src=${e.icon}>`))}
        <div class="content">
          ${o(!!e.text,(()=>t`<div class="text">${e.text}</div>`))}
        </div>
        ${o(!!e.actionTitle,(()=>t`<div class="action" role="button" @click=${e.onAction}>${e.actionTitle}
        </div>`))}
        ${o(!!e.showClose,(()=>t`
        <svg
          class="close"
          role="button" width="20" height="20" viewBox="0 0 20 20"
          fill="var(--color-neutral-foreground-static-inverted-solid)"
          @click=${()=>this.dismissItem(e)}
          xmlns="http://www.w3.org/2000/svg">
          <path d="M3.89705 4.05379L3.96967 3.96967C4.23594 3.7034 4.6526 3.6792 4.94621 3.89705L5.03033 3.96967L10 8.939L14.9697 3.96967C15.2359 3.7034 15.6526 3.6792 15.9462 3.89705L16.0303 3.96967C16.2966 4.23594 16.3208 4.6526 16.1029 4.94621L16.0303 5.03033L11.061 10L16.0303 14.9697C16.2966 15.2359 16.3208 15.6526 16.1029 15.9462L16.0303 16.0303C15.7641 16.2966 15.3474 16.3208 15.0538 16.1029L14.9697 16.0303L10 11.061L5.03033 16.0303C4.76406 16.2966 4.3474 16.3208 4.05379 16.1029L3.96967 16.0303C3.7034 15.7641 3.6792 15.3474 3.89705 15.0538L3.96967 14.9697L8.939 10L3.96967 5.03033C3.7034 4.76406 3.6792 4.3474 3.89705 4.05379L3.96967 3.96967L3.89705 4.05379Z" fill="white"/>
        </svg>
        `))}
      </div>
    `))}});export function showSnackbar(t){let e=document.body.querySelector("dewey-snackbar");e||(e=document.createElement("dewey-snackbar"),document.body.appendChild(e));const i=e.appendItem(t);return{dismiss:()=>e.dismissItem(i)}}