// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{LitElement as e,html as a,css as t,unsafeCSS as i}from"../lit.js";import{init as d}from"../index.js";import{getOsType as n,isTestMode as o}from"../environment.js";import"./dewey-button.js";import"./controls/dewey-radio.js";import"./controls/dewey-checkbox.js";import"./controls/dewey-toggle.js";import"./avatar/dewey-avatar.js";import{typographyStyles as s}from"./tokens/dewey-tokens.typography.js";import{showSnackbar as y}from"./snackbar/dewey-snackbar.js";const r="dewey-hybrid-demo";customElements.define(r,class extends e{static get styles(){return t`
      :host {
        position: absolute;
        width: 100%;
        height: 100%;
        display: flex;
        flex-direction: column;
        justify-content: flex-start;
        align-items: center;
      }
      .row {
        margin-top: 10px;
      }

      .row > dewey-button {
        margin-left: 10px;
      }

      .largeTitle {
        font-family: ${i(s.largeTitle.fontFamily)};
        font-size: ${i(s.largeTitle.fontSize)};
        font-weight: ${i(s.largeTitle.fontWeight)};
        line-height: ${i(s.largeTitle.lineHeight)};
      }
      .title1 {
        font-family: ${i(s.title1.fontFamily)};
        font-size: ${i(s.title1.fontSize)};
        font-weight: ${i(s.title1.fontWeight)};
        line-height: ${i(s.title1.lineHeight)};
      }

      .title2 {
        font-family: ${i(s.title2.fontFamily)};
        font-size: ${i(s.title2.fontSize)};
        font-weight: ${i(s.title2.fontWeight)};
        line-height: ${i(s.title2.lineHeight)};
      }
    `}constructor(){super()}toggleDevice(){const e=new URLSearchParams(window.location.search),a="android"===n()?"iOS":"android";e.set("osType",a),window.location.replace(`${window.location.pathname}?${e.toString()}`)}showSnackbar(){y({text:"This is a demo snackbar message!",showClose:!0,actionTitle:"Action",bottomMarginPx:60})}render(){const e="android"===n();return a`
      ${o?a`
        <div class="row">
          <label>
            <input type="checkbox" @change=${()=>this.toggleDevice()} ?checked=${e}>
            Switch into ${e?"iOS":"Android"}
          </label>
        </div>
      `:""}
      <h1 class="largeTitle">Dewey Hybrid Demo</h1>

      <h2 class="title1">Buttons</h2>
       <div class="row">
      <dewey-button type="accent" size="large">
        Text
      </dewey-button>
      <dewey-button type="accent" size="large" .disabled=${!0}>
        Text
      </dewey-button>
    </div>
    <div class="row">
      <dewey-button type="outline-accent" size="large">
        Text
      </dewey-button>
      <dewey-button type="outline-accent" size="large" .disabled=${!0}>
        Text
      </dewey-button>
    </div>
    <div class="row">
      <dewey-button type="outline" size="large">
        Text
      </dewey-button>
      <dewey-button type="outline" size="large" .disabled=${!0}>
        Text
      </dewey-button>
    </div>
    <div class="row">
      <dewey-button type="subtle" size="large">
        Text
      </dewey-button>
      <dewey-button type="subtle" size="large" .disabled=${!0}>
        Text
      </dewey-button>
    </div>
    <div class="row">
      <dewey-button type="destructive" size="large">
        Text
      </dewey-button>
      <dewey-button type="destructive" size="large" .disabled=${!0}>
        Text
      </dewey-button>
    </div>

    <h2 class="title1">Controls</h2>
    <h3 class="title2">Checkbox</h3>
    <div>
    <dewey-checkbox></dewey-checkbox>
    <dewey-checkbox checked></dewey-checkbox>
    <dewey-checkbox disabled></dewey-checkbox>
    <dewey-checkbox disabled checked></dewey-checkbox>
    </div>
    <h3 class="title2">Radio Button</h3>
    <div>
    <dewey-radio-button> </dewey-radio-button>
    <dewey-radio-button checked> </dewey-radio-button>
    <dewey-radio-button disabled> </dewey-radio-button>
    <dewey-radio-button disabled checked> </dewey-radio-button>
    <dewey-radio-button type='circle'> </dewey-radio-button>
    </div>

    <h3 class="title2">Toggle</h3>
    <div>
    <dewey-toggle> </dewey-toggle>
    <dewey-toggle checked> </dewey-toggle>
    <dewey-toggle disabled> </dewey-toggle>
    <dewey-toggle disabled checked> </dewey-toggle>
    </div>

    <h2 class="title1"> Avatar </h2>
    <div>
    <dewey-avatar badge="sync-on" image='non-sign-in' size=24 ></dewey-avatar>
    <dewey-avatar badge="sync-on" image='non-sign-in' size=32 ></dewey-avatar>
    <dewey-avatar badge="sync-on" image='non-sign-in' size=40 ></dewey-avatar>
    <dewey-avatar badge="sync-on" image='non-sign-in' size=56 ></dewey-avatar>
    <dewey-avatar badge="sync-on" image='non-sign-in' size=64 ></dewey-avatar>
    <dewey-avatar badge="sync-on" image='non-sign-in' size=72 ></dewey-avatar>
    </div>
    <div>
    <dewey-avatar badge="sync-on" image='msa' size=24 ></dewey-avatar>
    <dewey-avatar badge="sync-on" image='msa' size=32 ></dewey-avatar>
    <dewey-avatar badge="sync-on" image='msa' size=40 ></dewey-avatar>
    <dewey-avatar badge="sync-on" image='msa' size=56 ></dewey-avatar>
    <dewey-avatar badge="sync-on" image='msa' size=64 ></dewey-avatar>
    <dewey-avatar badge="sync-on" image='msa' size=72 ></dewey-avatar>
    </div>
    <div>
    <dewey-avatar badge="sync-on" image='aad' size=24 ></dewey-avatar>
    <dewey-avatar badge="sync-on" image='aad' size=32 ></dewey-avatar>
    <dewey-avatar badge="sync-on" image='aad' size=40 ></dewey-avatar>
    <dewey-avatar badge="sync-on" image='aad' size=56 ></dewey-avatar>
    <dewey-avatar badge="sync-on" image='aad' size=64 ></dewey-avatar>
    <dewey-avatar badge="sync-on" image='aad' size=72 ></dewey-avatar>
    </div>
    <div>
    <dewey-avatar badge="sync-on" image='./avatar/Avatar-image.png' size=24 ></dewey-avatar>
    <dewey-avatar badge="sync-on" image='./avatar/Avatar-image.png' size=32 ></dewey-avatar>
    <dewey-avatar badge="sync-on" image='./avatar/Avatar-image.png' size=40 ></dewey-avatar>
    <dewey-avatar badge="sync-on" image='./avatar/Avatar-image.png' size=56 ></dewey-avatar>
    <dewey-avatar badge="sync-on" image='./avatar/Avatar-image.png' size=64 ></dewey-avatar>
    <dewey-avatar badge="sync-on" image='./avatar/Avatar-image.png' size=72 ></dewey-avatar>
    </div>
    <div>
    <dewey-avatar badge="sync-on" image='aad' size=56 ></dewey-avatar>
    <dewey-avatar badge="sync-off" image='aad' size=56 ></dewey-avatar>
    <dewey-avatar badge="syncing" image='aad' size=56 ></dewey-avatar>
    <dewey-avatar badge="connected" image='aad' size=56 ></dewey-avatar>
    <dewey-avatar badge="disconnected" image='aad' size=56 ></dewey-avatar>
    </div>

    <h3 class="title1">Snackbar</h3>
    <div class="row">
      <dewey-button @click=${()=>this.showSnackbar()}>Show Snackbar</dewey-button>
    </div>
    `}}),d(r);