// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{html as r,css as o,classMap as e,LitElement as d,unsafeCSS as l}from"../lit.js";import{MixinKeyEvent as t,MixinAttributes as a}from"../controls/control-base.js";import{deweyTokens as n}from"./tokens/dewey-tokens.js";var s,i;!function(r){r.LARGE="large",r.MEDIUM="medium",r.SMALL="small"}(s||(s={})),function(r){r.ACCENT="accent",r.OUTLINE_ACCENT="outline-accent",r.OUTLINE="outline",r.SUBTLE="subtle",r.DESTRUCTIVE="destructive"}(i||(i={}));customElements.define("dewey-button",a(t(class extends d{static get properties(){return{size:{type:String},type:{type:String},disabled:{type:Boolean}}}static get styles(){return o`
      :host {
        position: relative;
        display: inline-block;
        -webkit-tap-highlight-color: transparent;
      }
      .container {
        width: 100%;
        height: 100%;
        display: flex;
        align-items: center;
        justify-content: center;
        box-sizing: border-box;
        transition: all 100ms;
        font-weight: 600;
      }
      .large {
        min-height: 52px;
        font-size: 17rem;
        border-radius: ${l(n.borderRadiusMedium)};
        padding: 0 20px;
      }
      .medium {
        min-height: 40px;
        font-size: 15rem;
        border-radius: ${l(n.borderRadiusSmall)};
        padding: 0 12px;
      }
      .small {
        min-height: 28px;
        font-size: 13rem;
        border-radius: ${l(n.borderRadiusSmall)};
        padding: 0 8px;
      }
      .accent {
        background-color: var(--color-brand-background1);
        color: var(--color-neutral-foreground-static-inverted-solid);
      }
      .accent:active {
        background-color: var(--color-brand-background1-pressed);
        color: var(--color-neutral-foreground-static-inverted-solid);
      }
      .accent.disabled {
        background-color: var(--color-neutral-background4-solid);
        color: var(--color-neutral-foreground-disabled-solid);
      }
      .outline-accent {
        border: 1px solid var(--color-brand-stroke1);
        color: var(--color-brand-foreground1);
      }
      .outline-accent:active {
        border: 1px solid var(--color-brand-stroke1-pressed);
        color: var(--color-brand-foreground1-pressed);
      }
      .outline-accent.disabled {
        border: 1px solid var(--color-neutral-stroke-disabled-transparency);
        color: var(--color-neutral-foreground-disabled-solid);
      }
      .outline {
        border: 1px solid var(--color-neutral-stroke1-solid);
        color: var(--color-neutral-foreground1);
      }
      .outline:active {
        border: 1px solid var(--color-neutral-stroke1-pressed-solid);
        color: var(--color-neutral-foreground1-pressed);
      }
      .outline.disabled {
        border: 1px solid var(--color-neutral-stroke-disabled-transparency);
        color: var(--color-neutral-foreground-disabled-solid);
      }
      .subtle {
        color: var(--color-brand-foreground1);
      }
      .subtle:active {
        color: var(--color-brand-foreground1-pressed);
      }
      .subtle.disabled {
        color: var(--color-neutral-foreground-disabled-solid);
      }
      .destructive {
        color: var(--color-shared-red-foreground3);
      }
      .destructive:active {
        color: var(--color-shared-red-foreground1);
      }
      .destructive.disabled {
        color: var(--color-neutral-foreground-disabled-solid);
      }
      .disabled {
        pointer-events:none;
      }

      @media (prefers-color-scheme: dark) {
        .outline-accent {
          color: var(--color-brand-foreground2);
        }
        .outline-accent.active {
          color: var(--color-brand-foreground2-pressed);
        }
        .subtle {
          color: var(--color-brand-foreground2);
        }
        .subtle.active {
          color: var(--color-brand-foreground2-pressed);
        }
        .destructive {
          color: var(--color-shared-red-foreground1);
        }
        .destructive.active {
          color: var(--color-shared-red-foreground3);
        }
      }
    `}constructor(){super(),this.size=s.MEDIUM,this.type=i.ACCENT,this.disabled=!1}render(){return r`
      <div class=${e({container:!0,disabled:this.disabled,[this.size]:!0,[this.type]:!0})}>
        <slot></slot>
      </div>
    `}}),{role:"button"}));