// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{html as t,css as e,when as i,repeat as o,LitElement as s}from"../lit.js";import"./control-base.js";function n(t,e,i,o){const s={x:0,y:0},n={x:0,y:0};t.startsWith("top")?(s.y=i.height-1,n.y=e.top-i.height-15):t.startsWith("bottom")&&(s.y=1-o.height,n.y=e.bottom+15);const r=(i.width-o.width)/2;t.endsWith("Left")?(s.x=Math.min(24,r),n.x=Math.min(e.left,e.left+(e.width-o.width)/2-s.x)):t.endsWith("Right")?(s.x=Math.max(i.width-24-o.width,r),n.x=Math.max(e.right-i.width,e.left+(e.width-o.width)/2-s.x)):"top"!==t&&"bottom"!==t||(s.x=r,n.x=e.left+(e.width-i.width)/2),t.startsWith("left")?(s.x=i.width-1,n.x=e.left-i.width-15):t.startsWith("right")&&(s.x=1-o.height,n.x=e.right+15);const h=(i.height-o.height)/2;return t.endsWith("Top")?(s.y=Math.min(24,h),n.y=Math.min(e.top,e.top+(e.height-o.height)/2-s.y)):t.endsWith("Bottom")?(s.y=Math.max(i.height-24-o.height,h),n.y=Math.max(e.bottom-i.height,e.top+(e.height-o.height)/2-s.y)):"left"!==t&&"right"!==t||(s.y=h,n.y=e.top+(e.height-i.height)/2),{arrowOffset:s,contentOffset:n}}function r(t,e){const i=Math.min(t.right,e.right)-Math.max(t.x,e.x),o=Math.min(t.bottom,e.bottom)-Math.max(t.y,e.y);return Math.max(i,0)*Math.max(o,0)}export class EdgeTooltip extends s{constructor(){super(...arguments),this.onClickMask=()=>{this.props.maskClosable&&this.clear()},this.onClickClose=t=>{t.stopPropagation(),this.clear()}}static get styles(){return e`
      :host {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        z-index: var(--layer-universal-top);
      }
      .mask {
        position: absolute;
        width: 100%;
        height: 100%;
        transition: all 250ms linear;
      }
      .content {
        position: absolute;
        background: var(--accent-primary);
        border-radius: 8px;
        display: flex;
        flex-direction: column;
        padding: 12px;
        box-sizing: border-box;
        transition: all 250ms linear;
      }
      .main {
        display: flex;
        align-items: center;
      }
      .text {
        flex: 1;
        color: white;
        font-size: 15rem;
        line-height: 20rem;
      }
      .icon {
        align-self: flex-start;
        width: 36px;
        height: 36px;
        object-fit: cover;
        pointer-events: none;
        margin-inline-end: 12px;
        pointer-events: none;
      }
      .close {
        margin-inline-start: 12px;
      }
      .arrow {
        position: absolute;
        fill: var(--accent-primary);
      }
      .button-list {
        display: flex;
        justify-content: flex-end;
        margin-top: 12px;
      }
      .button {
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 10px 16px;
        font-weight: 500;
        font-size: 15px;
        line-height: 20px;
        margin-inline-end: 8px;
        color: #FFFFFF;
      }
      .button:last-child {
        margin-inline-end: 0;
        color: var(--accent-primary);
        background: #FFFFFF;
        border-radius: 8px;
      }
    `}static get properties(){return{maskStyle:{type:String},props:{type:Object},show:{type:Boolean}}}firstUpdated(){const t=this.props.showTipAnimationDuration??500;setTimeout((()=>{this.show=!0}),t),this.updateContent()}async updateContent(){const{target:e,placement:i,duration:o,maskAnimation:s=!0}=this.props;this.timer&&(clearTimeout(this.timer),this.timer=void 0),this.resizeObserver&&(this.resizeObserver.disconnect(),this.resizeObserver=void 0),await this.updateComplete;const h=this.shadowRoot?.querySelector(".content"),a=this.shadowRoot?.querySelector(".arrow"),d=document?.querySelector("body"),l=new ResizeObserver((()=>{const o=getComputedStyle(e),l=e.getBoundingClientRect(),c=this.getBoundingClientRect(),p=h.getBoundingClientRect(),g=a.getBoundingClientRect(),m=2*Math.max(c.width,c.height);let x=0,u=i,f={x:0,y:0},w={x:0,y:0};const b=function(t,e,i){const o=new Set;return t?(o.add(t),o):(e.left+e.width/2<i.width/2?(o.add("right"),e.top+e.height/2<i.height/2?(o.add("bottom"),o.add("bottomLeft"),o.add("rightTop")):(o.add("top"),o.add("topLeft"),o.add("rightBottom"))):(o.add("left"),e.top+e.height/2<i.height/2?(o.add("bottom"),o.add("bottomRight"),o.add("leftTop")):(o.add("top"),o.add("topRight"),o.add("leftBottom"))),o)}(i,l,c);for(const t of b){const e=n(t,l,p,g),i=r(c,new DOMRect(e.contentOffset.x,e.contentOffset.y,p.width,p.height));if(i>x&&(x=i,u=t,f=e.arrowOffset,w=e.contentOffset),i===p.width*p.height)break}const y=t`
        <style>
          :host {
            height: ${d.clientHeight}px;
          }
          .mask.focus {
            transform: translate(${l.left}px, ${l.top}px);
            box-shadow: 0 0 0 ${m}px rgba(0, 0, 0, 0.4);
            width: ${l.width}px;
            height: ${l.height}px;
            border-radius: ${o.borderRadius};
            transition: ${s?"all 250ms linear":"none"};
          }
          .content {
            transform: translate(${w.x}px, ${w.y+window.scrollY}px);
          }
          .arrow {
            left: ${f.x}px;
            top: ${f.y}px;
            transform: ${function(t){return t.startsWith("top")?"rotate(180deg)":t.startsWith("left")?"rotate(90deg)":t.startsWith("right")?"rotate(-90deg)":"unset"}(u)};
          }
        </style>
      `;this.maskStyle=y}));l.observe(this),l.observe(e),l.observe(h),this.resizeObserver=l,this.addEventListener("click",this.onClickMask),this.addEventListener("touchmove",this.onClickMask),o&&(this.timer=setTimeout((()=>{this.clear()}),o))}clear(){this.remove(),this.props.onCancel?.(),this.timer&&(clearTimeout(this.timer),this.timer=void 0),this.resizeObserver&&(this.resizeObserver.disconnect(),this.resizeObserver=void 0)}render(){const{text:e,icon:s,mask:n=!0,showClose:r,actions:h,textWidth:a=200}=this.props;return t`
      ${i(n,(()=>t`<div class="mask focus"></div>`))}
      <div class="content" role="dialog" aria-modal="true" @click=${t=>t.stopPropagation()}>
        <div class="main">
          ${i(!!s,(()=>t`<img class="icon" aria-hidden="true" src=${s}>`))}
          <div class="text" tabindex="1" id="dialog-title">
            ${e}
          </div>
          ${i(!!r,(()=>t`
          <svg class="close" role="button" width="20" height="20" viewBox="0 0 20 20" @click=${this.onClickClose}
            xmlns="http://www.w3.org/2000/svg">
            <path
              d="M4.14705 4.30379L4.21967 4.21967C4.48594 3.9534 4.9026 3.9292 5.19621 4.14705L5.28033 4.21967L10.25 9.189L15.2197 4.21967C15.4859 3.9534 15.9026 3.9292 16.1962 4.14705L16.2803 4.21967C16.5466 4.48594 16.5708 4.9026 16.3529 5.19621L16.2803 5.28033L11.311 10.25L16.2803 15.2197C16.5466 15.4859 16.5708 15.9026 16.3529 16.1962L16.2803 16.2803C16.0141 16.5466 15.5974 16.5708 15.3038 16.3529L15.2197 16.2803L10.25 11.311L5.28033 16.2803C5.01406 16.5466 4.5974 16.5708 4.30379 16.3529L4.21967 16.2803C3.9534 16.0141 3.9292 15.5974 4.14705 15.3038L4.21967 15.2197L9.189 10.25L4.21967 5.28033C3.9534 5.01406 3.9292 4.5974 4.14705 4.30379L4.21967 4.21967L4.14705 4.30379Z"
              fill="white" />
          </svg>
          `))}
        </div>
        <svg class="arrow" width="14" height="14" viewBox="0 0 14 14" xmlns="http://www.w3.org/2000/svg">
          <path fill-rule="evenodd" clip-rule="evenodd"
            d="M6.29289 7.70711C6.68342 7.31658 7.31658 7.31658 7.70711 7.70711L14 14L0 14L6.29289 7.70711Z" />
        </svg>
        ${i(!!h,(()=>t`
        <div class="button-list">
          ${o(h,(t=>t.title),(({title:e,onClick:i})=>t`
          <edge-accessible-button class="button" role="button" @click=${i}>${e}</edge-accessible-button>
          `))}
        </div>
        `))}
      </div>
      <style>
        .content {
          opacity: ${this.show?"1.0":"0.0"};
        }
        .text {
          max-width: ${a}px;
        }
      </style>
      ${this.maskStyle}
    `}}customElements.define("edge-tooltip",EdgeTooltip);export function showTooltip(t){const e=document.createElement("edge-tooltip");return e.props=t,document.body.appendChild(e),{dismiss:()=>{e.remove()},update:t=>{e.props=t,e.updateContent()}}}