// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{html as e,css as t,LitElement as r}from"../lit.js";import{MixinKeyEvent as o,MixinAttributes as i}from"./control-base.js";customElements.define("edge-radio",i(o(class extends r{constructor(){super(...arguments),this.onClick=e=>{e.stopPropagation(),this.disabled||(this.checked=!this.checked,this.setAttribute("aria-checked",this.checked?"true":"false"),this.onChange&&this.onChange(this.checked))}}static get properties(){return{checked:{type:Boolean,reflect:!0},disabled:{type:Boolean,reflect:!0}}}static get styles(){return t`
      :host {
        position: relative;
        display: inline-block;
        width: 24px;
        height: 24px;
        -webkit-tap-highlight-color: transparent;
      }

      .outer {
        --size: 20px;
        position: absolute;
        width: var(--size);
        height: var(--size);
        border-radius: 50%;
        border-width: 1.5px;
        border-style: solid;
        border-color: var(--icon-secondary);
        box-sizing: border-box;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        margin: auto;
        transition: all 100ms;
      }

      :host([checked]) .outer {
        border-color: var(--accent-shade-10);
      }

      :host([disabled]) .outer {
        border-color: var(--divider-primary);
      }

      :host([disabled][checked]) .outer {
        border-color: #B4D6FA;
      }

      .inner {
        --size: 10px;
        position: absolute;
        width: var(--size);
        height: var(--size);
        border-radius: 50%;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        margin: auto;
        transition: all 100ms;
        opacity: 0;
        background-color: var(--accent-shade-10);
      }

      :host([checked]) .inner {
        opacity: 1;
      }

      :host([disabled][checked]) .inner {
        background-color: #B4D6FA;
      }

      @media (prefers-color-scheme: dark) {
        :host([disabled]) .outer {
          border-color: var(--divider-tertiary);
        }
        :host([disabled][checked]) .outer {
          border-color: var(--accent-tint-30);
        }
        :host([disabled][checked]) .inner {
          background-color: var(--accent-tint-30);
        }
      }
    `}connectedCallback(){super.connectedCallback(),this.addEventListener("click",this.onClick)}disconnectedCallback(){super.disconnectedCallback(),this.removeEventListener("click",this.onClick)}render(){return e`
      <div class="outer"></div>
      <div class="inner"><div>
    `}}),{role:"radio"}));