// Copyright (C) Microsoft Corporation. All rights reserved.
import e from"../../common/i18n.js";import{LitElement as t,html as i,css as o,when as n,classMap as c}from"../../common/lit.js";import"../components/edge-icon.js";import{isNoBorderIconEnabled as s}from"../utils/index.js";import"./edge-topsite-favicon.js";customElements.define("list-item-site",class extends t{static get properties(){return{item:{type:Object},onToggle:{type:Function}}}static get styles(){return o`
      :host {
        height: auto;
        padding: 6px 16px;
        display: flex;
        align-items: center;
      }

      .content {
        display: flex;
        flex-direction: column;
        flex: 1;
        margin: 0 8px;
        overflow: hidden;
      }

      .title {
        font-size: 17rem;
        line-height: 22rem;
        font-weight: 600;
        overflow: hidden;
        text-overflow: ellipsis;
        color: var(--text-dominant);
      }

      .description {
        margin-top: 2px;
        color: var(--text-secondary);
        font-size: 11rem;
        line-height: 16rem;
        overflow: hidden;
        text-overflow: ellipsis;
      }

      .action-container {
        width: 32px;
        height: 32px;
        display: flex;
        align-items: center;
        justify-content: center;
      }

      .no-border-icon {
        width: 52px;
        height: 52px;
      }
    `}render(){return i`
      <edge-topsite-favicon class="${c({"no-border-icon":s})}" .item=${this.item}></edge-topsite-favicon>
      <div class="content" role="cell" aria-label=${this.item.title}>
        <div class="title">${this.item.title}</div>
        <div class="description">${this.item.url}</div>
      </div>
      <edge-accessible-button class="action-container"
        aria-label=${this.item.title+", "+e.text("common_add")}
        aria-checked=${this.item.checked} @click=${this.onToggle}>
      ${n(this.item.checked,(()=>i`<edge-checked-icon
                      size='large'
                      class="check-btn"
                    ></edge-checked-icon>`),(()=>i`<edge-unchecked-icon
                      size='large'
                      class="check-btn"
                    ></edge-unchecked-icon>`))}
      </edge-accessible-button>
    `}});