// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{html as e,css as t,LitElement as i}from"../../common/lit.js";import s from"../../common/i18n.js";import"./edge-topsite-input.js";import"../../common/dewey/dewey-button.js";import{toggleTopsiteItem as o}from"../utils/index.js";import{SiteValue as n}from"../utils/histogram.js";customElements.define("edge-topsite-custom",class extends i{static get styles(){return t`
      :host {
        display: flex;
        flex-direction: column;
        padding: 8px 16px;
      }
      .edit {
        height: 47.75px;
        border-radius: 12px;
        display: flex;
        flex-direction: column;
        background-color: var(--surfaces-secondary);
        padding-inline-start: 16px;
        overflow: auto;
        transition: height 500ms ease;
      }
      edge-topsite-input {
        height: 47.75px;
        flex-shrink: 0;
        padding-inline-end: 20px;
      }
      .divider {
        height: 0.5px;
        flex-shrink: 0;
        background-color: var(--divider-secondary);
      }
      .action {
        margin-top: 16px;
        display: flex;
        justify-content: space-between;
      }
      dewey-button {
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
        flex: 1;
      }
      dewey-button:last-child {
        margin-inline-start: 16px;
      }
      @media (prefers-color-scheme: dark) {
        .edit {
          background-color: var(--surfaces-quaternary);
        }
      }
    `}static get properties(){return{keywords:{type:String},siteName:{type:String},siteValue:{type:String},onCancel:{type:Function},onComplete:{type:Function},hideTabIndex:{type:Boolean}}}constructor(){super(),this.onNameChange=this.onNameChange.bind(this),this.onValueChange=this.onValueChange.bind(this),this.onClickAdd=this.onClickAdd.bind(this),this.onClickCancel=this.onClickCancel.bind(this)}updated(e){if(super.updated(e),e.has("keywords"))if(this.keywords){/^((http)|(www).*)|(.*\.[a-zA-Z]{2,4})|(.*:\/\/.*)$/i.test(this.keywords)?this.siteValue=this.keywords:this.siteName=this.keywords;this.shadowRoot.querySelector(".edit").style.height="96px",this.setFocus()}else{this.siteName=null,this.siteValue=null;this.shadowRoot.querySelector(".edit").style.height="47.75px"}}onNameChange(e){this.siteName=e}onValueChange(e){this.siteValue=e}fixupURL(e){let t=e||"";if(t=t.trim(),0===t.length)return null;t.includes("://")||(t="http://"+t);try{return new URL(t)}catch(e){return null}}onClickAdd(){const e=this.fixupURL(this.siteValue);if(!e)return;const t=e.toString();let i=this.siteName;i||(i=e.hostname||t);const s={title:i,url:t,site_id:n.CustomAdd};o(s,(e=>{e&&(this.clearFocus("#custom_add_button"),this.onComplete())}))}onClickCancel(){this.clearFocus("#custom_cancel_button"),this.onCancel()}setFocus(){this.shadowRoot.querySelector("#top_site_title").shadowRoot.querySelector("input").focus()}clearFocus(e){this.shadowRoot.querySelector(e).blur()}render(){const t=this.fixupURL(this.siteValue);return e`
      <div class="edit">
        <edge-topsite-input
          id="top_site_title"
          .hideTabIndex=${this.hideTabIndex}
          .inputName=${s.text("tsp_top_site_name")}
          .inputValue=${this.siteName}
          .onChange=${this.onNameChange}
          placeholder='example'>
        </edge-topsite-input>
        <div class="divider"></div>
        <edge-topsite-input
          .hideTabIndex=${this.hideTabIndex}
          .inputName=${s.text("tsp_top_site_url_address")}
          .inputValue=${this.siteValue}
          .onChange=${this.onValueChange}
          placeholder='https://www.example.com'>
        </edge-topsite-input>
      </div>
      <div class="action">
        <dewey-button id="custom_cancel_button"
          tabindex=${this.hideTabIndex?"-1":"0"}
          type='outline-accent'
          @click=${this.onClickCancel}
        >${s.text("common_cancel")}</dewey-button>
        <dewey-button id="custom_add_button"
          aria-disabled=${!t}
          tabindex=${this.hideTabIndex||!t?"-1":"0"}
          .disabled=${!t}
          @click=${this.onClickAdd}
        >${s.text("tsp_add_to_home")}</dewey-button>
      </div>
    `}});