// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{html as e,css as t,LitElement as a,ref as r,createRef as o}from"../../common/lit.js";import i from"../../common/i18n.js";import"./edge-topsite-input.js";customElements.define("topsite-search",class extends a{static get properties(){return{keywords:{type:String},onChange:{type:Function},hideTabIndex:{type:Boolean}}}static get styles(){return t`
      :host {
        position: relative;
        display: inline-block;
        transform: translateZ(0);
      }

      .shadow {
        position: absolute;
        left: 4px;
        right: 4px;
        top: 8px;
        bottom: -4px;
        background: linear-gradient(251.21deg, rgba(29, 88, 195, 0.6) 4.69%, rgba(59, 238, 227, 0.6) 35.92%, rgba(82, 172, 255, 0.6) 57.93%, rgba(84, 132, 255, 0.6) 77.54%);
        opacity: 0.56;
        filter: blur(12px);
        border-radius: 10px;
        transform: matrix(1, 0, 0, -1, 0, 0);
      }

      .wrapper {
        height: 48px;
        background: var(--color-neutral-background0-solid);
        box-shadow: 0px 0px 2px rgba(0, 0, 0, 0.16), 0px 1px 2px rgba(0, 0, 0, 0.08);
        border-radius: 100px;
        transform: translateZ(0);
        padding: 0 20px;
        display: flex;
      }

      edge-topsite-input {
        flex: 1;
      }

      @media (prefers-color-scheme: dark) {
        .shadow {
          opacity: 0;
        }
        
        .wrapper {
          box-shadow: 0px 0px 2px rgba(0, 0, 0, 0.32), 0px 1px 2px rgba(0, 0, 0, 0.16);
        }
      }
    `}render(){const t=o();return e`
    <div class="shadow"></div>
    <div class="wrapper">
      <edge-topsite-input
        ${r(t)}
        placeholder=${i.text("tsp_search_placeholder")}
        style='fill: var(--icon-dominant)'
        .showCancel=${!0}
        .inputValue=${this.keywords}
        .inputName=${i.text("tsp_top_site_url_or_name")}
        .onChange=${this.onChange}
        .hideTabIndex=${this.hideTabIndex}
        .icon=${e`
            <svg
              width="24"
              height="24"
              viewBox="0 0 24 24"
              tabindex=${this.hideTabIndex?"-1":"0"}
              aria-hidden=${this.hideTabIndex}
              role="button"
              aria-label=${i.text("common_search")}
              @click=${()=>{t.value.focusInput()}}
              xmlns="http://www.w3.org/2000/svg"
            >
              <path
                d="M10 2.75C14.0041 2.75 17.25 5.99594 17.25 10C17.25 11.7319 16.6427 13.3219 15.6295 14.5688L20.5303 19.4697C20.8232 19.7626 20.8232 20.2374 20.5303 20.5303C20.2641 20.7966 19.8474 20.8208 19.5538 20.6029L19.4697 20.5303L14.5688 15.6295C13.3219 16.6427 11.7319 17.25 10 17.25C5.99594 17.25 2.75 14.0041 2.75 10C2.75 5.99594 5.99594 2.75 10 2.75ZM10 4.25C6.82436 4.25 4.25 6.82436 4.25 10C4.25 13.1756 6.82436 15.75 10 15.75C13.1756 15.75 15.75 13.1756 15.75 10C15.75 6.82436 13.1756 4.25 10 4.25Z" />
            </svg>
          `}
      >
      </edge-topsite-input>
    </div>
    `}});