// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{LitElement as e,html as t,css as i,classMap as r,repeat as o}from"../../common/lit.js";import{showSnackbar as a}from"../../common/dewey/snackbar/dewey-snackbar.js";import{urlQuery as s}from"../../common/environment.js";import n from"../../common/animation.js";import d from"../../common/i18n.js";import"../../common/dewey/dewey-button.js";import"./edge-topsite-favicon.js";import{isLandscape as c,isPad as l,isNoBorderIconEnabled as p,getAndIncreaseNextDefaultIconGroupId as h}from"../utils/index.js";import{ReplaceTopsiteItem as m,LogInfo as u,LogError as x}from"../utils/actions.js";import{ActionName as b,ItemValue as g,SiteValue as f}from"../utils/histogram.js";import{RecordBool as w,RecordEnum as v}from"../../common/log.js";customElements.define("topsite-drawer",class extends e{static get properties(){return{index:{type:Number},item:{type:Object},onToggle:{type:Function},currentList:{type:Array},editableList:{type:Array},isMax10:{type:Boolean},observer:{type:Object,attribute:!1}}}static get styles(){return i`
      .mask {
        position: absolute;
        width: 100%;
        height: 100%;
        left: 0;
        top: 0;
        background: rgba(0, 0, 0, .4);
        opacity: 0;
        will-change: opacity;
      }

      .drawer {
        position: absolute;
        left: 0;
        bottom: 0;
        width: 100%;
        height: auto;
        min-height: 428px;
        max-height: -webkit-calc(100% - 20px);
        background: var(--surfaces-primary);
        border-radius: 12px 12px 0 0;
        box-shadow: 0px -8px 16px rgba(0, 0, 0, 0.14), 0px 0px 2px rgba(0, 0, 0, 0.12);
        transform: translateY(428px);
        opacity: 0;
        will-change: opacity, transform;
        display: flex;
        flex-direction: column;
        padding: 0 16px calc(env(safe-area-inset-bottom) + 16px);
        box-sizing: border-box;
      }

      .handle {
        display: block;
        width: 36px;
        height: 4px;
        border-radius: 2px;
        margin: 8px auto 16px;
        background: var(--divider-primary);
      }

      .header {
        text-align: center;
        font-size: 17rem;
        font-weight: 600;
        width: 100%;
        height: auto;
        color: var(--text-primary);
        outline: none;
      }

      .group {
        margin: auto 0;
        display: grid;
        border-radius: 12px;
        overflow: auto;
        grid-template-columns: repeat(4, 1fr);
      }

      .group_max10 {
        grid-template-columns: repeat(5, 1fr);
      }

      .item {
        overflow: hidden;
        padding: 6px 0px;
        box-sizing: border-box;
      }

      edge-topsite-favicon {
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
      }

      .no-border-icon {
        width: 52px;
        height: 52px;
      }

      .icon-selected-indicator {
        margin: 0 auto;
        position: relative;
        width: 48px;
        height: 48px;
        display: block;
        border-radius: 12px;
        box-sizing: border-box;
        outline: 3px solid transparent;
      }

      .show-indicator {
        outline: 3px solid var(--accent-primary);
      }

      .no-border-icon-selected-indicator {
        width: 58px;
        height: 58px;
        border-radius: 14px;
      }

      .check-btn {
        position: absolute;
        top: 2px;
        right: 2px;
        transform: translate(50%, -50%);
        border-radius: 50%;
      }

      .icon {
        position: absolute;
        width: 36px;
        height: 36px;
        border-radius: 6px;
        object-fit: cover;
        left: 50%;
        top: 50%;
        transform: translate(-50%, -50%);
        pointer-events: none;
        opacity: 0;
      }

      .showIcon {
        opacity: 1;
      }

      .title {
        margin-top: 4px;
        margin-left: 2px;
        margin-right: 2px;
        text-align: center;
        font-size: 11rem;
        line-height: 16rem;
        color: var(--text-primary);
        overflow: hidden;
        text-overflow: ellipsis;
        display: -webkit-box;
        word-break: break-word;
        -webkit-box-orient: vertical;
        -webkit-line-clamp: 2;
      }

      .cancel {
        margin-top: 8px;
      }

      @media (prefers-color-scheme: dark) {
        .mask {
          background: rgba(0, 0, 0, .6);
        }

        .icon-box {
          background: var(--surfaces-quaternary);
        }

        .title {
          color: var(--text-dominant);
        }

        .drawer {
          background: var(--surfaces-tertiary);
        }
      }
    `}constructor(){super(),this.index=0,this.isMax10="10"===s.maxcount,this.currentList=[],this.editableList=[],this.cancel=this.cancel.bind(this),this.replace=this.replace.bind(this)}connectedCallback(){super.connectedCallback();const e=new ResizeObserver((()=>{c()&&(this.dismiss(!1),this.observer.disconnect(),this.observer=null,a({text:d.text("tsp_replace_drawer_tooltip")}))}));e.observe(document.body),this.observer=e,w(b.ReplaceDrawerShow,!0)}disconnectedCallback(){super.disconnectedCallback(),this.observer&&this.observer.disconnect()}firstUpdated(){super.firstUpdated(),this.addGesture(),this.show()}addGesture(){const e=this.shadowRoot.querySelector(".mask"),t=this.shadowRoot.querySelector(".drawer");if(!t)return;let i=0,r=0;t.addEventListener("touchstart",(e=>{r=e.touches[0].pageY})),t.addEventListener("touchmove",(o=>{o.preventDefault(),i=o.touches[0].pageY-r;const a=t.getBoundingClientRect(),s=Math.min(Math.max(i,0),a.height);e.style.opacity=1-s/a.height,t.style.transform=`translateY(${Math.max(i,0)}px)`})),t.addEventListener("touchend",(e=>{if(0===i)return;const r=t.getBoundingClientRect();i>.3*r.height?this.dismiss(!1):this.show(),i=0}))}setCurrentList(e){this.currentList=e,this.editableList=this.currentList?.map(((e,t)=>({top_site:e,origin_index:t}))).filter((e=>!e.top_site.managed))}show(){const e=this.shadowRoot.querySelector(".mask"),t=this.shadowRoot.querySelector(".drawer");n({easing:"linear",duration:200}).add(0).add([{targets:t,opacity:1,transform:"translateY(0px)"},{targets:e,opacity:1}]).add((()=>{this.shadowRoot.querySelector(".header").focus()})).run()}dismiss(e=!1){const t=this.shadowRoot.querySelector(".mask"),i=this.shadowRoot.querySelector(".drawer");u(e?"Adding page replace dialog confirmed":"Adding page replace dialog canceled"),n({easing:"linear",duration:200}).add([{targets:i,opacity:0,transform:"translateY(428px)"},{targets:t,opacity:0}]).add((()=>{this.remove(),this.onToggle?.(e),k(!1)})).run()}replace(){this.index<0||(w(b.ReplaceDrawerClick,!0),m(this.item,this.index).then((({result:e,reason:t})=>{if(e){this.item.item_id&&v(b.AddItem,this.item.item_id,g.Max),v(b.AddSite,this.item.site_id,f.Max);const e=this.currentList[this.index];e.item_id&&v(b.RemoveItem,e.item_id,g.Max),v(b.RemoveSite,e.site_id,f.Max),this.dismiss(!0)}else a({text:d.text("tsp_tooltip_added_faild")}),x("Replace topsite item failed: "+t)})))}cancel(){w(b.ReplaceDrawerClick,!1),this.dismiss(!1)}renderItem(e,i){const o=i===this.index,a=r({"no-border-icon":p}),s=r({"icon-selected-indicator":!0,"show-indicator":o,"no-border-icon-selected-indicator":p});return t`
      <div class="item" tabindex="0" role="radio" aria-label=${e.title} aria-checked=${o}
           @click="${()=>{this.index=i}}">
        <div class=${s}>
          <edge-topsite-favicon class=${a} .item=${e}></edge-topsite-favicon>
        </div>
        <div class="title" aria-hidden="true">${e.title}</div>
      </div>
    `}render(){return t`
      <div class="mask" @click=${this.cancel}>
      </div>
      <div class="drawer" role="dialog" aria-modal="true">
        <div class="handle"></div>
        <div class="header" tabindex="1" role="alert">${d.text("tsp_replace_drawer_title")}</div>
        <div role="radiogroup" class=${r({group:!0,group_max10:this.isMax10})}>
          ${o(this.editableList,(e=>e.top_site.url),((e,t)=>this.renderItem(e.top_site,e.origin_index)))}
        </div>
        <dewey-button class="replace" role="button" .disabled=${this.index<0} @click=${this.replace}>
          ${d.text(["common_replace"])}
        </dewey-button>
        <dewey-button class="cancel" role="button" type="outline-accent" @click=${this.cancel}>
          ${d.text(["common_cancel"])}
        </dewey-button>
      </div>
    `}});export function showDrawer(e){if(c()&&!l())return void a({text:d.text("tsp_replace_drawer_tooltip")});e.list?.forEach((e=>{void 0===e.defaultIconGroupId&&(e.defaultIconGroupId=h())}));const t=document.createElement("topsite-drawer");return t.item=e.item,t.setCurrentList(e.list),t.onToggle=e.onToggle,document.body.appendChild(t),k(!0),{dismiss:()=>{t?.remove(),k(!1)}}}const y=[];function k(e){y.forEach((t=>t(e)))}export function addDrawerObserver(e){y.push(e)}export function removeDrawerObserver(e){y=y.filter((t=>t!==e))}