// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"../../common/dewey/dewey-button.js";import e from"../../common/i18n.js";import{css as t,html as i,LitElement as n}from"../../common/lit.js";import{kiwiLetterShown as o,shareKiwiLetter as s}from"../action.js";customElements.define("kiwi-letter-page",class extends n{constructor(){super(...arguments),this.onCloseClick=()=>{document.dispatchEvent(new CustomEvent("kiwi-close-letter"))},this.onShareClick=()=>{s()}}static get styles(){return t`
      .container {
            margin: 0;
            padding: 0;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            background-image: url(./resources/extension_kiwi_background.webp);
            background-repeat: no-repeat;
            background-size: 100% 100%;
            background-size: cover;
            overflow: hidden;
        }

        @media screen and (orientation: landscape) {
            .container {
                overflow: auto;
            }
        }
        .close-image-container {
            align-self: flex-end;
            width: 56px;
            height: 56px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .close-image {
            width: 24px;
            height: 24px;
        }

        .section-text {
            align-self: center;
            max-width: 80%;
            font-family: Georgia;
        }

        .section1 {
            margin-top: 20px;
            text-align: left;
            font-weight: 700;
            font-style: italic;
            font-size: 16px;
            line-height: 27px;
            letter-spacing: -0.41px;
            color: #252525;
            display: flex;
            align-items: center;
            justify-content: baseline;
        }

        .section1 img{
            width: 20px;
            height: 20px;
        }

        .section2 {
            margin-top: 12px;
            text-align: left;
            font-family: Georgia;
            font-weight: 400;
            font-style: italic;
            font-size: 16px;
            line-height: 27px;
            letter-spacing: -0.41px;
            color: #333333;
        }

        .section3 {
            margin-top: 27px;
            text-align: left;
            font-family: Georgia;
            font-weight: 400;
            font-style: italic;
            font-size: 16px;
            line-height: 27px;
            letter-spacing: -0.41px;
            color: #333333;
        }

        .section4 {
            margin-top: 12px;
            text-align: right;
            font-family: Georgia;
            font-weight: 700;
            font-style: italic;
            font-size: 16px;
            line-height: 27px;
            letter-spacing: -0.41px;
            color: #252525;
        }

        .section-img {
            width: 100%;
            height: 284px;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .section-img img {
            width: 277px;
            height: 111px;
            border-radius: 10px;
        }

        .share-btn {
            align-self: center;
            text-align: center;
            background: white;
            border: none;
            border-radius: 12px;
            font-weight: bold;
            cursor: pointer;
            width: 257px;
            height: 52px;
            gap: 8px;
            font-family: PingFang SC;
            font-weight: 600;
            font-size: 17px;
            line-height: 22px;
            letter-spacing: -0.43px;
            text-align: center;
            vertical-align: middle;
            color: #242424;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 32px;
        }

        span {
            display: inline-block;
        }

        .section1,
        .section2,
        .section3,
        .section4,
        .section-img {
            opacity: 0;
            animation: fadeIn 600ms ease-in forwards;
        }

        .share-btn {
            opacity: 0;
            transform: scale(0.7);
            animation: scaleIn 500ms ease-out forwards;
            animation-delay: 500ms;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
            }

            to {
                opacity: 1;
            }
        }

        @keyframes scaleIn {
            from {
                opacity: 0;
                transform: scale(0.7);
            }
            to {
                opacity: 1;
                transform: scale(1);
            }
        }
    `}connectedCallback(){super.connectedCallback(),o()}render(){return i`
    <div class="container">
        <div class="close-image-container" aria-label="${e.text("common_back")}" role="button" @click="${this.onCloseClick}">
          <img class="close-image" src="./resources/extension_close.svg" aria-hidden="true"></img>
        </div>
        <div class="section-text">
            <div class="section1">${e.text("extension_kiwi_campaign_letter_title")}<img src="./resources/extension_kiwi_heart.webp" alt=""/></div>
            <div class="section2">${e.text("extension_kiwi_campaign_letter_content_1")}</div>
            <div class="section3">${e.text("extension_kiwi_campaign_letter_content_2")}</div>
            <div class="section4">${e.text("extension_kiwi_campaign_letter_author")}</div>
        </div>
        <div class="section-img"><img src="./resources/extension_kiwi_ticket.webp" aria-hidden="true" /></div>
        <button class="share-btn" @click="${this.onShareClick}">
            <img src="./resources/extension_share_icon.svg" aria-hidden="true" />
            <span>${e.text("extension_kiwi_campaign_letter_share_button")}</span>
        </button>
    </div>
    `}});