// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{showPopupMenu as t}from"../../common/controls/edge-popupmenu.js";import{showSnackbar as e}from"../../common/dewey/snackbar/dewey-snackbar.js";import i from"../../common/i18n.js";import{css as n,html as o,LitElement as s,when as a}from"../../common/lit.js";import{canBeIncognitoEnabled as r,changeExtensionState as c,getExtensionIcon as h,isExtensionBanned as l,isExtensionEnabled as d,isExtensionIncognitoEnabled as m,isExtensionMalware as p,isExtensionTerminated as x,onClickTerminatedExtension as u,onShowPopupMenu as b,removeExtensionItem as g,showPermissionDialog as w}from"../action.js";import{ExtensionPage as _,ExtensionState as f,InstallEventType as y,InstallState as v}from"../types.js";import{tryToShowInstalledTooltip as I}from"../utils.js";customElements.define("installed-view",class extends s{constructor(){super(...arguments),this.enabled=!0,this.terminated=!1,this.banned=!1,this.malware=!1,this.incognitoEnabled=!1,this.canBeIncognitoEnabled=!1,this.showPopupMenu=()=>{if(this.popupMenu)return this.popupMenu.dismiss(),void(this.popupMenu=void 0);const e=this.shadowRoot?.querySelector(".actions"),i=[-1*(e.clientWidth+8),-1*(e.clientHeight+8)];b(this.terminated,this.banned,this.malware),this.popupMenu=t({target:e,placement:"bottomRight",menuOffset:i,keepInScreen:!0,closable:!0,onCancel:()=>{this.popupMenu=void 0},actions:this.getActionList(),warning:this.getWarningHeader()})},this.onKeyUp=t=>{"Enter"===t.key&&this.showPopupMenu()},this.onInstalledItemClick=()=>{this.terminated&&(u(),e({text:i.text("extension_terminated_info")})),this.banned&&e({text:i.text("extension_banned_info")}),this.malware&&e({text:i.text("extension_malware_info")})}}static get styles(){return n`
      :host {
        display: flex;
        border-radius: 12px;
        box-shadow: 0px 0px 2px 0px rgba(0, 0, 0, 0.12);
        padding: 16px;
        margin-top: 8px;
        box-sizing: border-box;
        background-color: var(--surfaces-primary);
      }
      .icon-container {
        width: 32px;
        height: 32px;
        margin-inline-end: 16px;
      }
      .icon {
        width: 100%;
        height: 100%;
        object-fit: contain;
        pointer-events: none;
      }
      .hint-icon {
        position: absolute;
        top: -8px;
        right: 8px;
        width: 16px;
        height: 16px;
      }
      .icon-wrapper {
        position: relative;
      }
      .content {
        flex: 1;
        display: flex;
        flex-direction: column;
        justify-content: center;
      }
      .title {
        font-size: 16rem;
        line-height: 24rem;
        font-weight: 500;
        margin-right: 8px;
        color: var(--text-primary);
        overflow: hidden;
        text-overflow: ellipsis;
        display: -webkit-box;
        line-clamp: 1;
        -webkit-line-clamp: 1;
        -webkit-box-orient: vertical;
        word-break: break-all;
      }
      .desc {
        margin-top: 4px;
        font-size: 12rem;
        line-height: 14rem;
        color: var(--text-secondary);
      }
      .actions {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
      }
      .icon-options {
        width: 24px;
        height: 24px;
        object-fit: contain;
        pointer-events: none;
      }

      @media (prefers-color-scheme: dark) {
        :host {
          background-color: var(--surfaces-tertiary);
        }
      }
    `}connectedCallback(){super.connectedCallback(),h(this.item.id).then((t=>{this.iconUrl=t})),d(this.item.id).then((t=>{this.enabled=t})),x(this.item.id).then((t=>{this.terminated=t})),l(this.item.id).then((t=>{this.banned=t})),p(this.item.id).then((t=>{this.malware=t})),r(this.item.id).then((t=>{this.canBeIncognitoEnabled=t})),m(this.item.id).then((t=>{this.incognitoEnabled=t}))}firstUpdated(){const t=this.shadowRoot?.querySelector(".icon-container");I(t)}static get properties(){return{item:{type:Object},iconUrl:{type:String},enabled:{type:Boolean},terminated:{type:Boolean},banned:{type:Boolean},malware:{type:Boolean}}}getWarningHeader(){if(this.terminated){return{title:i.text("extension_terminated_info"),icon:this.getHintIcon()}}if(this.banned){return{title:i.text("extension_banned_pop_info"),icon:this.getHintIcon()}}if(this.malware){return{title:i.text("extension_malware_info"),icon:this.getHintIcon()}}}getActionList(){const t=[];return this.banned||this.malware||(t.push({action:{name:i.text("extension_action_menu_enable"),type:"switch",payload:{state:!this.terminated&&this.enabled}},onAction:t=>{let n=f.UNKNOWN;n=this.terminated?f.TERMINATED:t?f.ENABLED:f.DISABLED,c(this.item.id,n,_.INSTALLED).then((n=>{n&&(this.enabled=t,this.terminated=!1,this.enabled||e({text:i.text("extension_disabled_info"),icon:"./resources/extension_snackbar_icon.svg"}))}))}}),this.canBeIncognitoEnabled&&t.push({action:{name:i.text("extension_action_menu_incognito_enable"),type:"switch",payload:{state:this.incognitoEnabled}},onAction:t=>{c(this.item.id,t?f.INCOGNITO_ENABLED:f.INCOGNITO_DISABLED,_.INSTALLED).then((e=>{e&&(this.incognitoEnabled=t)}))}}),t.push({action:{name:i.text("extension_action_menu_detail"),type:"button"},onAction:()=>{this.item&&this.navigateDetail?.(this.item,!0)}}),t.push({action:{name:i.text("extension_action_menu_permission"),type:"button"},onAction:()=>{w(this.item.id,this.item.name,_.INSTALLED)}})),t.push({action:{name:i.text("extension_action_remove"),type:"button"},onAction:()=>{g(this.item.id,_.INSTALLED).then((t=>{t&&this.eventHub?.emit({type:y.UNINSTALLED,id:this.item.id,newState:v.STATE_IDLE})}))}}),t}getHintIcon(){return this.terminated?"./resources/extension_hint_icon.svg":this.banned||this.malware?"./resources/extension_banned_icon.svg":""}render(){return o`
      <div class="icon-wrapper">
        <div class="icon-container" aria-hidden="true" @click="${this.onInstalledItemClick}">
          ${a(!!this.iconUrl,(()=>o`<img class="icon" src=${this.iconUrl} />`))}
        </div>
        ${a(this.terminated||this.banned||this.malware,(()=>o`<img class="hint-icon" src=${this.getHintIcon()} />`))}
      </div>
      <div class="content">
        <div class="title" @click="${this.onInstalledItemClick}">${this.item.name}</div>
      </div>
      <div class="actions"
        tabindex="0"
        aria-label="${i.text("extension_accessibility_more_options")}"
        role="button" @click="${this.showPopupMenu}" @keyup=${this.onKeyUp}>
        <!-- <img class="icon-options" src="./resources/extension_more_options.svg"> -->
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
          <path d="M12 8C10.8954 8 10 7.10457 10 6C10 4.89543 10.8954 4 12 4C13.1046 4 14 4.89543 14 6C14 7.10457 13.1046 8 12 8ZM12 14C10.8954 14 10 13.1046 10 12C10 10.8954 10.8954 10 12 10C13.1046 10 14 10.8954 14 12C14 13.1046 13.1046 14 12 14ZM10 18C10 19.1046 10.8954 20 12 20C13.1046 20 14 19.1046 14 18C14 16.8954 13.1046 16 12 16C10.8954 16 10 16.8954 10 18Z" fill="#0078D4"/>
        </svg>
      </div>
      <style>
        .icon-container, .content {
          opacity: ${!this.enabled||this.terminated||this.banned||this.malware?"0.5":"1.0"};
        }
      </style>
    `}});