// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import e from"../common/animation.js";import{init as t}from"../common/index.js";import{urlQuery as a}from"../common/environment.js";import{sendMessage as r,subscribeMessage as i}from"../common/message.js";import{LitElement as s,html as n,css as o,repeat as l,classMap as d}from"../common/lit.js";import{initCachedFlightIds as p}from"./utils/experiment.js";import{voiceoverEnable as h}from"./edge-fre-common.js";import{constantCss as y}from"./edge-fre-common.js";const g={defaultBrowser:{key:"edge-fre-default-browser",name:"setting-defaultBrowser"},privacy:{key:"edge-fre-privacy",name:"setting-privacy"}},m=e=>!!e&&Object.values(g).some((t=>t.name===e));customElements.define("edge-fre",class extends s{static get properties(){return{displayArray:{type:Array},displayIndex:{type:Number}}}static get styles(){return o`
      ${y}
      :host {
        position: absolute;
        width: 100%;
        height: 100%;
        background-color: #FFFFFF;
      }
      :host > *:not(.progress) {
        position: absolute;
        top: 0;
        bottom: 0;
        right: 0;
        left: 0;
      }
      .current {
        left: 0;
        transform: translateX(0%);
      }
      .next {
        left: 100%;
        transform: translateX(100%);
      }
      .previous {
        left: -100%;
        transform: translateX(-100%);
      }
      .progress {
        position: absolute;
        top: calc(var(--top-margin) - 30px);
        left: calc(var(--left-margin) + 32px);
        right: calc(var(--right-margin) + 32px);
        height: 4px;
        display: flex;
        opacity: 0.7;
      }

      @media screen and (max-height: 500px) {
        .progress {
          top: 24px;
        }
      }

      .progress > * {
        flex: 1;
        background-color: rgba(241, 241, 241, 0.8);
        border-radius: 4px;
        overflow: hidden;
      }

      .progress > *:nth-child(n + 2) {
        margin-left: 4px;
      }

      .mask {
        background-color: rgba(172, 172, 172, 0.5);
        width: 100%;
        height: 100%;
        transform: scaleX(0);
        transform-origin: left center;
      }
  `}constructor(){let e;super();const t=a.startUpOrder;if(t){const a=JSON.parse(t);(e=>{if(!Array.isArray(e)||0===e.length)return!1;const t={};return Object.values(g).forEach((e=>{t[e.key]=e})),e.every((({key:e,name:a,animation:r})=>{if(!e||!a)return!1;const i=t[e];return!!i&&i.name===a&&Boolean(i.animation)===Boolean(r)}))})(a)&&(e=a)}e||(e=[g.defaultBrowser,g.privacy]);let r=a.page;m(r)||(r=e[0].name),p(a.webFREExpCaches),this.allowWebFREExp="true"===a.allowWebFREExp,this.defaultConsentState="true"===a.defaultConsentState,this.setArrayPages(r,e),this.currentTimeline=void 0,this.flipping=!1,this.onNext=this.onNext.bind(this),this.handleObserverMessage=this.handleObserverMessage.bind(this)}willUpdate(e){if(super.willUpdate(e),e.has("displayIndex")){const t=e.get("displayIndex"),a=this.displayIndex;if(null!=t){let a,i;if(e.has("displayArray")){const r=e.get("displayArray");a=r[t]?.name,i=r[t]?.nextSignIn}else a=this.displayArray[t]?.name,i=this.displayArray[t]?.nextSignIn;null!=a&&(i||r({action:"pageDisappear",payload:{page:a,nextSignIn:i}}))}if(null!=a&&void 0!==this.displayArray[a]){const e=this.renderRoot.querySelector(this.displayArray[a].key),t=e?.getPageKey?.();r({action:"pageAppear",payload:{page:this.displayArray[a].name,pageKey:t}})}}}firstUpdated(){super.firstUpdated(),i(this.handleObserverMessage)}handleObserverMessage(e,t){const{action:a,payload:r}=e;if("navigate"===a){let e=this.displayIndex+1;const t=r?.page;m(t)&&(e=this.displayArray.findIndex((e=>e.name===t))),e>=0&&this.showNextPage(e,!1)}else"updateExperimentConfig"===a&&void 0!==r&&void 0!==r.allowWebFREExp&&(this.allowWebFREExp="true"===r.allowWebFREExp);t()}async lazyLoadPage(e){await import(`./${e}.js`);const t=[...this.renderRoot.querySelectorAll(":not(:defined)")].map((e=>customElements.whenDefined(e.localName)));return await Promise.all(t)}async setArrayPages(e,t){let a=0;t=t.map(((t,r)=>t.name===e?(a=r,{...t,show:!0}):t)),this.displayArray=t,this.displayIndex=a;const r=t[a].key;await this.lazyLoadPage(r),await this.updateComplete}onNext(e){if(this.flipping)return;this.currentTimeline?.isRunning()&&this.currentTimeline.pause();const t=this.displayArray[this.displayIndex];r({action:e?"pageSkip":"pageConfirm",payload:{page:t.name}});let a=this.displayArray.length-1;for(;this.displayArray[a]?.shouldSkip;)a--;if(this.displayIndex===a)return r({action:"pageDisappear",payload:{page:t.name,nextSignIn:t.nextSignIn}}),void r({action:"done"});if(t.nextSignIn)return r({action:"pageDisappear",payload:{page:t.name,nextSignIn:t.nextSignIn}}),void r({action:"navigate",payload:{page:"signIn"}});let i=this.displayIndex+1;if(t.animation&&e)for(;this.displayArray[i]?.animation;)i++;this.showNextPage(i)}showCurrentPage(){if(h)return;const e=this.displayArray[this.displayIndex].key,t=this.renderRoot.querySelector(e),a=t?.createAnimation?.();a&&(this.currentTimeline=a,a.delay(1e3).add((()=>{this.currentTimeline=void 0;const e=this.displayIndex+1;this.displayArray[e]?.animation&&this.showNextPage(e)})).run())}showNextPage(t,a=!0){const i=e=>()=>this.renderRoot.querySelector(e);for(;this.displayArray[t]?.shouldSkip;)t++;if(t>=this.displayArray.length)return void r({action:"done"});this.flipping=!0,this.displayArray=this.displayArray.map(((e,a)=>a===t?{...e,show:!0}:e));const s=this.displayArray[this.displayIndex].key,n=this.displayArray[t],o=n.key,l=n.animation?500:250,d=e({duration:l}).add((()=>this.lazyLoadPage(o)));a&&d.add((()=>this.updateComplete)).delay(10).add([{targets:i(s),transform:"translateX(-100%)"},{targets:i(o),transform:"translateX(0%)"}]),d.add((()=>(this.displayIndex=t,this.displayArray=this.displayArray.map(((e,t)=>t!==this.displayIndex?{...e,show:!1}:e)),this.updateComplete))).add((()=>{this.flipping=!1,this.showCurrentPage()})).run()}render(){return n`
      ${l(this.displayArray,(e=>e.key),((e,t)=>{if(!e.show)return null;const a={next:t>=this.displayIndex+1,previous:t+1<=this.displayIndex,current:t===this.displayIndex};switch(e.key){case"edge-fre-default-browser":return n`<edge-fre-default-browser .classInfo=${a} class=${d(a)} .onNext=${this.onNext} .pageNumber=${e.pageNumber} .allowWebFREExp=${this.allowWebFREExp}></edge-fre-default-browser>`;case"edge-fre-privacy":return n`<edge-fre-privacy class=${d(a)} .onNext=${this.onNext} .pageNumber=${e.pageNumber} .agree=${this.defaultConsentState}></edge-fre-privacy>`;default:return null}}))}
    `}}),t("edge-fre");