// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import e from"../common/i18n.js";import{sendMessage as i}from"../common/message.js";import{html as r,css as t,when as a}from"../common/lit.js";import"../common/dewey/dewey-button.js";import{commonCss as n,voiceoverEnable as o,FREBaseElement as s}from"./edge-fre-common.js";customElements.define("edge-fre-privacy",class extends s{static get styles(){return t`
      ${n}
      .title {
        align-self: flex-start;
        margin-left: 32px;
        margin-right: 32px;
        font-size: 26rem;
        line-height: 31rem;
        font-weight: 700;
        color: var(--text-primary);
        white-space: pre-wrap;
        text-align: start;
      }
      .subtitle {
        align-self: flex-start;
        margin: 8px 32px 0;
        font-size: 15rem;
        line-height: 20rem;
        color: var(--text-secondary);
      }
      .content {
        width: 100%;
        margin-top: 30px;
        margin-bottom: 20px;
        flex: 1;
        overflow: auto;
      }
      .privacy-content, .privacy-improve {
        background-color: var(--surfaces-secondary);
        border-radius: 8px;
        font-size: 13rem;
        line-height: 18rem;
        color: var(--text-primary);
        padding: 16px;
        margin-inline-start: 32px;
        margin-inline-end: 32px;
      }
      .privacy-improve {
        margin-top: 16px;
        padding-inline-start: 7px;
        display: flex;
        align-items: center;
      }
      .toggle {
        width: 40px;
        height: 40px;
        flex-shrink: 0;
        margin-inline-end: 3px;
        display: flex;
        justify-content: center;
        align-items: center;
      }
      .toggle-normal {
        width: 20px;
        height: 20px;
        border-radius: 50%;
        border: 1.5px solid #6E6E6E;
        box-sizing: border-box;
      }
      .action-text {
        display: inline;
        color: var(--color-brand-foreground1);
      }
      .confirm {
        margin-top: auto;
        margin-bottom: 56px;
        margin-left: 32px;
        margin-right: 32px;
        align-self: stretch;
      }
      @media (orientation: landscape) {
        .confirm {
          margin-bottom: 0;
        }
      }
      @media (prefers-color-scheme: dark) {
        :host {
          background-color: var(--surfaces-primary);
        }
        .privacy-content, .privacy-improve {
          background-color: var(--surfaces-tertiary);
        }
      }
    `}static get properties(){return{agree:{type:Boolean},isChild:{type:Boolean}}}constructor(){super(),this.isChild=!1,i({action:"accountInfo"},(e=>{const{aadc:i,child:r}=e||{};this.isChild=r,this.agree=this.agree&&!i&&!r}))}onClickLink(e){i({action:"navigate",payload:{page:e}})}onClickAgree(e){e.stopPropagation(),this.agree=!this.agree}onClickConfirm(){i({action:"setAllowDiagnostic",payload:{value:this.agree}}),this.onNext(!1)}render(){return r`
      <div class="page-number-with-icon-container" tabindex="0">
        ${this.renderIcon()}
        <div class="page-number-with-icon">${this.pageNumber}</div>
      </div>
      <div class="title" role="heading" aria-level="1" tabindex="0">${e.text(["fre_privacy_title"])}</div>
      <div class="subtitle" tabindex="0">${e.text(["fre_privacy_subtitle"])}</div>
      <div class="content">
        <div class="privacy-content">
          <span tabindex="0">${e.text(["fre_privacy_description"])}</span>
          <br/>
          <edge-accessible-link class="action-text" @click=${()=>this.onClickLink("privacyStatement")}>
            ${e.text(["fre_privacy_statement"])}
          </edge-accessible-link>
          <span aria-hidden="true">&nbsp;|&nbsp;</span>
          <edge-accessible-link class="action-text" @click=${()=>this.onClickLink("termsOfUser")}>
            ${e.text(["fre_privacy_terms"])}
          </edge-accessible-link>
        </div>
        ${this.renderDiagnostic()}
      </div>
      ${this.renderButton()}
    `}renderButton(){return r`
      <dewey-button class="confirm" size='large' @click=${this.onClickConfirm}>
        ${e.text(["common_confirm"])}
      </dewey-button>
    `}renderIcon(){return r`
      <picture>
        <source srcset="./resources/microsoft-logo-dark.png" media="(prefers-color-scheme: dark)" />
        <img class="page-icon" src="./resources/microsoft-logo.png" aria-hidden="true"/>
      </picture>
    `}renderDiagnostic(){return a(!this.isChild,(()=>r`
      <div class="privacy-improve">
          <edge-accessible-checkbox class="toggle" aria-checked=${this.agree?"true":"false"} aria-labelledby="fre_privacy_improve" @click=${this.onClickAgree}>
            ${a(this.agree,(()=>r`
              <svg xmlns="http://www.w3.org/2000/svg" width="23" height="24" viewBox="0 0 23 24" fill="none">
                <path d="M11 2C16.5228 2 21 6.47715 21 12C21 17.5228 16.5228 22 11 22C5.47715 22 1 17.5228 1 12C1 6.47715 5.47715 2 11 2ZM14.2197 8.96967L9.75 13.4393L7.78033 11.4697C7.48744 11.1768 7.01256 11.1768 6.71967 11.4697C6.42678 11.7626 6.42678 12.2374 6.71967 12.5303L9.21967 15.0303C9.51256 15.3232 9.98744 15.3232 10.2803 15.0303L15.2803 10.0303C15.5732 9.73744 15.5732 9.26256 15.2803 8.96967C14.9874 8.67678 14.5126 8.67678 14.2197 8.96967Z" fill='var(--color-brand-foreground1)'/>
              </svg>
              `),(()=>r`<div class="toggle-normal"></div>`))}
          </edge-accessible-checkbox>
          <div>
            <span id="fre_privacy_improve" tabindex="0">${e.text(["fre_privacy_improve"])}</span>
            <edge-accessible-link class="action-text" @click=${e=>{e.stopPropagation(),this.onClickLink("learnMore")}}>
              ${e.text(["fre_privacy_learn_more"])}
            </edge-accessible-link>
          </div>
      </div>
      `))}});