// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"../common/dewey/dewey-button.js";import e from"../common/i18n.js";import{css as t,html as r,repeat as i,unsafeHTML as o}from"../common/lit.js";import{sendMessage as n}from"../common/message.js";import{commonCss as a,FREBaseElement as s,scaleContainer as d}from"./edge-fre-common.js";customElements.define("edge-fre-default-browser-ios",class extends s{static get styles(){return t`
    ${a}
    .title {
      align-self: flex-start;
      margin-left: 32px;
      margin-right: 32px;
      font-size: 26rem;
      line-height: 31rem;
      font-weight: 700;
      color: var(--text-primary);
      white-space: pre-wrap;
      text-align: start;
    }
    .subtitle {
      align-self: flex-start;
      margin: 8px 32px 0;
      font-size: 15rem;
      line-height: 20rem;
      color: var(--text-secondary);
    }
    .contentContainer {
      flex: 1;
      width: 266px;
      height: 230px;
      box-sizing: border-box;
      display: flex;
      flex-direction: column;
      justify-content: flex-start;
      align-items: center;
    }
    .phone {
      width: 266px;
      height: 230px;
      box-sizing: border-box;
      border-radius: 34px 34px 0 0;
      border-width: 4px 4px 0;
      border-color: rgba(241, 241, 241, 1);
      border-style: solid;
      background-color: #F8F8F8;
      display: flex;
      flex-direction: column;
      align-items: center;
    }
    .cell-edge {
      --width: 313px;
      position: absolute;
      width: var(--width);
      height: 45px;
      top: 140px;
      left: calc(50% - var(--width) / 2);
      box-sizing: border-box;
      border-radius: 8px;
      background-color: #FFFFFF;
      border: 2px solid #404040;
      display: flex;
      align-items: center;
      padding: 0 14px;
    }
    .cell-edge-title {
      font-weight: 500;
      font-size: 15px;
      line-height: 20px;
      color: var(--text-primary);
    }
    .cell-edge-subtitle {
      font-size: 15px;
      line-height: 20px;
      margin-inline-start: auto;
      margin-inline-end: 7px;
      color: var(--text-secondary);
    }
    .phone-mask {
      --width: 320px;
      position: absolute;
      width: var(--width);
      height: 63px;
      left: calc(50% - var(--width) / 2);
      margin-top: 170px;
      background: linear-gradient(180deg, rgba(255, 255, 255, 0) 0%, #FFFFFF 100%);
    }
    .phone-title {
      margin: 19px 0;
      color: var(--text-secondary);
      font-size: 13px;
      line-height: 18px;
      font-weight: 500;
    }
    .phone-cell {
      box-sizing: border-box;
      width: 234px;
      min-height: 35px;
      background-color: #FFFFFF;
      display: flex;
      align-items: center;
      padding: 0 16px 0 12px;
      opacity: 0.6;
    }
    .phone-cell:nth-of-type(1) {
      border-radius: 8px 8px 0 0;
    }
    .phone-cell:nth-of-type(2) {
      border-radius: 0 0 8px 8px;
      border-top: 1px solid rgba(225, 225, 225, 0.3);
    }
    .phone-cell:nth-of-type(3) {
      margin-top: 69px;
      border-radius: 8px;
    }
    .cell-icon {
      width: 16px;
      height: 16px;
      border-radius: 4px;
      margin-inline-end: 10px;
      background-color: var(--surfaces-tertiary);
    }
    .cell-text {
      stroke: #ACACAC;
      opacity: 0.2;
      margin-inline-end: auto;
    }
    .cell-indicator {
      fill: #ACACAC;
    }
    .phone-cell > .cell-indicator {
      opacity: 0.3;
    }
    .bottom-instructionContentContainer {
      width: 100%;
      min-height: 125px;
      display: flex;
      flex-direction: column;
      align-items: center;
    }
    .bottom-instruction {
      width: calc(100% - 64px);
      height: 100%;
      box-sizing: border-box;
      display: flex;
      border-radius: 16px;
      background-color: #F8F8F8;
      flex-direction: column;
      justify-content: space-evenly;
      transform: translateY(-40px);
      padding-left: 12px;
    }
    .instruction {
      display: flex;
      align-items: center;
    }
    .instruction-number {  
      font-size: 11px;
      font-weight: bold;
      background-color: #FFFFFF;
      color: var(--color-brand-foreground2);
      padding: 0;
      border-radius: 50%;
      width: 20px;
      height: 20px;
      display: flex;
      align-items: center;
      justify-content: center;
      flex-shrink: 0;
    }
    .instruction-text {
      color: var(--text-secondary);
      font-size: 15px;
      font-weight: normal;
      padding-left: 15px;
    }
    .instruction-text .word-bold {
      color: var(--text-primary);
      font-weight: bold;
    }
    .divider {
      width: calc(100% - 24px);
      height: 1px;
      background-color: rgba(240, 240, 240, 0.5);
      margin-left: 25px;
    }
    .button-portrait {
      display: flex;
      flex-direction: column;
      align-items: center;
      align-self: stretch;
      padding: 0 32px;
    }
    .button-portrait .confirm {
      width: 100%;
    }
    .button-portrait .not-now {
      margin-top: 16px;
    }
    .button-landscape {
      display: none;
      align-items: center;
      box-sizing: border-box;
      padding: 12px 32px;
      align-self: stretch;
      border-top: 0.5px solid var(--divider-primary);
    }
    .button-landscape .confirm {
      margin-inline-start: 26px;
    }
    .button-landscape > * {
      flex: 1;
    }
    /* small iPhone devices (portrait)*/
    @media only screen 
    and (max-height: 667px) 
    and (orientation: portrait) {
      .bottom-instruction {
        transform: translateY(-20px);
      }
    }
    /* All iPad devices (portrait) */
    @media only screen 
    and (min-device-width: 1024px)
    and (orientation: portrait) {
      .bottom-instructionContentContainer {
        height: 200px;
      }
    }
    /* All iPhone devices (landscape) */
    @media only screen 
    and ((max-width: 1024px) and (orientation: landscape)) 
    and (-webkit-min-device-pixel-ratio: 2) {
      .button-landscape {
        display: flex;
      }
      .button-portrait {
        display: none;
      }
      .scale-container {
        display: none;
      }
      .bottom-instructionContentContainer {
        flex: 1;
        justify-content: center;
      }
      .bottom-instruction {
        height: 125px;
        transform: translateY(0px);
      }
    }
    @media (prefers-color-scheme: dark) {
      :host {
        background-color: var(--surfaces-primary);
      }
      .phone {
        border-color: var(--surfaces-secondary);
        background-color: var(--surfaces-tertiary);
      }
      .phone-mask {
        background: linear-gradient(180deg, rgba(33, 33, 33, 0) 0%, #000000 100%);
      }
      .phone-cell {
        opacity: 0.2;
        background-color: var(--surfaces-quaternary);
      }
      .phone-cell:nth-of-type(2) {
        border-color: rgba(48, 48, 48, 0.2);
      }
      .cell-edge {
        background-color: var(--surfaces-quaternary);
      }
      .cell-icon {
        background-color: rgba(225, 225, 225, 0.1);
      }
      .bottom-instruction {
        background-color: rgba(33, 33, 33, 1);
      }
      .instruction-number {
        background-color: var(--surfaces-quaternary);     
      }      
      .instruction-text {
        color: rgba(255, 255, 255, 0.9);
      }
      .instruction-text .word-bold {
        color: rgba(255, 255, 255, 1);
      }
      .divider {
        background-color: rgba(48, 48, 48, 0.2);
      }
    }
    `}onClickConfirm(){n({action:"setDefaultBrowser"},(()=>{this.onNext(!1)}))}render(){return r`
    <div class="page-number-with-icon-container" tabindex="0">
      ${this.renderIcon()}
      <div class="page-number-with-icon">${this.pageNumber}</div>
    </div>
    <div class="title" role="heading" aria-level="1" tabindex="0">${e.text(["fre_default_browser_title"])}</div>
    <div class="subtitle" tabindex="0">${e.text(["fre_default_browser_subtitle"])}</div>
    ${this.renderPhone()}
    <div class="bottom-instructionContentContainer">
    <div class="bottom-instruction">
    ${this.renderPhoneContent()}
    </div>
    </div>
    ${this.renderButtons()}
    `}renderIcon(){return r`
      <picture>
        <source srcset="./resources/default-browser-icon-dark.png" media="(prefers-color-scheme: dark)" />
        <img class="page-icon" src="./resources/default-browser-icon.png" aria-hidden="true"/>
      </picture>
    `}renderButtons(){const t=(t,i)=>r`
      <dewey-button class="confirm" size=${t} type=${i} @click=${this.onClickConfirm}>
        ${e.text(["fre_default_browser_button"])}
      </dewey-button>
    `,i=(t,i)=>r`
      <dewey-button class="not-now"  size=${t} type=${i} @click=${()=>this.onNext(!0)}>
        ${e.text(["common_not_now"])}
      </dewey-button>
    `;return r`
      <div class="button-portrait">
        ${t("large","accent")}
        ${i("medium","subtle")}
      </div>
      <div class="button-landscape">
        ${i("medium","outline-accent")}
        ${t("medium","accent")}
      </div>
    `}renderPhone(){return d(r`
      <div class="contentContainer">
      <div class="phone">
        ${this.renderIOS()}
        <div class="phone-mask"></div>
      </div>
      </div>
      `,{widthRadio:.7,heightRadio:.75})}renderIOS(){return r`
      <span class="phone-title">Edge</span>
      ${i([1,2,3],(e=>e),(e=>r`
      <div class="phone-cell">
        <div class="cell-icon"></div>
        ${e<=2?this.renderShortText():this.renderLongText()} ${this.renderRightArrow()} </div> `))} <div class="cell-edge">
          <div class="cell-edge-title">${e.text("fre_default_browser_setting_title_ios")}</div>
          <div class="cell-edge-subtitle">Edge</div>
          ${this.renderRightArrow()}
      </div>
    `}renderRightArrow(){return r`
      <svg class="cell-indicator" width="7" height="12" viewBox="0 0 7 12" xmlns="http://www.w3.org/2000/svg">
        <path
          d="M0.732712 0.206944C1.03263 -0.0787473 1.50737 -0.0672107 1.79306 0.232712L6.79439 5.48318C7.07032 5.77285 7.07032 6.22809 6.79439 6.51776L1.79306 11.7682C1.50737 12.0681 1.03263 12.0797 0.732712 11.794C0.432789 11.5083 0.421253 11.0336 0.706944 10.7336L5.21553 6.00047L0.706944 1.26729C0.421253 0.967369 0.432789 0.492635 0.732712 0.206944Z" />
      </svg>
    `}renderShortText(){return r`
      <svg class="cell-text" width="42" height="5" viewBox="0 0 42 5" xmlns="http://www.w3.org/2000/svg">
        <path
          d="M1 2.59813C1.38279 2.16903 2.41979 1.36385 3.50551 1.57587C4.86265 1.8409 4.23628 4.6805 5.90661 3.84755C7.57695 3.0146 8.41212 0.591481 9.66487 1.08368C10.9176 1.57587 10.3956 4.11258 11.544 3.27963C12.6924 2.44668 14.5715 0.856497 15.9286 1.72731C17.2858 2.59813 16.3462 3.96113 17.599 3.27963C18.8517 2.59813 18.8517 1.72731 20.0001 1.95448C21.1484 2.18165 22.088 3.46893 22.61 2.93887C23.132 2.40882 23.5495 0.591481 24.5935 1.08368C25.6375 1.57587 25.7419 4.33974 26.6814 3.46894C27.621 2.59813 28.0386 0.894368 29.1869 1.31084C30.3353 1.72731 30.0221 3.27962 31.3793 2.93887C32.7364 2.59813 33.0496 1.76517 33.7804 1.95448C34.5111 2.14379 35.0331 2.90102 35.9727 2.59813C36.7013 2.33271 38.1585 1.8815 38.1585 2.2C38.1585 2.5185 38.8871 2.82529 39.2514 2.93887L41 2.59813"
          stroke-width="2" />
      </svg>
    `}renderLongText(){return r`
      <svg class="cell-text" width="87" height="5" viewBox="0 0 87 5" xmlns="http://www.w3.org/2000/svg">
        <path
          d="M1 2.59813C1.38279 2.16903 2.41979 1.36385 3.50551 1.57587C4.86265 1.8409 4.23628 4.6805 5.90661 3.84755C7.57695 3.0146 8.41212 0.591481 9.66487 1.08368C10.9176 1.57587 10.3956 4.11258 11.544 3.27963C12.6924 2.44668 14.5715 0.856497 15.9286 1.72731C17.2858 2.59813 16.3462 3.96113 17.599 3.27963C18.8517 2.59813 18.8517 1.72731 20.0001 1.95448C21.1484 2.18165 22.088 3.46893 22.61 2.93887C23.132 2.40882 23.5495 0.591481 24.5935 1.08368C25.6375 1.57587 25.7419 4.33974 26.6814 3.46894C27.621 2.59813 28.0386 0.894368 29.1869 1.31084C30.3353 1.72731 30.0221 3.27962 31.3793 2.93887C32.7364 2.59813 33.0496 1.76517 33.7804 1.95448C34.5111 2.14379 35.0331 2.90102 35.9727 2.59813C36.7013 2.33271 38.1585 1.8815 38.1585 2.2C38.1585 2.5185 38.8871 2.82529 39.2514 2.93887L41 2.59813"
          stroke-width="2" />
        <path
          d="M86 2.59813C85.4981 2.16903 84.1385 1.36385 82.715 1.57587C80.9356 1.8409 81.7568 4.6805 79.5668 3.84755C77.3768 3.0146 76.2818 0.591481 74.6392 1.08368C72.9967 1.57587 73.6811 4.11258 72.1755 3.27963C70.6698 2.44668 68.206 0.856497 66.4266 1.72731C64.6473 2.59813 65.8791 3.96113 64.2366 3.27963C62.5941 2.59813 62.5941 1.72731 61.0885 1.95448C59.5828 2.18165 58.3509 3.46893 57.6665 2.93887C56.9822 2.40882 56.4347 0.591481 55.0659 1.08368C53.6971 1.57587 53.5602 4.33974 52.3284 3.46894C51.0965 2.59813 50.549 0.894368 49.0433 1.31084C47.5377 1.72731 47.9483 3.27962 46.1689 2.93887C44.3895 2.59813 43.9789 1.76517 43.0208 1.95448C42.0626 2.14379 40.2319 3.20289 39 2.9"
          stroke-width="2" />
      </svg>
    `}renderPhoneContent(){const t=(t,i)=>r`
        <div class="instruction">
          <div class="instruction-number">${t}</div>
            <div class="instruction-text">
              ${o(e.text(i,{begin_bold:"<span class='word-bold'>",end_bold:"</span>"}))}
            </div>
           </div>
        </div>
      `;return r`
      ${t("1","fre_default_browser_instruction_text1")}
      <div class="divider"></div>
      ${t("2","fre_default_browser_instruction_text2")}
      <div class="divider"></div>
      ${t("3","fre_default_browser_instruction_text3")}
  `}});