// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"../common/dewey/dewey-button.js";import e from"../common/i18n.js";import{css as r,html as i,repeat as t}from"../common/lit.js";import{sendMessage as o}from"../common/message.js";import{commonCss as n,edgeLogo as d,FREBaseElement as a,scaleContainer as l}from"./edge-fre-common.js";customElements.define("edge-fre-default-browser-android",class extends a{static get styles(){return r`
    ${n}
    .title {
      align-self: flex-start;
      margin-left: 32px;
      margin-right: 32px;
      font-size: 26rem;
      line-height: 31rem;
      font-weight: 700;
      color: var(--text-primary);
      white-space: pre-wrap;
      text-align: start;
    }
    .subtitle {
      align-self: flex-start;
      margin: 8px 32px 0;
      font-size: 15rem;
      line-height: 20rem;
      color: var(--text-secondary);
    }
    .phone {
      width: 266px;
      height: 365px;
      box-sizing: border-box;
      border-radius: 34px 34px 0 0;
      border-width: 4px 4px 0;
      border-color: var(--surfaces-quaternary);
      border-style: solid;
      background-color: #F2F1F6;
      display: flex;
      flex-direction: column;
      align-items: center;
    }
    .phone-back {
      position: absolute;
      top: 33px;
      left: 18px;
    }
    .cell-edge {
      --width: 313px;
      position: absolute;
      width: var(--width);
      height: 57px;
      top: 212px;
      left: calc(50% - var(--width) / 2);
      box-sizing: border-box;
      border-radius: 8px;
      background-color: #FFFFFF;
      border: 2px solid #404040;
      display: flex;
      align-items: center;
      padding: 0 14px;
    }
    .cell-edge-title {
      font-weight: 500;
      font-size: 15px;
      line-height: 20px;
      color: var(--text-primary);
    }
    .cell-edge-subtitle {
      font-size: 15px;
      line-height: 20px;
      margin-inline-start: auto;
      margin-inline-end: 7px;
      color: var(--text-secondary);
    }
    .phone-mask {
      --width: 320px;
      position: absolute;
      width: var(--width);
      height: 63px;
      left: calc(50% - var(--width) / 2);
      bottom: 0;
      background: linear-gradient(180deg, rgba(255, 255, 255, 0) 0%, #FFFFFF 100%);
    }
    .phone-title {
      margin: 29px 0;
      color: var(--text-secondary);
      font-size: 13px;
      line-height: 18px;
      font-weight: 500;
    }
    .phone-cell {
      box-sizing: border-box;
      width: 234px;
      height: 40px;
      background-color: #FFFFFF;
      display: flex;
      align-items: center;
      padding: 0 16px 0 12px;
      opacity: 0.6;
    }
    .phone-cell:nth-of-type(1) {
      border-radius: 8px 8px 0 0;
    }
    .phone-cell:nth-of-type(2) {
      border-width: 1px 0;
      border-style: solid;
      border-color: rgba(225, 225, 225, 0.2);
    }
    .phone-cell:nth-of-type(3) {
      border-radius: 0 0 8px 8px;
    }
    .phone-cell:nth-of-type(4) {
      margin-top: 89px;
      border-radius: 8px;
    }
    .cell-icon {
      width: 16px;
      height: 16px;
      border-radius: 4px;
      margin-inline-end: 10px;
      background-color: var(--surfaces-tertiary);
    }
    .cell-text {
      stroke: #ACACAC;
      opacity: 0.2;
      margin-inline-end: auto;
    }
    .cell-indicator {
      fill: #ACACAC;
    }
    .phone-cell > .cell-indicator {
      opacity: 0.3;
    }

    /* Android */
    .android-container {
      width: 100%;
      height: 100%;
      top: 0;
      left: 0;
      display: flex;
      justify-content: center;
      align-items: flex-end;
      overflow: hidden;
    }
    .android-content {
      width: 210px;
      height: 329px;
      border-radius: 24px 24px 0 0;
      background-color: rgba(255, 255, 255, 0.6);
      box-shadow: 0px 6px 10px rgba(0, 0, 0, 0.14), 0px 1px 18px rgba(0, 0, 0, 0.12), 0px 3px 5px rgba(0, 0, 0, 0.2);
      display: flex;
      flex-direction: column;
      align-items: center;
      box-sizing: border-box;
      padding-top: 24px;
    }
    .android-title {
      font-size: 12px;
      line-height: 16px;
      margin: 12px 0;
      box-sizing: border-box;
      padding: 0 24px;
      text-align: center;
      color: var(--text-secondary);
    }
    .android-cell {
      width: 100%;
      height: 40px;
      display: flex;
      align-items: center;
      border-bottom: 1px solid rgba(225, 225, 225, 0.2);
      box-sizing: border-box;
      padding-inline-start: 16px;
      padding-inline-end: 13px;
    }
    .android-cell-edge {
      margin-inline-start: 10px;
      margin-inline-end: auto;
      color: var(--text-primary);
    }
    .check-border {
      width: 16px;
      height: 16px;
      box-sizing: border-box;
      border-radius: 50%;
      border: 1px solid var(--icon-secondary);
      display: flex;
      justify-content: center;
      align-items: center;
    }
    .check-inner {
      width: 8px;
      height: 8px;
      border-radius: 50%;
      background-color: var(--icon-secondary);
    }
    .uncheck {
      width: 16px;
      height: 16px;
      box-sizing: border-box;
      opacity: 0.2;
      border-radius: 50%;
      border: 1px solid #ACACAC;
    }
    .button-portrait {
      display: flex;
      flex-direction: column;
      align-items: center;
      align-self: stretch;
      padding: 0 32px;
    }
    .button-portrait .confirm {
      width: 100%;
    }
    .button-portrait .not-now {
      margin-top: 16px;
    }
    .button-landscape {
      display: none;
      align-items: center;
      box-sizing: border-box;
      padding: 12px 32px;
      align-self: stretch;
      border-top: 0.5px solid var(--divider-primary);
    }
    .button-landscape .confirm {
      margin-inline-start: 26px;
    }
    .button-landscape > * {
      flex: 1;
    }
    @media (orientation: landscape) {
      .button-landscape {
        display: flex;
      }
      .button-portrait {
        display: none;
      }
    }
    @media (prefers-color-scheme: dark) {
      :host {
        background-color: var(--surfaces-primary);
      }
      .phone {
        border-color: var(--surfaces-secondary);
        background-color: var(--surfaces-tertiary);
      }
      .phone-mask {
        background: linear-gradient(180deg, rgba(33, 33, 33, 0) 0%, #000000 100%);
      }
      .phone-cell {
        opacity: 0.2;
        background-color: var(--surfaces-quaternary);
      }
      .phone-cell:nth-of-type(2) {
        border-color: rgba(48, 48, 48, 0.2);
      }
      .cell-edge {
        background-color: var(--surfaces-quaternary);
      }
      .android-content {
        background-color: var(--surfaces-tertiary);
      }
      .android-cell {
        border-bottom-color: rgba(48, 48, 48, 0.2)
      }
      .cell-icon {
        background-color: rgba(225, 225, 225, 0.1);
      }
      .check-border {
        border-color: var(--icon-primary);
      }
      .check-inner {
        background-color: var(--icon-primary);
      }
    }
    `}onClickConfirm(){o({action:"setDefaultBrowser"},(()=>{this.onNext(!1)}))}render(){return i`
    <div class="page-number-with-icon-container" tabindex="0">
      ${this.renderIcon()}
    </div>
    <div class="title" role="heading" aria-level="1" tabindex="0">${e.text(["fre_default_browser_title"])}</div>
    <div class="subtitle" tabindex="0">${e.text(["fre_default_browser_subtitle"])}</div>
    ${this.renderPhone()}
    ${this.renderButtons()}
    `}renderIcon(){return i`
      <picture>
        <source srcset="./resources/default-browser-icon-dark.png" media="(prefers-color-scheme: dark)" />
        <img class="page-icon" src="./resources/default-browser-icon.png" aria-hidden="true"/>
      </picture>
    `}renderButtons(){const r=(r,t)=>i`
      <dewey-button class="confirm" size=${r} type=${t} @click=${this.onClickConfirm}>
        ${e.text(["fre_default_browser_button"])}
      </dewey-button>
    `,t=(r,t)=>i`
      <dewey-button class="not-now"  size=${r} type=${t} @click=${()=>this.onNext(!0)}>
        ${e.text(["common_not_now"])}
      </dewey-button>
    `;return i`
      <div class="button-portrait">
        ${r("large","accent")}
        ${t("medium","subtle")}
      </div>
      <div class="button-landscape">
        ${t("medium","outline-accent")}
        ${r("medium","accent")}
      </div>
    `}renderPhone(){return l(i`
    <div class="phone">
      ${this.renderAndroid()}
      <div class="phone-mask"></div>
    </div>
    `,{widthRadio:.7,heightRadio:.75})}renderAndroid(){return i`
      <div class="android-container">
        <div class="android-content">
          ${d()}
          <div class="android-title">${e.text("fre_default_browser_setting_title_android")}</div>
          ${t([1,2,3,4,5,6],(e=>e),(e=>i`
            <div class="android-cell">
              ${3===e?i`
                  ${d()}
                  <div class="android-cell-edge">Edge</div>
                  <div class="check-border"><div class="check-inner"></div></div>
                `:i`
                  <div class="cell-icon"></div>
                  ${this.renderText()}
                  <div class="uncheck"></div>
                `}
            </div>
          `))}
        </div>
      </div>
    `}renderText(){return i`
      <svg class="cell-text" width="42" height="5" viewBox="0 0 42 5" xmlns="http://www.w3.org/2000/svg">
        <path
          d="M1 2.59813C1.38279 2.16903 2.41979 1.36385 3.50551 1.57587C4.86265 1.8409 4.23628 4.6805 5.90661 3.84755C7.57695 3.0146 8.41212 0.591481 9.66487 1.08368C10.9176 1.57587 10.3956 4.11258 11.544 3.27963C12.6924 2.44668 14.5715 0.856497 15.9286 1.72731C17.2858 2.59813 16.3462 3.96113 17.599 3.27963C18.8517 2.59813 18.8517 1.72731 20.0001 1.95448C21.1484 2.18165 22.088 3.46893 22.61 2.93887C23.132 2.40882 23.5495 0.591481 24.5935 1.08368C25.6375 1.57587 25.7419 4.33974 26.6814 3.46894C27.621 2.59813 28.0386 0.894368 29.1869 1.31084C30.3353 1.72731 30.0221 3.27962 31.3793 2.93887C32.7364 2.59813 33.0496 1.76517 33.7804 1.95448C34.5111 2.14379 35.0331 2.90102 35.9727 2.59813C36.7013 2.33271 38.1585 1.8815 38.1585 2.2C38.1585 2.5185 38.8871 2.82529 39.2514 2.93887L41 2.59813"
          stroke-width="2" />
      </svg>
    `}});