// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"../../common/dewey/dewey-button.js";import e from"../../common/i18n.js";import{css as t,html as i,when as r}from"../../common/lit.js";import{sendMessage as n}from"../../common/message.js";import{commonCss as a,FREBaseElement as o}from"../edge-fre-common.js";customElements.define("edge-fre-privacy-xiaomi",class extends o{static get styles(){return t`
      ${a}
      .title {
        align-self: flex-start;
        margin-left: 32px;
        margin-right: 32px;
        font-size: 26rem;
        line-height: 31rem;
        font-weight: 700;
        color: var(--text-primary);
        white-space: pre-wrap;
        text-align: start;
      }
      .content {
        width: 100%;
        margin-top: 30px;
        margin-bottom: 20px;
        flex: 1;
        overflow: auto;
      }
      .privacy-content, .privacy-improve {
        background-color: var(--surfaces-secondary);
        border-radius: 8px;
        font-size: 13rem;
        line-height: 18rem;
        color: var(--text-primary);
        padding: 16px;
        margin-inline-start: 32px;
        margin-inline-end: 32px;
      }
      .privacy-improve {
        margin-top: 16px;
      }
      .action-text {
        display: inline;
        color: var(--accent-shade-10);
      }
      .confirm-child {
        margin: auto 32px 0;
        align-self: stretch;
      }
      .button-portrait {
        display: flex;
        flex-direction: column;
        align-items: center;
        align-self: stretch;
        padding: 0 32px;
      }
      .button-portrait .confirm {
        width: 100%;
      }
      .button-portrait .not-now {
        width: 100%;
        margin-top: 8px;
      }
      .button-landscape {
        display: none;
        align-items: center;
        box-sizing: border-box;
        padding: 12px 32px;
        align-self: stretch;
        border-top: 0.5px solid var(--divider-primary);
      }
      .button-landscape .confirm {
        margin-inline-start: 26px;
      }
      .button-landscape > * {
        flex: 1;
      }
      @media (orientation: landscape) {
        .button-landscape {
          display: flex;
        }
        .button-portrait {
          display: none;
        }
      }
      @media (prefers-color-scheme: dark) {
        :host {
          background-color: var(--surfaces-primary);
        }
        .privacy-content, .privacy-improve {
          background-color: var(--surfaces-tertiary);
        }
        .action-text {
          color: var(--accent-primary);
        }
      }
    `}static get properties(){return{agree:{type:Boolean},isChild:{type:Boolean}}}constructor(){super(),this.agree=!1,this.isChild=!1,n({action:"accountInfo"},(e=>{const{aadc:t,child:i}=e||{};this.isChild=i,this.agree=!t&&!i}))}onClickLink(e){n({action:"navigate",payload:{page:e}})}onClickConfirm(e){n({action:"setAllowDiagnostic",payload:{value:e}}),this.onNext(!1)}render(){return i`
      <div class="page-number-with-icon-container" tabindex="0">
        ${this.renderIcon()}
        <div class="page-number-with-icon">${this.pageNumber}</div>
      </div>
      <div class="title" role="heading" aria-level="1" tabindex="0">${e.text(["fre_privacy_title_dma"])}</div>
      <div class="content">
        <div class="privacy-content">
          <span tabindex="0">${e.text(["fre_privacy_description"])}</span>
          <br/>
          <edge-accessible-link class="action-text" @click=${()=>this.onClickLink("privacyStatement")}>
            ${e.text(["fre_privacy_statement"])}
          </edge-accessible-link>
          <span aria-hidden="true">&nbsp;|&nbsp;</span>
          <edge-accessible-link class="action-text" @click=${()=>this.onClickLink("termsOfUser")}>
            ${e.text(["fre_privacy_terms"])}
          </edge-accessible-link>
        </div>
        ${this.renderDiagnostic()}
      </div>
      ${this.isChild?this.renderChildButton():this.renderButtons()}
    `}renderIcon(){return i`
      <picture>
        <source srcset="./../resources/microsoft-logo-dark.png" media="(prefers-color-scheme: dark)" />
        <img class="page-icon" src="./../resources/microsoft-logo.png" aria-hidden="true"/>
      </picture>
    `}renderButtons(){const t=(t,r)=>i`
      <dewey-button class="confirm" size=${t} type=${r} @click=${()=>this.onClickConfirm(!0)}>
        ${e.text(["fre_privacy_send_button_dma"])}
      </dewey-button>
    `,r=(t,r)=>i`
      <dewey-button class="not-now"  size=${t} type=${r} @click=${()=>this.onClickConfirm(!1)}>
        ${e.text(["fre_privacy_not_send_button_dma"])}
      </dewey-button>
    `;return i`
      <div class="button-portrait">
        ${t("large","outline-accent")}
        ${r("large","outline-accent")}
      </div>
      <div class="button-landscape">
        ${r("medium","outline-accent")}
        ${t("medium","outline-accent")}
      </div>
    `}renderChildButton(){return i`
      <dewey-button class="confirm-child" size='large' type='outline-accent' @click=${()=>this.onClickConfirm(!1)}>
        ${e.text(["common_confirm"])}
      </dewey-button>
    `}renderDiagnostic(){return r(!this.isChild,(()=>i`
      <div class="privacy-improve">
          <div>
            <span id="fre_privacy_improve" tabindex="0">${e.text(["fre_privacy_improve"])}</span>
            <edge-accessible-link class="action-text" @click=${e=>{e.stopPropagation(),this.onClickLink("learnMore")}}>
              ${e.text(["fre_privacy_learn_more"])}
            </edge-accessible-link>
          </div>
      </div>
      `))}});