// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"../../common/dewey/dewey-button.js";import t from"../../common/i18n.js";import{css as e,html as i}from"../../common/lit.js";import{sendMessage as r}from"../../common/message.js";import{commonCss as a,FREBaseElement as n,scaleContainer as o}from"../edge-fre-common.js";customElements.define("edge-fre-ending-copilot-default",class extends n{static get properties(){return{allowWebFREExp:{type:Boolean}}}static get styles(){return e`
    ${a}
    .content {
      width: 100%;
      height: 100%;
      top: 0;
      left: 0;
      display: flex;
      flex-direction: column;
      align-items: center;
    }
    .icon {
      width: 96px;
      height: 96px;
      margin-top: calc(-100vh * 200 / 812 + var(--top-margin));
      display: flex;
      justify-content: center;
    }
    .title {
      text-align: center;
      width: 300px;
      font-family: 'SF Pro Display', sans-serif;
      font-size: 26rem;
      font-style: normal;
      font-weight: 700;
      line-height: 31px; /* 119.231% */
      letter-spacing: 0.33px;
      margin: 32px 32px 24px 32px;
      background: linear-gradient(93deg, #8230FF 0%, #2169EB 52.26%, #038387 103.44%);
      background-clip: text;
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      transform: translateZ(0);
    }
    .subtitle {
      text-align: center;
      font-family: 'SF Pro Text', sans-serif;
      font-size: 15rem;
      font-style: normal;
      font-weight: 500;
      line-height: 20px; /* 133.333% */
      letter-spacing: -0.24px;
      background: linear-gradient(93deg, #8230FF 0%, #2169EB 52.26%, #038387 103.44%);
      background-clip: text;
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      transform: translateZ(0);
    }
    .wrapper {
      display: flex;
      justify-content: center;
      align-items: center;
      text-align: center;
      gap: 8px;
    }
    .button-portrait {
      display: flex;
      flex-direction: column;
      align-items: center;
      align-self: stretch;
      padding: 0 32px;
    }
    .button-portrait .next {
      width: 100%;
    }
    .button-portrait .not-now {
      margin-top: 16px;
    }
    .button-landscape {
      display: none;
      align-items: center;
      box-sizing: border-box;
      padding: 12px 32px;
      align-self: stretch;
      border-top: 0.5px solid var(--divider-primary);
    }
    .button-landscape .next {
      margin-inline-start: 26px;
    }
    .button-landscape > * {
      flex: 1;
    }
    @media (prefers-color-scheme: dark) {
      :host {
        background-color: var(--surfaces-primary);
      }
      .title{
        background: linear-gradient(93deg, #B696FF 0%, #69A1FA 52.26%, #4CB4B7 103.44%);
        background-clip: text;
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
      }
      .subtitle{
        background: linear-gradient(93deg, #B696FF 0%, #69A1FA 52.26%, #4CB4B7 103.44%);
        background-clip: text;
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
      }
    }
    @media (orientation: landscape) {
      .button-landscape {
        display: flex;
      }
      .button-portrait {
        display: none;
      }
    }
    `}startChat(){r({action:"startChat"}),this.onNext(!1)}renderIcon(){return i`
    <div class="icon">
      <svg xmlns="http://www.w3.org/2000/svg" width="96" height="97" viewBox="0 0 96 97" fill="none">
        <g clip-path="url(#clip0_162_1309)">
          <path d="M70.2396 13.4009C68.9042 9.2753 65.062 6.48047 60.7256 6.48047L57.4181 6.48047C52.5846 6.48047 48.443 9.93758 47.5791 14.6932L42.8955 40.4773L44.317 35.6537C45.5704 31.4005 49.475 28.4805 53.9091 28.4805H70.5889L77.7764 32.0519L84.7049 28.4805H82.3946C78.0582 28.4805 74.216 25.6856 72.8806 21.56L70.2396 13.4009Z" fill="url(#paint0_radial_162_1309)"/>
          <path d="M26.7901 83.5161C28.1117 87.6641 31.9649 90.4805 36.3182 90.4805H42.7945C48.286 90.4805 52.7501 86.0521 52.7941 80.5607L52.9848 56.8086L51.6363 61.3365C50.3737 65.576 46.4758 68.4823 42.0523 68.4823L25.2465 68.4823L19.0858 64.3722L12.416 68.4823H14.6911C19.0444 68.4823 22.8976 71.2987 24.2192 75.4466L26.7901 83.5161Z" fill="url(#paint1_radial_162_1309)"/>
          <path d="M59.9995 6.48047H24.9995C14.9995 6.48047 8.99945 19.4805 4.99945 32.4805C0.260492 47.8821 -5.94054 68.4805 11.9994 68.4805H27.224C31.6781 68.4805 35.5923 65.5456 36.8353 61.2684C39.4631 52.2257 44.0671 36.4547 47.6836 24.4487C49.5217 18.3466 51.0528 13.1059 53.4026 9.84237C54.7199 8.01269 56.9155 6.48047 59.9995 6.48047Z" fill="url(#paint2_linear_162_1309)"/>
          <path d="M59.9995 6.48047H24.9995C14.9995 6.48047 8.99945 19.4805 4.99945 32.4805C0.260492 47.8821 -5.94054 68.4805 11.9994 68.4805H27.224C31.6781 68.4805 35.5923 65.5456 36.8353 61.2684C39.4631 52.2257 44.0671 36.4547 47.6836 24.4487C49.5217 18.3466 51.0528 13.1059 53.4026 9.84237C54.7199 8.01269 56.9155 6.48047 59.9995 6.48047Z" fill="url(#paint3_linear_162_1309)"/>
          <path d="M35.9922 90.4805H70.9922C80.9922 90.4805 86.9922 77.4805 90.9922 64.4805C95.7311 49.0788 101.932 28.4805 83.9922 28.4805H68.7677C64.3136 28.4805 60.3993 31.4154 59.1564 35.6925C56.5285 44.7352 51.9245 60.5062 48.308 72.5122C46.4699 78.6144 44.9388 83.855 42.5891 87.1186C41.2717 88.9482 39.0761 90.4805 35.9922 90.4805Z" fill="url(#paint4_radial_162_1309)"/>
          <path d="M35.9922 90.4805H70.9922C80.9922 90.4805 86.9922 77.4805 90.9922 64.4805C95.7311 49.0788 101.932 28.4805 83.9922 28.4805H68.7677C64.3136 28.4805 60.3993 31.4154 59.1564 35.6925C56.5285 44.7352 51.9245 60.5062 48.308 72.5122C46.4699 78.6144 44.9388 83.855 42.5891 87.1186C41.2717 88.9482 39.0761 90.4805 35.9922 90.4805Z" fill="url(#paint5_linear_162_1309)"/>
        </g>
        <defs>
          <radialGradient id="paint0_radial_162_1309" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(78.6169 40.6995) rotate(-130.498) scale(36.484 34.5649)">
            <stop offset="0.0955758" stop-color="#0078D4"/>
            <stop offset="0.715277" stop-color="#0C709B"/>
            <stop offset="1" stop-color="#0A5079"/>
          </radialGradient>
          <radialGradient id="paint1_radial_162_1309" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(19.7761 67.896) rotate(43.3549) scale(32.8972 32.2836)">
            <stop stop-color="#0091EB"/>
            <stop offset="0.523516" stop-color="#2764E7"/>
            <stop offset="0.923392" stop-color="#0636C3"/>
          </radialGradient>
          <linearGradient id="paint2_linear_162_1309" x1="18.1825" y1="6.48047" x2="29.1239" y2="71.9561" gradientUnits="userSpaceOnUse">
            <stop offset="0.289817" stop-color="#00A5D9"/>
            <stop offset="0.662336" stop-color="#21CAB2"/>
            <stop offset="0.950002" stop-color="#6ADC90"/>
          </linearGradient>
          <linearGradient id="paint3_linear_162_1309" x1="27.2689" y1="6.48047" x2="29.9075" y2="68.4842" gradientUnits="userSpaceOnUse">
            <stop stop-color="#10C9EC"/>
            <stop offset="0.166667" stop-color="#01AEE4" stop-opacity="0"/>
          </linearGradient>
          <radialGradient id="paint4_radial_162_1309" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(85.7901 22.4102) rotate(111.785) scale(82.4266 100.077)">
            <stop offset="0.154405" stop-color="#2771D8"/>
            <stop offset="0.678875" stop-color="#14B1FF"/>
            <stop offset="0.931138" stop-color="#16BFDF"/>
          </radialGradient>
          <linearGradient id="paint5_linear_162_1309" x1="88.3195" y1="26.117" x2="84.369" y2="50.0539" gradientUnits="userSpaceOnUse">
            <stop offset="0.0581535" stop-color="#14B1FF"/>
            <stop offset="0.708063" stop-color="#2976DB" stop-opacity="0"/>
          </linearGradient>
          <clipPath id="clip0_162_1309">
            <rect width="96" height="96" fill="white" transform="translate(0 0.480469)"/>
          </clipPath>
        </defs>
      </svg>
    </div>
    `}renderContainer(){return o(i`
      <div class="container">
        <div class="content">
          ${this.renderIcon()}
          <div class="title" role="heading" >${t.text(["fre_edge_chat_title"])}</div>
            <div class="subtitle" tabindex="0">${t.text(["fre_edge_chat_subtitle"])}</div>
        </div>
      </div>
    `,{callback:t=>{const e=t.children[0],i=t.offsetWidth/e.offsetWidth,r=t.offsetHeight/e.offsetHeight,a=Math.min(Math.round(10*Math.min(i,r))/10,1);e.style.transform=`translate(-50%, -50%) scale(${a})`},a11y:!0})}renderButtons(){const e=(e,r)=>i`
      <dewey-button class="next" size=${e} type=${r} @click=${this.startChat}>
        ${t.text(["fre_edge_chat_start_chat"])}
      </dewey-button>
    `,r=(e,r)=>i`
      <dewey-button class="not-now" size=${e} type=${r} @click=${()=>this.onNext(!0)}>
        ${t.text(["fre_edge_chat_start_browsing"])}
      </dewey-button>
    `;return i`
      <div class="button-portrait">
        ${e("large","accent")}
        ${r("medium","subtle")}
      </div>
      <div class="button-landscape">
        ${r("medium","outline-accent")}
        ${e("medium","accent")}
      </div>
    `}render(){return i`
    ${this.renderContainer()}
    ${this.renderButtons()}
    `}});