// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import e from"../../common/i18n.js";import{sendMessage as t}from"../../common/message.js";import{html as n,css as r}from"../../common/lit.js";import"../../common/dewey/dewey-button.js";import{commonCss as i,scaleContainer as o,FREBaseElement as a}from"../edge-fre-common.js";customElements.define("edge-fre-default-browser-new-bing",class extends a{static get styles(){return r`
    ${i}
    .title {
      align-self: flex-start;
      margin-left: 32px;
      margin-right: 32px;
      font-size: 26rem;
      line-height: 31rem;
      font-weight: 700;
      color: var(--text-primary);
      white-space: pre-wrap;
      text-align: start;
    }
    .phone {
      width: 375px;
      height: 400px;
      display: flex;
    }
    .new-bing-chat {
      object-fit: cover;
      pointer-events: none;
      content: url("./resources/codex-light.png");
    }
    .button-portrait {
      display: flex;
      flex-direction: column;
      align-items: center;
      align-self: stretch;
      padding: 0 32px;
    }
    .button-portrait .confirm {
      width: 100%;
    }
    .button-portrait .not-now {
      width: 100%;
      margin-top: 8px;
    }
    .button-landscape {
      display: none;
      align-items: center;
      box-sizing: border-box;
      padding: 12px 32px;
      align-self: stretch;
      border-top: 0.5px solid var(--divider-primary);
    }
    .button-landscape .confirm {
      margin-inline-start: 26px;
    }
    .button-landscape > * {
      flex: 1;
    }
    @media (orientation: landscape) {
      .button-landscape {
        display: flex;
      }
      .button-portrait {
        display: none;
      }
    }
    @media (prefers-color-scheme: dark) {
      :host {
        background-color: var(--surfaces-primary);
      }
      .phone {
        background-color: var(--surfaces-primary);
      }
      .new-bing-chat {
        content: url("./resources/codex-dark.png");
      }
    }
    `}onClickConfirm(){t({action:"setDefaultBrowser"},(()=>{this.onNext(!1)}))}render(){return n`
    <div class="page-number-with-icon-container" tabindex="0">
      ${this.renderIcon()}
      <div class="page-number-with-icon">${this.pageNumber}</div>
    </div>
    <div class="title" role="heading" aria-level="1" tabindex="0">${e.text(["fre_default_browser_for_new_bing_title"])}</div>
    ${this.renderPhone()}
    ${this.renderButtons()}
    `}renderIcon(){return n`
      <picture>
        <source srcset="./resources/codex-chat-icon-dark.png" media="(prefers-color-scheme: dark)" />
        <img class="page-icon" src="./resources/codex-chat-icon.png" aria-hidden="true"/>
      </picture>
    `}renderButtons(){const t=(t,r)=>n`
      <dewey-button class="confirm" size=${t} type=${r} @click=${this.onClickConfirm.bind(this)}>
        ${e.text(["fre_default_browser_for_new_bing_button"])}
      </dewey-button>
    `,r=(t,r)=>n`
      <dewey-button class="not-now"  size=${t} type=${r} @click=${()=>this.onNext(!0)}>
        ${e.text(["fre_default_browser_for_new_bing_no_button"])}
      </dewey-button>
    `;return n`
      <div class="button-portrait">
        ${t("large","outline-accent")}
        ${r("large","outline-accent")}
      </div>
      <div class="button-landscape">
        ${r("medium","outline-accent")}
        ${t("medium","outline-accent")}
      </div>
    `}renderPhone(){return o(n`
    <div class="phone">
     <div class="new-bing-chat"></div>
    </div>
    `,{widthRadio:1,heightRadio:.8})}});