// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import e from"../../common/i18n.js";import t from"../../common/animation.js";import{sendMessage as i}from"../../common/message.js";import{html as r,css as s,repeat as o}from"../../common/lit.js";import"../../common/controls/edge-switch.js";import"../../common/dewey/dewey-button.js";import{commonCss as n,toolbarSVG as a,searchSVG as c,msLogo as d,scaleContainer as l,FREBaseElement as h}from"../edge-fre-common.js";const p={IMAGE:"image",SITES:"sites",FEEDS:"feeds"};customElements.define("edge-fre-customize",class extends h{static get properties(){return{setting:{type:Object}}}static get styles(){return s`
    ${n}
    .title {
      align-self: flex-start;
      margin-left: 32px;
      margin-right: 32px;
      font-size: 26rem;
      line-height: 31rem;
      font-weight: 700;
      color: var(--text-primary);
      white-space: pre-wrap;
      text-align: start;
    }
    .setting-item {
      margin: 20px 32px 0;
      display: flex;
      align-items: center;
      align-self: stretch;
      font-size: 16rem;
    }
    .setting-name {
      flex: 1;
      margin-inline-end: auto;
      color: var(--text-primary);
    }
    .phone {
      width: 140px;
      height: 280px;
      box-sizing: border-box;
      border-radius: 20px;
      border: 2px solid #ECECEC;
      overflow: hidden;
      background: linear-gradient(23.78deg, #DFE9F3 11.68%, #FFFFFF 77.96%);
    }
    .phone-bg {
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      width: 100%;
      height: 100%;
      object-fit: cover;
      pointer-events: none;
      will-change: opacity;
    }
    .ms-logo {
      --width: 56px;
      position: absolute;
      width: var(--width);
      height: 12px;
      left: calc(50% - var(--width) / 2);
      bottom: 160px;
      opacity: 0;
      will-change: opacity;
    }
    .toolbar {
      position: absolute;
      width: 100%;
      height: 25px;
      bottom: 0;
      left: 0;
      right: 0;
      will-change: opacity;
    }
    .feed-indicator {
      position: absolute;
      width: 100%;
      left: 0;
      height: 15px;
      bottom: 25px;
      font-weight: 300;
      display: flex;
      justify-content: center;
      align-items: center;
      color: #FFFFFF;
      fill: #FFFFFF;
      will-change: opacity;
    }
    .feed-indicator > *:last-child {
      margin-inline-start: 4px;
      font-size: 6px;
      line-height: 6px;
    }
    .sites-list {
      position: absolute;
      width: 100%;
      left: 0;
      bottom: 70px;
      height: 38px;
      display: flex;
      justify-content: space-between;
      align-items: flex-start;
      padding: 0 4px;
      box-sizing: border-box;
      will-change: opacity;
    }
    .site-item {
      flex: 1;
      display: flex;
      flex-direction: column;
      align-items: center;
    }
    .site-icon {
      width: 18px;
      height: 18px;
      object-fit: cover;
      pointer-events: none;
    }
    .site-name {
      font-size: 4.5px;
      font-weight: 300;
      text-align: center;
      color: #FFFFFF;
    }
    .search-bar {
      position: absolute;
      width: 100%;
      left: 0;
      bottom: 110px;
      height: 30px;
      display: flex;
      justify-content: center;
      align-items: center;
      will-change: opacity;
    }
    .search-text {
      --height: 8px;
      position: absolute;
      color: #6E6E6E;
      font-size: 5.5px;
      font-weight: 350;
      line-height: var(--height);
      left: 15px;
      top: calc(50% - var(--height) / 2);
    }
    .search {
      width: 90%;
    }
    .button-portrait {
      display: flex;
      flex-direction: column;
      align-items: center;
      align-self: stretch;
      padding: 0 32px;
    }
    .button-portrait .next {
      width: 100%;
    }
    .button-portrait .not-now {
      margin-top: 16px;
    }
    .button-landscape {
      display: none;
      align-items: center;
      box-sizing: border-box;
      padding: 12px 32px;
      align-self: stretch;
      border-top: 0.5px solid var(--divider-primary);
    }
    .button-landscape .next {
      margin-inline-start: 26px;
    }
    .button-landscape > * {
      flex: 1;
    }
    @media (prefers-color-scheme: dark) {
      :host {
        background-color: var(--surfaces-primary);
      }
      .phone {
        border-color: var(--surfaces-quaternary);
      }
    }
    @media (orientation: landscape) {
      .button-landscape {
        display: flex;
      }
      .button-portrait {
        display: none;
      }
    }
    @media screen and (max-height: 370px) {
      .setting-item {
        margin-top: 5px;
      }
    }
    `}constructor(){super(),this.setting={[p.IMAGE]:!0,[p.SITES]:!0,[p.FEEDS]:!0}}onClickNext(){i({action:"customizeNTP",payload:this.setting}),this.onNext(!1)}onSettingChange(e,i){switch(this.setting={...this.setting,[e]:i},e){case p.IMAGE:t({duration:200}).add([{targets:this.renderRoot.querySelector(".phone-bg"),opacity:i?1:0},{targets:this.renderRoot.querySelector(".ms-logo"),opacity:i?0:1},{targets:this.renderRoot.querySelector(".search-bar"),filter:i?"unset":"drop-shadow(0px 4px 8px rgba(0, 0, 0, 0.14)) drop-shadow(0px 0px 2px rgba(0, 0, 0, 0.12))"},{targets:this.renderRoot.querySelector(".feed-indicator"),fill:i?"#FFFFFF":"#212121",color:i?"#FFFFFF":"#212121"},{targets:this.renderRoot.querySelectorAll(".site-name"),color:i?"#FFFFFF":"#212121"}]).run();break;case p.SITES:t({duration:200}).add([{targets:[this.renderRoot.querySelector(".search-bar"),this.renderRoot.querySelector(".ms-logo")],transform:i?"translateY(0)":"translateY(40px)"},{targets:this.renderRoot.querySelector(".sites-list"),opacity:i?1:0}]).run();break;case p.FEEDS:t({duration:200}).add({targets:this.renderRoot.querySelector(".feed-indicator"),opacity:i?1:0}).run()}}render(){return r`
    <div aria-hidden="true" class="page-number-with-icon-container" tabindex="0">
      ${this.renderIcon()}
      <div aria-hidden="true" class="page-number-with-icon">${this.pageNumber}</div>
    </div>
      <div aria-hidden="true" class="title" role="heading" aria-level="1" tabindex="0">${e.text(["fre_customize_title"])}</div>
      ${o(Object.values(p),(e=>e),(t=>r`
      <edge-accessible-switch class="setting-item" aria-checked=${this.setting[t]?"true":"false"}
        aria-label=${e.text(["fre_customize_item_"+t])} @click=${()=>this.onSettingChange(t,!this.setting[t])}>
        <div class="setting-name">${e.text(["fre_customize_item_"+t])}</div>
        <edge-switch .checked=${this.setting[t]} .onChange=${e=>this.onSettingChange(t,e)} aria-checked=${this.setting[t]?"true":"false"}></edge-switch>
      </edge-accessible-switch>
      `))}
      ${this.renderPhone()}
      ${this.renderButtons()}
    `}renderIcon(){return r`
      <picture aria-hidden="true">
        <source srcset="./resources/customize-icon-dark.png" media="(prefers-color-scheme: dark)" />
        <img class="page-icon" src="./resources/customize-icon.png" aria-hidden="true"/>
      </picture>
    `}renderPhone(){return l(r`
      <div class="phone">
        <img class="phone-bg" src="./resources/wallpaper_2.jpg" />
        ${d()}
        ${this.renderSearch()}
        ${this.renderSites()}
        ${this.feedsAndMore()}
        ${a(this.setting[p.IMAGE]?"#FFFFFF":"#141414")}
      </div>
    `,{callback:e=>{const t=e.children[0],i=.8*e.offsetWidth/t.offsetWidth,r=.8*e.offsetHeight/t.offsetHeight,s=Math.round(10*Math.min(i,r))/10;t.style.transform=`translate(-50%, -50%) scale(${s})`,t.style.visibility=s<.5?"hidden":"unset"}})}renderButtons(){const t=(t,i)=>r`
      <dewey-button class="next" size=${t} type=${i} @click=${this.onClickNext}>
        ${e.text(["common_next"])}
      </dewey-button>
    `,i=(t,i)=>r`
      <dewey-button class="not-now" size=${t} type=${i} @click=${()=>this.onNext(!0)}>
        ${e.text(["common_not_now"])}
      </dewey-button>
    `;return r`
      <div class="button-portrait">
        ${t("large","accent")}
        ${i("medium","subtle")}
      </div>
      <div class="button-landscape">
        ${i("medium","outline-accent")}
        ${t("medium","accent")}
      </div>
    `}renderSearch(){return r`
    <div class="search-bar">
      ${c("transparent","white","#141414")}
      <div class="search-text">
        Search or enter web address
      </div>
    </div>
    `}renderSites(){return r`
    <div class="sites-list">
      ${o(["Linkedin","Bing","Outlook","Xbox","Add"],(e=>e),((e,t)=>r`
      <div class="site-item">
        <img class="site-icon" src=${`./resources/sites-icon-${t+1}.png`} />
        <div class="site-name" class="">${e}</div>
      </div>
      `))}
    </div>
    `}feedsAndMore(){return r`
      <div class="feed-indicator">
        <svg width="5" height="3" viewBox="0 0 5 3" xmlns="http://www.w3.org/2000/svg">
          <path
            d="M4.2648 0.44669C4.36822 0.555136 4.36388 0.726828 4.2554 0.830139L2.35695 2.63865C2.25209 2.73842 2.08755 2.73842 1.98269 2.63865L0.084248 0.830139C-0.0242345 0.726828 -0.0285741 0.555136 0.0748459 0.44669C0.178266 0.338244 0.349667 0.334085 0.45815 0.43736L2.16964 2.06771L3.8815 0.43736C3.98998 0.334085 4.16138 0.338244 4.2648 0.44669Z" />
        </svg>
        <div>News and more</div>
      </div>
    `}});