// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"../common/dewey/dewey-button.js";import t from"../common/i18n.js";import{css as e,html as r}from"../common/lit.js";import{sendMessage as i}from"../common/message.js";import{commonCss as n,FREBaseElement as o,gradientLabel as a,scaleContainer as s}from"./edge-configurable-upsell-common.js";customElements.define("edge-configurable-upsell-demo",class extends o{static get properties(){return{isMsaSignedIn:{type:Boolean}}}static get styles(){return e`
    ${n}
    .new-feature-label-container {
      font-size: 13rem;
      font-weight: 400;
    }
    .title-container {
      display: flex;
      align-self: flex-start;
      margin-left: 32px;
      margin-right: 32px;
      font-size: 26rem;
      line-height: 31rem;
      font-weight: 700;
      color: var(--text-primary);
      text-align: start;
    }
    .image-container {
      display: inline-flex;
      justify-content: center;
      align-items: center;
      height: 700px;
      width: 750px;
    }
    .image-container img {
      transform: translateZ(0);
    }
    .subtitle-container {
      margin-bottom: 46px;
    }
    .subtitle-container-top {
      display: flex;
      justify-content: center;
      margin-bottom: 12px;
    }
    .copilot-icon {
      width: 24px;
      height: 24px;
      margin-right: 4px;
    }
    .copilot-text {
      color: var(--foreground-solid-colors-neutral-foreground-1, #242424);
      text-align: center;
      font-size: 22rem;
      font-style: normal;
      font-weight: 600;
    }
    .subtitle-container-bottom {
      color: var(--text-light-secondary, #6E6E6E);
      text-align: center;
      font-size: 13rem;
      font-style: normal;
      font-weight: 500;
      letter-spacing: -0.078rem;
    }
    .button-portrait {
      display: flex;
      flex-direction: column;
      align-items: center;
      align-self: stretch;
      padding: 0 32px;
    }
    .button-portrait .primary {
      width: 100%;
    }
    .button-portrait .secondary {
      margin-top: 16px;
    }
    .button-landscape {
      display: none;
      align-items: center;
      box-sizing: border-box;
      padding: 12px 32px;
      align-self: stretch;
      border-top: 0.5px solid var(--divider-primary);
    }
    .button-landscape .primary {
      margin-inline-start: 26px;
    }
    .button-landscape > * {
      flex: 1;
    }
    @media (prefers-color-scheme: dark) {
      :host {
        background-color: var(--surfaces-primary);
      }
      .title-container{
        color: var(--text-dark-primary, #E1E1E1);
      }
      .copilot-text {
        color: var(--text-dark-primary, #E1E1E1);
      }
      .subtitle-container-bottom {
        color: var(--text-dark-secondary, #919191);
      }
    }
    @media (orientation: landscape) {
      .title-container {
        margin-bottom: 16px;
      }
      .subtitle-container {
        margin-bottom: 10px;
      }
      .copilot-icon {
        width: 18px;
        height: 18px;
        margin-right: 3px;
      }
      .copilot-text {
        font-size: 16.5rem;
      }
      .subtitle-container-bottom {
        color: var(--text-light-secondary, #6E6E6E);
        text-align: center;
        font-size: 13rem;
        font-style: normal;
        font-weight: 500;
        letter-spacing: -0.078rem;
      }
      .button-landscape {
        display: flex;
      }
      .button-portrait {
        display: none;
      }
    }
    `}primaryAction(){i({action:"primaryButtonClicked",url:"microsoft-edge-x://action/copilot?query=hello"})}notNow(){i({action:"secondaryButtonClicked"})}renderLabel(){return r`
      <div class="new-feature-label-container page-number-with-icon-container" role="text">
        ${a("New Feature")}
      </div>
    `}renderTitle(){return r`
      <div class="title-container title" role="heading" aria-level="1">
        Demo Title
      </div>
    `}renderImageExamples(){return r`
      <div class="image-container">
        <picture>
          <source srcset="./resources/ending-phone-dark.png" media="(prefers-color-scheme: dark)" />
          <img src="./resources/ending-phone.png" aria-hidden="true"/>
        </picture>
      </div>
    `}renderSubtitle(){return r`
      <div class="subtitle-container">
        <div class="subtitle-container-top">
          <div class="copilot-text">Demo SubTitle</div>
        </div>
        <div class="subtitle-container-bottom">
          Demo Text
        </div>
      </div>
    `}renderContainer(){return s(r`
      ${this.renderImageExamples()}
    `,{callback:t=>{const e=t.children[0],r=t.offsetWidth/e.offsetWidth,i=t.offsetHeight/e.offsetHeight,n=Math.min(10*Math.min(r,i)/10,1);e.style.transform=`translate(-50%, -50%) scale(${n})`}})}renderButtons(){const e=(t,e)=>r`
      <dewey-button class="primary" size=${t} type=${e} @click=${this.primaryAction}>
        Primary Button
      </dewey-button>
    `,i=(e,i)=>r`
      <dewey-button class="secondary" size=${e} type=${i} @click=${this.notNow}>
        ${t.text(["common_not_now"])}
      </dewey-button>
    `;return r`
      <div class="button-portrait">
        ${e("large","accent")}
        ${i("medium","subtle")}
      </div>
      <div class="button-landscape">
        ${i("medium","outline-accent")}
        ${e("medium","accent")}
      </div>
    `}render(){return r`
    ${this.renderLabel()}
    ${this.renderTitle()}
    ${this.renderContainer()}
    ${this.renderSubtitle()}
    ${this.renderButtons()}
    `}});