// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{html as e,css as r,LitElement as t,unsafeCSS as o}from"../../lit.js";import{MixinKeyEvent as i,MixinAttributes as s}from"../../controls/control-base.js";import{getOsType as d}from"../../environment.js";customElements.define("dewey-checkbox",s(i(class extends t{static get properties(){return{checked:{type:Boolean,reflect:!0},disabled:{type:Boolean,reflect:!0}}}get isIOS(){return"iOS"===d()}static get styles(){const e="iOS"===d()?"12px":"3px";return r`
    :host {
      position: relative;
      display: inline-block;
      width: 24px;
      height: 24px;
      -webkit-tap-highlight-color: transparent;
    }
    
    .bg {
      position: absolute;
      width: 24px;
      height: 24px;
      border-radius: ${o(e)};
      border-width: 1.5px;
      border-style: solid;
      border-color: var(-color-neutral-stroke-accessible);
      box-sizing: border-box;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      margin: auto;
      transition: all 100ms;
    }

    svg {
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      margin: auto;
      transition: all 100ms;
      opacity: 0;
    
    }  
    
    :host([checked]) .bg {
      border-width: 0;
      background-color: var(--color-brand-foreground1);
    }
    
    :host([disabled]) .bg {
      border-color: var(--color-neutral-stroke-disabled-solid);
    }
    
    :host([disabled][checked]) .bg {
      border-width: 0;
      background-color: var(--color-brand-background-disabled);
    }
    
    :host([checked]) svg {
      opacity: 1;
    }
    
    @media (prefers-color-scheme: dark) {
      :host([disabled][checked]) .bg {
        background-color: var(--color-brand-background1-selected);
      }
    }
    `}firstUpdated(){this.setAttribute("aria-checked",this.checked?"true":"false")}connectedCallback(){super.connectedCallback(),this.addEventListener("click",this.onClick)}disconnectedCallback(){super.disconnectedCallback(),this.removeEventListener("click",this.onClick)}renderSvg(r,t,o){return e`
      <svg width="24" height="24" viewBox="0 0 24 24" fill="none" 
        xmlns="http://www.w3.org/2000/svg">
        <rect x="2" y="2" width="20" height="20" rx="${r}" fill="${t}"/>
        <path d="M15.765 9.20474C16.0661 9.48915 16.0797 9.96383 15.7953 
        10.265L11.5453 14.765C11.4061 14.9123 11.2133 14.997 11.0107 
        14.9999C10.8081 15.0028 10.6129 14.9236 10.4697 14.7803L8.21967 
        12.5303C7.92678 12.2374 7.92678 11.7626 8.21967 11.4697C8.51256 
        11.1768 8.98744 11.1768 9.28033 11.4697L10.9846 13.174L14.7047 
        9.23503C14.9891 8.9339 15.4638 8.92033 15.765 9.20474Z" 
        fill="white" fill-opacity="${o}"/>
      </svg>
    `}renderAndroidSvg(){return this.renderSvg("4",this.disabled&&this.checked?"var(--color-brand-foreground-disable)":"var(--color-brand-foreground1)",this.disabled&&this.checked?"0.4":"1")}renderIosSvg(){return this.renderSvg("12",this.disabled&&this.checked?"var(--color-brand-foreground-disable)":"var(--color-brand-foreground1)",this.disabled&&this.checked?"0.523":"1")}constructor(){super(),this.onClick=e=>{e.stopPropagation(),this.disabled||(this.checked=!this.checked,this.setAttribute("aria-checked",this.checked?"true":"false"),this.onChange&&this.onChange(this.checked))},this.checked=!1,this.disabled=!1}render(){return e`
      <div class="bg"></div>
      ${this.checked?this.isIOS?this.renderIosSvg():this.renderAndroidSvg():""}
    `}}),{role:"checkbox"}));