// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{html as t,css as e,LitElement as i,repeat as o,when as n}from"../lit.js";import"./edge-switch.js";import"./control-base.js";function s(t,e,i){const o={x:0,y:0};return t.startsWith("top")?o.y=e.top-i.height-2:t.startsWith("bottom")&&(o.y=e.bottom+2),t.endsWith("Left")?o.x=e.left:t.endsWith("Right")?o.x=e.right-i.width:"top"!==t&&"bottom"!==t||(o.x=e.left+(e.width-i.width)/2),"left"!==t&&"right"!==t||(t.startsWith("left")?o.x=e.left-i.width:t.startsWith("right")&&(o.x=e.right),o.y=e.top+(e.height-i.height)/2),{contentOffset:o}}function r(t,e){const i=Math.min(t.right,e.right)-Math.max(t.x,e.x),o=Math.min(t.bottom,e.bottom)-Math.max(t.y,e.y);return Math.max(i,0)*Math.max(o,0)}export class EdgePopupMenu extends i{constructor(){super(...arguments),this.onClickMask=()=>{this.props.closable&&this.clear()},this.onClickAction=t=>{this.clear(),t(!1)},this.onClickIcon=t=>{this.clear(),t()},this.onKeyUp=(t,e)=>{"Enter"===t.key&&this.onClickAction(e)}}static get styles(){return e`
      :host {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        z-index: var(--layer-popups);
      }
      .mask {
        position: absolute;
        width: 100%;
        height: 100%;
      }
      .content {
        position: absolute;
        background: var(--surfaces-primary);
        border-radius: 8px;
        display: flex;
        flex-direction: column;
        box-sizing: border-box;
        box-shadow: 0px 8px 16px 0px rgba(0, 0, 0, 0.14);
      }
      .list {
        display: flex;
        align-items: center;
        flex-direction: column;
        padding: 0 12px 0 12px;
        width: 216px;
      }
      .list-item {
        width: 100%;
        height: 48px;
        display: flex;
        flex-direction: row;
        align-items: center;
        justify-content: space-between;
      }
      .title {
        display: flex;
        align-items: center;
        font-size: 16rem;
        line-height: 24rem;
        font-weight: 400;
        color: var(--text-primary);
      }
      .title-icon {
        margin-left: 4px;
        display: flex;
      }
      .title-icon {
        margin-left: 4px;
      }
      .warning {
        width: 240px;
        display: flex;
        flex-direction: row;
        align-items: center;
        margin-top: 12px;
        padding-top: 16px;
        padding-bottom: 16px;
        background: var(--color-shared-red-background1);
      }
      .warning-title {
        display: flex;
        align-items: center;
        font-size: 12rem;
        line-height: 16rem;
        font-weight: 400;
        color: var(--color-shared-red-foreground1);
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: normal;
        max-height: calc(16rem * 2);
        margin-right: 16px;
        margin-left: 8px;
      }
      .waring-icon {
        width: 16px;
        height: 16px;
        margin-left: 12px;
      }

      @media (prefers-color-scheme: dark) {
        .content {
          background: var(--surfaces-quaternary);
        }
      }
    `}static get properties(){return{maskStyle:{type:String},props:{type:Object}}}firstUpdated(){this.updateContent(),setTimeout((()=>{const t=this.shadowRoot?.querySelectorAll(".list-item")[0];t&&t.focus()}),100)}async updateContent(){await this.updateComplete;const e=this.shadowRoot?.querySelector(".content"),i=document?.querySelector("body");this.ensureContentVisible(e);const{target:o,placement:n,menuOffset:a,zIndex:c}=this.props;c&&(this.style.zIndex=`${c}`),this.resizeObserver&&(this.resizeObserver.disconnect(),this.resizeObserver=void 0);const d=new ResizeObserver((()=>{this.ensureContentVisible(e);const c=o.getBoundingClientRect(),d=document.body.getBoundingClientRect(),l=e.getBoundingClientRect();let h=0,p={x:0,y:0};const g=function(t,e,i){const o=new Set;return t?(o.add(t),o):(e.left+e.width/2<i.width/2?(o.add("right"),e.top+e.height/2<i.height/2?(o.add("bottom"),o.add("bottomLeft")):(o.add("top"),o.add("topLeft"))):(o.add("left"),e.top+e.height/2<i.height/2?(o.add("bottom"),o.add("bottomRight")):(o.add("top"),o.add("topRight"))),o)}(n,c,d);for(const t of g){const e=s(t,c,l),i=r(d,new DOMRect(e.contentOffset.x,e.contentOffset.y,l.width,l.height));if(i>h&&(h=i,p=e.contentOffset),i===l.width*l.height)break}let m=0,u=0;a&&(a[0]||a[1])&&(a[0]&&(m=a[0]),a[1]&&(u=a[1]));let x=0;const f=i.clientHeight,b=e.clientHeight,w=p.y+u+window.scrollY+b;x=f<w?w:f;const y=t`
        <style>
          :host {
            height: ${x}px;
          }
          .content {
            left: ${p.x+m}px;
            top: ${p.y+u+window.scrollY}px;
          }
        </style>
      `;this.maskStyle=y}));d.observe(this),d.observe(o),d.observe(e),this.resizeObserver=d,this.addEventListener("click",this.onClickMask)}ensureContentVisible(t){this.props.keepInScreen&&setTimeout((()=>{const e=t.getBoundingClientRect();let i=0;e.bottom?i=e.bottom-window.innerHeight:e.top<0&&(i=e.top),i>0&&window.scrollBy({top:i,behavior:"smooth"})}),100)}clear(){this.remove(),this.props.onCancel?.(),this.resizeObserver&&(this.resizeObserver.disconnect(),this.resizeObserver=void 0)}render(){const{actions:e,warning:i}=this.props;return t`
      <div class="content" role="dialog" tabindex="0" aria-modal="true" @click=${t=>t.stopPropagation()}>
        ${n(!!i,(()=>t`
          <div class="warning">
            <img class="waring-icon" aria-hidden="true" src=${i?.icon}/>
            <div class="warning-title">${i?.title}</div>
          </div>
          `))}
        <div class="list">
          ${o(e,(t=>t.action),(({action:e,onAction:i,onIcon:o})=>t`
            <div class="list-item" role="${"switch"===e.type?"":"button"}" aria-label="${e.name}" tabindex="0" @keyup="${t=>this.onKeyUp(t,i)}" @click=${"switch"===e.type?void 0:()=>this.onClickAction(i)}>
              <div class="title" aria-hidden="true">
                <div class="title-name"> ${e.name}</div>
                <div class="title-icon" @click=${()=>this.onClickIcon(o)}>
                  ${n(!!e.icon,(()=>t`
                    <img class="popup-icon" aria-hidden="true" src=${e.icon}>
                  `))}
                </div>
              </div>
              ${n("switch"===e.type,(()=>t`
                <edge-switch .checked=${e.payload?.state} .onChange=${t=>i(t)}></edge-switch>
              `))}
            </div>
          `))}
        </div>
      </div>
      ${this.maskStyle}
    `}}customElements.define("edge-popupmenu",EdgePopupMenu);export function showPopupMenu(t){const e=document.createElement("edge-popupmenu");return e.props=t,document.body.appendChild(e),{dismiss:()=>{e.remove()},update:t=>{e.props=t,e.updateContent()}}}