// Copyright (C) Microsoft Corporation. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{LitElement as i,css as a,html as e}from"../lit.js";customElements.define("edge-loading-skeleton",class extends i{static get styles(){return a`
      .container {
        width: 100%;
        display: flex;
        flex-direction: row;
      }
      .icon {
        width: 32px;
        height: 32px;
        flex: 1;
        border-radius: 2px;
        backgroud: var(--surfaces-quaternary);
      }
      .content {
        display: flex;
        flex-direction: column;
        margin-left: 16px;
      }
      .title {
        width: 120px;
        height: 24px;
        border-radius: 2px;
        backgroud: var(--surfaces-quaternary);
      }
      .paragraph {
        width: 228px;
        height: 12px;
        border-radius: 2px;
        margin-top: 12px;
        backgroud: var(--surfaces-quaternary);
      }
      .shimmer {
        background: var(--shimmer-background);
        background-image: var(--shimmer-background-gradient);
        background-repeat: no-repeat;
        background-size: 800px 104px;

        animation-duration: 1s;
        animation-fill-mode: forwards;
        animation-iteration-count: infinite;
        animation-name: placeholderShimmer;
        animation-timing-function: linear;

        -webkit-animation-duration: 1s;
        -webkit-animation-fill-mode: forwards;
        -webkit-animation-iteration-count: infinite;
        -webkit-animation-name: placeholderShimmer;
        -webkit-animation-timing-function: linear;
      }

      @keyframes placeholderShimmer {
        0% {
          background-position: right;
        }

        100% {
          background-position: left;
        }
      }

      @-webkit-keyframes placeholderShimmer {
        0% {
          background-position: right;
        }

        100% {
          background-position: left;
        }
      }
    `}render(){return e`
      <div class="container">
        <div class="icon shimmer"></div>
        <div class="content">
          <div class="title shimmer"></div>
          <div class="paragraph shimmer"></div>
          <div class="paragraph shimmer"></div>
        </div>
      </div>
    `}});