varying highp vec2 textureCoordinate;
uniform sampler2D inputImageTexture1;
uniform sampler2D inputImageTexture2;
uniform sampler2D inputImageTexture3;
lowp float factor1 = 2.782;
lowp float factor2 = 1.131;
lowp float factor3 = 1.158;
lowp float factor4 = 2.901;
lowp float factor5 = 0.979;
lowp float factor6 = 0.639;
lowp float factor7 = 0.963;
lowp float blurOpacity = 0.460;
uniform lowp float smoothIntensity;

lowp vec3 ContrastSaturationBrightness(lowp vec3 color, lowp float brt, lowp float sat, lowp float con)
{
    const lowp vec3 LumCoeff = vec3(0.2125, 0.7154, 0.0721);
    lowp vec3 AvgLumin = vec3(0.5);
    lowp vec3 brtColor = color * brt;
    lowp vec3 intensity = vec3(dot(brtColor, LumCoeff));
    lowp vec3 satColor = mix(intensity, brtColor, sat);
    lowp vec3 conColor = mix(AvgLumin, satColor, con);
    return conColor;
}

void main(void)
{
    lowp vec4 inputColor = texture2D(inputImageTexture1, textureCoordinate);
    if(smoothIntensity < 0.01){
        gl_FragColor = vec4(inputColor.rgb, 1.0);
        return;
    }
    lowp float skinProbility = texture2D(inputImageTexture3, textureCoordinate).r*blurOpacity;
    lowp vec4 blurColor = texture2D(inputImageTexture2, textureCoordinate);
    lowp float cDist = distance(vec3(0.0), max(blurColor.rgb - inputColor.rgb, 0.0)) * factor1;
    lowp float dDist = distance(vec3(0.0), max(inputColor.rgb - blurColor.rgb, 0.0)) * factor4;
    lowp vec3 brightColor = ContrastSaturationBrightness(inputColor.rgb, factor2, 1.0, factor3);
    lowp vec3 mix11Color = mix(inputColor.rgb, brightColor.rgb, cDist);
    lowp vec3 darkColor = ContrastSaturationBrightness(inputColor.rgb, factor5, 1.0, factor6);
    lowp vec3 mix115Color = mix(mix11Color.rgb, darkColor.rgb, dDist);
    lowp vec3 mix116Color = mix(inputColor.rgb, mix115Color.rgb, factor7);
    lowp vec3 mix12Color = mix(mix116Color.rgb, blurColor.rgb, skinProbility);
    lowp vec3 smoothColor = mix(inputColor.rgb, mix12Color.rgb, smoothIntensity);
    gl_FragColor = vec4(smoothColor, 1.0);
}
