attribute vec3 attPosition;
attribute vec2 attUV;
const int GAUSSIAN_SAMPLES = 9;
uniform lowp float texelWidthOffset;
uniform lowp float texelHeightOffset;
varying lowp vec2 blurCoordinates[GAUSSIAN_SAMPLES];
void main()
{
    gl_Position = vec4(attPosition, 1.0);
    int multiplier = 0;
    vec2 blurStep;
    vec2 singleStepOffset = vec2(texelWidthOffset, texelHeightOffset);
    
    for (int i = 0; i < GAUSSIAN_SAMPLES; i++)
    {
        multiplier = (i - ((GAUSSIAN_SAMPLES - 1) / 2));
        blurStep = float(multiplier) * singleStepOffset;
        blurCoordinates[i] = attUV.xy + blurStep;
    }
}