uniform sampler2D inputImageTexture1;
uniform sampler2D inputImageTexture2;
const lowp int GAUSSIAN_SAMPLES = 9;
varying lowp vec2 blurCoordinates[GAUSSIAN_SAMPLES];
uniform lowp float distanceNormalizationFactor;
void main()
{
    lowp vec4 centralColor; lowp float gaussianWeightTotal;
    lowp vec4 sum;
    lowp vec4 sampleColor;
    lowp float distanceFromCentralColor;
    lowp float gaussianWeight;
    
    lowp vec2 textureCoordinate = blurCoordinates[4];
    lowp float isNotSkin = texture2D(inputImageTexture2, textureCoordinate).r;
   if (isNotSkin < 0.5)
   {
       gl_FragColor = texture2D(inputImageTexture1, textureCoordinate);
       return;
   }
    
    centralColor = texture2D(inputImageTexture1, blurCoordinates[4]);
    gaussianWeightTotal = 0.18; sum = centralColor * 0.18;
    
    sampleColor = texture2D(inputImageTexture1, blurCoordinates[0]);
    distanceFromCentralColor = min(distance(centralColor.g, sampleColor.g) * distanceNormalizationFactor, 1.0);
    gaussianWeight = 0.05 * (1.0 - distanceFromCentralColor);
    gaussianWeightTotal += gaussianWeight;
    sum += sampleColor * gaussianWeight;
    
    sampleColor = texture2D(inputImageTexture1, blurCoordinates[1]);
    distanceFromCentralColor = min(distance(centralColor.g, sampleColor.g) * distanceNormalizationFactor, 1.0);
    gaussianWeight = 0.09 * (1.0 - distanceFromCentralColor);
    gaussianWeightTotal += gaussianWeight; sum += sampleColor * gaussianWeight;
    
    sampleColor = texture2D(inputImageTexture1, blurCoordinates[2]);
    distanceFromCentralColor = min(distance(centralColor.g, sampleColor.g) * distanceNormalizationFactor, 1.0);
    gaussianWeight = 0.12 * (1.0 - distanceFromCentralColor);
    gaussianWeightTotal += gaussianWeight; sum += sampleColor * gaussianWeight;
    
    sampleColor = texture2D(inputImageTexture1, blurCoordinates[3]);
    distanceFromCentralColor = min(distance(centralColor.g, sampleColor.g) * distanceNormalizationFactor, 1.0);
    gaussianWeight = 0.15 * (1.0 - distanceFromCentralColor);
    gaussianWeightTotal += gaussianWeight; sum += sampleColor * gaussianWeight;
    
    sampleColor = texture2D(inputImageTexture1, blurCoordinates[5]);
    distanceFromCentralColor = min(distance(centralColor.g, sampleColor.g) * distanceNormalizationFactor, 1.0);
    gaussianWeight = 0.15 * (1.0 - distanceFromCentralColor);
    gaussianWeightTotal += gaussianWeight; sum += sampleColor * gaussianWeight;
    
    sampleColor = texture2D(inputImageTexture1, blurCoordinates[6]);
    distanceFromCentralColor = min(distance(centralColor.g, sampleColor.g) * distanceNormalizationFactor, 1.0);
    gaussianWeight = 0.12 * (1.0 - distanceFromCentralColor);
    gaussianWeightTotal += gaussianWeight; sum += sampleColor * gaussianWeight;
    
    sampleColor = texture2D(inputImageTexture1, blurCoordinates[7]);
    distanceFromCentralColor = min(distance(centralColor.g, sampleColor.g) * distanceNormalizationFactor, 1.0);
    gaussianWeight = 0.09 * (1.0 - distanceFromCentralColor);
    gaussianWeightTotal += gaussianWeight; sum += sampleColor * gaussianWeight;
    
    sampleColor = texture2D(inputImageTexture1, blurCoordinates[8]);
    distanceFromCentralColor = min(distance(centralColor.g, sampleColor.g) * distanceNormalizationFactor, 1.0);
    gaussianWeight = 0.05 * (1.0 - distanceFromCentralColor);
    gaussianWeightTotal += gaussianWeight; sum += sampleColor * gaussianWeight;
    
    gl_FragColor = sum / gaussianWeightTotal;
}