/**
 * WebView JSON error tracking injection
 * Monitors JSON.parse and JSON.stringify operations for errors
 * Reports errors through BrowserHost bridge
 */

if (this.isMissingJSON) {
    window.BrowserHost.emitJSONMissingMetric();
}

(function() {
    // Store the original methods
    var originalStringify = JSON.stringify;
    var originalParse = JSON.parse;

    // Override JSON.stringify
    JSON.stringify = function() {
        try {
            return originalStringify.apply(JSON, arguments);
        } catch (error) {
            window.BrowserHost.emitJSONErrorMetric();
            throw error;
        }
    };

    // Override JSON.parse
    JSON.parse = function() {
        try {
            return originalParse.apply(JSON, arguments);
        } catch (error) {
            window.BrowserHost.emitJSONErrorMetric();
            throw error;
        }
    };
}());