var body = document.querySelector('body');
var skin = '';
var defaultImage = 'mx5_assets_news_default_image';

function changeLoading(skinType){
     skin = skinType;
     defaultImage = defaultImage + skin;
     console.log('changeLoading'+'  defaultImage:'+defaultImage)
}

function markUpSubItem(itemData, index) {
    var subDiv = document.createElement('div');
    var banner ='<hr class="hr" width="100%">';
    var title='<div id = "correlation_title">'+itemData.title+'</div>';
    var img='<img class = "correlation_img" src="'+itemData.image+'">';
    var leftSide = '<div id = "correlation_left_side">'+ img +'</div>';
    var srcAndDate = '<div id = "correlation_src_and_date">'+
                            '<span style="float:left; bottom:0">' + itemData.src + '</span>' +
                            '<span style="float:right; bottom:0">' + itemData.time + '</span>'
                            +'</div>';
    var rightSide = '<div class="correlation_right_side" id="correlation_right_side">'
        + title + srcAndDate +
        '</div>';

    if (index > 0) {
        if (itemData.image == null) {
            subDiv.innerHTML = '<div><div style="min-height: 65px; overflow:hidden;">' + rightSide + "</div>"+banner+"</div>";
        } else {
            subDiv.innerHTML = '<div><div id = "correlation_wrapper">' + leftSide + rightSide + "</div>"+banner+"</div>";
        }

    } else {
        if (itemData.image == null) {
            subDiv.innerHTML = "<div>"+banner+ '<div style="min-height: 65px; overflow:hidden;">' + rightSide + "</div>"+banner+"</div>";
        } else {
            subDiv.innerHTML = "<div>"+banner+ '<div id = "correlation_wrapper">'+ leftSide + rightSide + "</div>"+banner+"</div>";
        }
    }

    var toJava = JSON.stringify(itemData)
    subDiv.addEventListener('click', function (event) {
        rssRead.onClick(toJava);
    });
    return subDiv;
}

function addData() {
    console.log("addData");

    document.querySelector('#content').innerHTML = rssRead.getContent();
    document.querySelector('#title').innerHTML = rssRead.getTitle();
    document.querySelector('#time').innerHTML = rssRead.getTime();
    document.querySelector('#source').innerHTML = rssRead.getSource();
    correlationNode = document.querySelector('#correlation');
    correlationHeader = document.querySelector('#correlationHeader');
    var relatedData = rssRead.getRelatedNewsData();
    var items = JSON.parse(relatedData);
    if (items.length == 0) {
        correlationHeader.style.display = 'none';
    } else {
        correlationHeader.innerHTML = rssRead.getCorrelationHeader();
        console.log("correlationHeader:"+correlationHeader.innerHTML);

        for (var i = 0; i < items.length; ++i) {
            var itemData = items[i];
            var subDiv = markUpSubItem(itemData, i);

            subDiv.onmouseover = function() {
                this.style.backgroundColor = 'rgb(' + 211 + ',' + 211 + ',' + 211 + ')';
            };

            subDiv.onmouseout = function() {
              this.style.backgroundColor = 'transparent';
            };

            correlationNode.appendChild(subDiv);
        }
    }

    addDefaultImage();

    document.addEventListener('click', function(e) {
        if (e.target.nodeName === "IMG" && e.target.className !== "correlation_img"){
        	if(e.target.attributes['data-src']){
	            rssRead.loadImage(e.target.attributes['data-src'].nodeValue, true,e.target.attributes['index'].nodeValue);
        	}else if(!e.target.attributes['data-src'] && e.target.attributes['src']){
	            rssRead.openImageBrowser(e.target.attributes['src'].nodeValue);
        	}
	        e.preventDefault();
        }
    });
}

function addDefaultImage() {
    var imgArr = document.querySelectorAll('img');
    for (var i = 0; i < imgArr.length; i++) {
        var img = imgArr[i];
        img.addEventListener('error', function (event) {
        this.onerror = null;
        this.src = defaultImage;
        if(skin !== "nightskin.skin"){
            img.setAttribute("src", "../images/news_default_img_icon.png");
        }
        console.log("addDefaultImage:"+defaultImage+"   skin:"+skin);
        });
    }
}

// a js interface for browser to change the image's src
function changeImageUrl(result) {
    var img = document.querySelector('img[data-src="' + result['data-src'] + '"]');
    if (img) {
        img.src = result.src;
        var del = result.deletedatasrc;
        if(del){
	        img.removeAttribute('data-src');
        }
    }
}

function zoomIn() {
    var body = document.querySelector('body');
    var fs = getComputedStyle(body).fontSize;
    var lh = getComputedStyle(body).lineHeight;
    if (fs && lh) {
        fs = parseInt(fs, 10);
        lh = parseInt(lh, 10);
        fs = fs >= 30 ? 30 : fs + 2;
        lh = lh >= 38 ? 38 : lh + 2;
    }
    body.style.fontSize =  fs + 'px';
    body.style.lineHeight =  lh + 'px';
    rssRead.notifyFontSizeChanged(fs);
}

function zoomOut() {
    var body = document.querySelector('body');
    var fs = getComputedStyle(body).fontSize;
    var lh = getComputedStyle(body).lineHeight;
    if (fs && lh) {
        fs = parseInt(fs, 10);
        lh = parseInt(lh, 10);
        fs = fs <= 16 ? 16 : fs - 2;
        lh = lh <= 24 ? 24 : lh - 2;
    }
    body.style.fontSize =  fs + 'px';
    body.style.lineHeight =  lh + 'px';
    rssRead.notifyFontSizeChanged(fs);
}

function setFontSize(fontSize) {
    var body = document.querySelector('body');
    body.style.fontSize = fontSize + 'px';
    body.style.lineHeight = '1.5em';
}