
VALUES = {
	LOGIN_BUTTON_REG: /登\s*录|.*submit.*|提\s*交|.*login.*/gi,
	NONE_LOGIN_BUTTON_REG: /password|username/gi,
	USER_NAME_CODES: "user|.*username|.*phone|.*email|.*account|用户名|手机号|邮s*箱|帐s*号|账s*号|账户名",
	DOCUMENT_POSTION_NONE: 1 << 0,
	DOCUMENT_POSTION_AFTER: 1 << 1,
	DOCUMENT_POSTION_BEFORE: 1 << 2,
	DOCUMENT_POSTION_INSIDE: 1 << 3,
	DOCUMENT_POSTION_OUTSIDE: 1 << 4,
	DOCUMENT_POSTION_EQUAL: 1 << 5
};
var formInput = findUserNameAndPasswordInput();
var frameNum = window.frames.length;
function findUserNameAndPasswordInput() {
	var info = catchForm(window.document);
	if (info == null) {
		try {
			var frameNodes = window.document.getElementsByTagName("iframe");
			if (frameNodes.length > 0) {
				for (var i = 0; i < frameNodes.length; ++i) {
					info = catchForm(frameNodes[i].contentWindow.document);
					if (info == null) {
						hookOtherLogin(frameNodes[i].contentWindow.document)
					}
				}
			}
		} catch(e) {
			console.log(e.message)
		}
	}
	if (info == null) {
		hookOtherLogin(document)
	}
	return info
}
function catchForm(document) {
	var checkAndFillPhoneNumber = true;
	var inputList = document.getElementsByTagName("input");
	if (inputList === undefined) {} else {
		console.log("catchFrom num:" + inputList.length)
	}
	var form;
	var usernameInput;
	var usernameIdx = -1;
	var passwordInput;
	var passwordIdx = -1;
	var verifycodeInput;
	var verifycodeIdx = -1;
	var formJson;
	var passwordInputCount = 0;
	var usernameSignatureCodes = VALUES.USER_NAME_CODES;
	for (var i = 0; i < inputList.length; ++i) {
		if (inputList[i].type == "password" && !isHidden(inputList[i])) {
			passwordIdx = i;
			passwordInput = inputList[i]; ++passwordInputCount;
			form = inputList[i].form;
			break
		}
	}
	if (passwordIdx <= 0) {
		if (checkAndFillPhoneNumber) {
			usernameInput = doCheckAndFillPhoneNumber()
		}
		return
	} else {
		if (passwordIdx == 1) {
			usernameIdx = 0;
			usernameInput = inputList[0]
		} else {
			for (var i = passwordIdx - 1; i >= 0; --i) {
				if (maybeUserName(inputList[i], form, usernameSignatureCodes)) {
					usernameIdx = i;
					usernameInput = inputList[i];
					break
				}
			}
		}
	}
	for (var i = passwordIdx + 1; i < inputList.length; ++i) {
		if (maybeVerifyCode(inputList[i])) {
			verifycodeIdx = i;
			verifycodeInput = inputList[i]
		}
	}
	if (usernameInput && passwordInput && passwordInputCount == 1) {
		var info = {};
		info.usernameInput = usernameInput;
		info.passwordInput = passwordInput;
		info.doc = document;
		return info
	}
	return null
}
var existingForms = [];

var observer = new MutationObserver((mutations) => {

	for(var i = 0; i < mutations.length; i++) {
		var mutation = mutations[i];
		if (mutation.type === 'childList' && mutation.addedNodes.length > 0) {
			for(var j = 0; j < mutation.addedNodes.length; j++) {
				var node = mutation.addedNodes[j];
				if(node.nodeName.toLowerCase() === 'form') {
					if(!existingForms.includes(node)) {
						existingForms.push(node);
					}
					mx_login_hook();

				} else if(typeof node.querySelectorAll !== 'undefined') {
					var forms = node.querySelectorAll('form');
					if(forms && forms.length > 0) {
						for(var k = 0; k < forms.length; k++) {
							var form = forms[k];
							if(existingForms.includes(form)){
								continue;
							}
							existingForms.push(form);
							mx_login_hook();
						}
					} else {
						formInput = findUserNameAndPasswordInput();
                         mx_login_hook();

					}
				}
			}
		}
	}
});

observer.observe(document, {
    subtree: true,
    childList: true,
    attributes: true,
});

function mx_login_hook() {
	var info = formInput;
	if (!info) {
		console.log("has not username and password");
		return
	}
	var parent = null;
	var sibling = null;
	var nextSibling = null;
	if (info.passwordInput.parentNode) {
		parent = info.passwordInput.parentNode
	}
	var forms = info.doc.getElementsByTagName("form");
	if (forms && forms.length > 1) {
		for (var i = 0; i < forms.length; ++i) {
			var form = forms[i];
			if (form.listened) {
			} else {
				form.listened = true;
				form.addEventListener("submit",
				function(e) {
					feedbackForm(info)
				},
				false);
			}
			hookLogin(info, form)
		}
	} else {
		hookLogin(info, info.doc)
	}
}
function hookLogin(info, rootNode) {
	var loginBtns = [];
	var as = rootNode.getElementsByTagName("a");
	hookLoginAction(as, loginBtns, info.passwordInput, rootNode);
	var buttons = rootNode.getElementsByTagName("button");
	hookLoginAction(buttons, loginBtns, info.passwordInput, rootNode);
	var inputs = rootNode.getElementsByTagName("input");
	hookLoginAction(inputs, loginBtns, info.passwordInput, rootNode);
	if (loginBtns.length > 0) {
		for (var i = 0; i < loginBtns.length; ++i) {
			if (loginBtns[i].listened) {
			} else {
				loginBtns[i].listened = true;
				loginBtns[i].addEventListener("click",
				function(e) {
					feedbackForm(info)
				},
				false)
			}
		}
		
	}
}
function hookLoginAction(nodes, loginBtns, passwordNode, rootNode) {
	if (!nodes) {
		return
	}
	for (var i = 0; i < nodes.length; ++i) {
		var node = nodes[i];
		if (passwordNode == null) {
			hookOtherLoginAction(node, loginBtns)
		} else {
			if (rootNode.tagName === "FORM") {
				hookLoginActionInForm(node, loginBtns, passwordNode)
			} else {
				hookLoginAction2(node, loginBtns, passwordNode)
			}
		}
	}
}
function hookLoginAction2(node, loginBtns, passwordNode) {
	if (!isTextBox(node) && node.hasAttribute && ((passwordNode.compareDocumentPosition(node)) & VALUES.DOCUMENT_POSTION_BEFORE)) {
		var id = strAttr(node, "id");
		var name = strAttr(node, "name");
		var value = strAttr(node, "value");
		var type = strAttr(node, "type");
		var className = strAttr(node, "class");
		var innerHTML = node.innerHTML ? node.innerHTML: "";
		if (loginButtonCheck(id) || loginButtonCheck(name) || loginButtonCheck(className) || loginButtonCheck(value) || loginButtonCheck(innerHTML)) {
			loginBtns.push(node)
		}
	}
}
function hookOtherLoginAction(node, loginBtns) {
	if (!isTextBox(node) && node.hasAttribute) {
		var value = strAttr(node, "value");
		var type = strAttr(node, "type");
		var innerHTML = node.innerHTML ? node.innerHTML: "";
		if (loginButtonType(type) || loginButtonCheck(value) || loginButtonCheck(innerHTML)) {
			loginBtns.push(node)
		}
	}
}
function hookLoginActionInForm(node, loginBtns, passwordNode) {
	if (!isTextBox(node) && node.hasAttribute && ((passwordNode.compareDocumentPosition(node)) & VALUES.DOCUMENT_POSTION_BEFORE)) {
		var value = strAttr(node, "value");
		var type = strAttr(node, "type");
		var innerHTML = node.innerHTML ? node.innerHTML: "";
		if (loginButtonType(type) || loginButtonCheck(value) || loginButtonCheck(innerHTML)) {
			loginBtns.push(node)
		}
	}
}
function feedbackForm(info) {
	var formData = {};
	formData.documentURI = window.document.documentURI;
	formData.inputs = [];
	var username = {};
	username.id = "username";
	username.name = "username";
	username.value = info.usernameInput.value;
	formData.inputs.push(username);
	var password = {};
	password.id = "password";
	password.name = "password";
	password.value = info.passwordInput.value;
	formData.inputs.push(password);
	var title = {};
	title.id = "title";
	title.name = "title";
	title.value = window.document.title;
	formData.inputs.push(title);
	var json = JSON.stringify(formData);
	if (window.mxautofill) {
		window.mxautofill.catchform(json)
	}
}


function mx_form_fill(username, password) {
	if (!window.mxautofill) {
		console.log("cannot find mxautofill")
	}
	var info = formInput;
	if (!info) {
		formInput = findUserNameAndPasswordInput();
		info = formInput
	}
	if (info) {
		 info.usernameInput.value = username;
		 info.usernameInput.dispatchEvent(new Event('input'));
		 info.passwordInput.value = password
		 info.passwordInput.dispatchEvent(new Event('input'));

	} else {
	}
}
function loginButtonCheck(name) {
    if (name.length > 50) {
        return false;
    }
    var b1 = name.search(VALUES.LOGIN_BUTTON_REG);
    var b2 = name.search(VALUES.NONE_LOGIN_BUTTON_REG);
	return b1 >= 0 && b2 < 0
}
function loginButtonType(type) {
	return type.search("submit") >= 0
}
function isTextBox(el) {
	if (el && !el.disabled && /password|text|email|tel|number|search|textarea/i.test(el.type)) {
		return true
	}
	return false
}
function isHidden(node) {
	if (node.nodeName == "BODY") {
		return false
	}
	return false;
	if (node.hidden || node.style.display == "none") {
		return true
	}
	if (node.parentNode) {
		return isHidden(node.parentNode)
	}
	return false
}
function maybeVerifyCode(node) {
	if (! (node.type == "text") || isHidden(node)) {
		return false
	}
	if (attrCheck(node, ["vcode", "verifycode"])) {
		return true
	}
	if (contentCheck(node, "验证码")) {
		return true
	}
	return false
}
function maybeUserName(node, form, usernameSignatureCodes) {
	if (form != null && !form.hasChildNodes(node)) {
		return false
	}
	if (!isTextBox(node) || isHidden(node)) {
		return false
	}
	if (attrCheck(node, usernameSignatureCodes)) {
		return true
	}
	if (contentCheck(node, usernameSignatureCodes)) {
		return true
	}
	return false
}
function contentCheck(node, regex) {
	regex = new RegExp(regex, "gi");
	if ((node.value && node.value.search(regex) >= 0) || (node.placeholder && node.placeholder.search(regex) >= 0)) {
		return true
	}
	return false
}
function attrCheck(node, bakArr) {
	for (var i = 0; i < bakArr.length; ++i) {
		if ((node.id && node.id.toLowerCase().search(bakArr[i]) >= 0) || (node.name && node.name.toLowerCase().search(bakArr[i]) >= 0)) {
			return true
		}
	}
	return false
}
function doCheckAndFillPhoneNumber() {
	var inputList = document.getElementsByTagName("input");
	for (var i = 0; i < inputList.length; ++i) {
		var node = inputList[i];
		if (!isHidden(node)) {
			if ((node.type == "tel" || node.type == "text" || node.type == "number") && (contentCheck(node, "手机号|(phones*number)"))) {
				return node
			}
		}
	}
}
function strAttr(node, attrName) {
	var nodeValue = node[attrName];
	if (typeof(nodeValue) == "string") {
		return nodeValue
	} else {
		nodeValue = node.getAttribute(attrName);
		if (typeof(nodeValue) == "string") {
			return nodeValue
		} else {
			return ""
		}
	}
}
function hasSubmitInForm(form) {
	var hasSubmit = false;
	for (var i = 0; i < form.length; i++) {
		var input = form[i];
		console.log(input.type);
		if (input.type == "submit" && !isHidden(input)) {
			hasSubmit = true;
			break
		}
	}
	return hasSubmit
}
function hookOtherLogin(rootNode) {
	var loginBtns = [];
	var buttons = rootNode.getElementsByTagName("button");
	hookLoginAction(buttons, loginBtns, null, rootNode);
	var inputs = rootNode.getElementsByTagName("input");
	hookLoginAction(inputs, loginBtns, null, rootNode);
	var spans = rootNode.getElementsByTagName("span");
	hookLoginAction(spans, loginBtns, null, rootNode);
	if (loginBtns.length > 0) {
		frameNum = window.frames.length;
		for (var i = 0; i < loginBtns.length; ++i) {
			console.log(loginBtns[i]);
			if (loginBtns[i].listened) {
			} else {
				loginBtns[i].listened = true;
				loginBtns[i].addEventListener("click",
				function(e) {
					if (frameNum !== window.frames.length) {
						var frameNodes = window.document.getElementsByTagName("iframe");
						for (var i = 0; i < frameNodes.length; ++i) {
							var frame = frameNodes[i];
							frame.onload = function() {
								formInput = findUserNameAndPasswordInput();
								mx_login_hook();
								if (window.mxautofill) {
									window.mxautofill.getUserAndPassword(document.location.href)
								}
							}
						}
					} else {
						formInput = findUserNameAndPasswordInput();
						mx_login_hook();
						if (window.mxautofill) {
							window.mxautofill.getUserAndPassword(document.location.href)
						}
					
					}
					frameNum = window.frames.length
				},
				false)
			}
		}
	}
};