
function connectWebViewJavascriptBridge(callback) {
    if (window.WebViewJavascriptBridge) {
        callback(WebViewJavascriptBridge)
    } else {
        document.addEventListener(
            'WebViewJavascriptBridgeReady'
            , function () {
                callback(WebViewJavascriptBridge)
            },
            false
        );
    }
}

(function () {
    window.maxthon.saveData = function(callback, module, key, content_data) {
        var json = {
            module: module, key: key, content_data: content_data
        };
        connectWebViewJavascriptBridge(function () {
            WebViewJavascriptBridge.callHandler(
                'callHandler',
                { "action": "saveData", "data": JSON.stringify(json) },
                function (responseData) {
                    callback(responseData);
                }
            );
        });
    };
    window.maxthon.readData = function(callback, module, key) {
        var json = {
            module: module, key: key
        };
        connectWebViewJavascriptBridge(function () {
            WebViewJavascriptBridge.callHandler(
                'callHandler',
                { "action": "readData", "data": JSON.stringify(json) },
                function (responseData) {
                    callback(responseData);
                }
            );
        });
    };
    window.maxthon.deleteData = function(callback, module, key) {
        var json = {
            module: module, key: key
        };
        connectWebViewJavascriptBridge(function () {
            WebViewJavascriptBridge.callHandler(
                'callHandler',
                { "action": "deleteData", "data": JSON.stringify(json) },
                function (responseData) {
                    callback(responseData);
                }
            );
        });
    };
    window.maxthon.getFileMd5 = function(callback, module, key) {
        var json = {
            module: module, key: key
        };
        connectWebViewJavascriptBridge(function () {
            WebViewJavascriptBridge.callHandler(
                'callHandler',
                { "action": "getFileMd5", "data": JSON.stringify(json) },
                function (responseData) {
                    callback(responseData);
                }
            );
        });
    };
    window.maxthon.getFileExists = function(callback, file) {
        var json = {
            file: file
        };
        connectWebViewJavascriptBridge(function () {
            WebViewJavascriptBridge.callHandler(
                'callHandler',
                { "action": "getFileExists", "data": JSON.stringify(json) },
                function (responseData) {
                    callback(responseData);
                }
            );
        });
    };
})();

