var timeoutId = setTimeout(function () {
	if (typeof jsController_call === "function") {
		clearTimeout(timeoutId);
		connectWebViewJavascriptBridge(function () {
			jsController_call({
				cmd: "browser_ready",
				param: {
					ver: window.maxthon.getVersionName(),
					pl: "android",
				},
			}).then(function (result) {
			    console.log("browser_ready_finish")
				window.maxthon.send(null, { event: "onBrowserReady", data: result });
			});
		});

	}
}, 2000);

window.maxthon.send = function (callback, json) {
	let fun = json["event"];
	if (!fun) {
		fun = json["cmd"];
	}
	if (typeof json == "object") {
		json = JSON.stringify(json);
	}
	//console.log("maxthon.send",json)
	//'browser_readconfig','open','get_account_info','set_pref','get_pref','newData','getConfig'
	if(
	    [
	    'getOldMeta','getOldData','readData','saveData','removeData',
	    'runPrepared','readCookie','writeCookie','browser_readconfig',
	    'open','get_account_info','set_pref','get_pref',
	    'newData','getConfig','getData',"fetch","onJsControllerRet"
	    ].includes(fun)&&window.maxthon.send2
	){
	    const ret = window.maxthon.send2(json)
	    if(callback) callback(ret)
	    return
	}
	//console.log("maxthon.send",json)
	connectWebViewJavascriptBridge(function () {
		WebViewJavascriptBridge.callHandler(
			"callHandler",
			{ action: fun, data: json,from:json["from"] },
			function (responseData) {
				if (typeof callback !== "undefined" && callback !== null) {
					callback(responseData);
				}
			}
		);
	});
};

if (typeof window.maxthon.Account == "undefined") {
	window.maxthon.Account = {};
}

window.maxthon.Account.send = window.maxthon.send;

//function getOldMeta(force) {
//	console.log("getOldMeta");
//
//	jsController_call({
//		from: "note",
//		cmd: "getOldMeta",
//		param: {
//			force: force,
//		},
//	}).then(function (result) {
//		window.maxthon.send(null, { event: "getOldMeta", data: result });
//	});
//}
//
//function getOldData(id, downIfMissing) {
//	console.log("getOldData");
//
//	jsController_call({
//		from: "note",
//		cmd: "getOldData",
//		param: {
//			id: id,
//			downIfMissing: downIfMissing,
//		},
//	}).then(function (result) {
//		window.maxthon.send(null, { event: "getOldData", data: result });
//	});
//}

function updateData(name, uid, version, data) {
	console.log("updateData");
	data = window.maxthon.decode(data);
	jsController_call({
		to: "mxsync",
		cmd: "updateData",
		param: {
			name: name,
			uid: uid,
			ver: version,
			data: data,
		},
	}).then(function (result) {
		if (result) {
			result["name"] = name;
			result["uid"] = uid;
		}
		window.maxthon.send(null, { event: "onUpdateData", data: result });
	});
}

function syncOnce(uid) {
	console.log("syncOnce");
	jsController_call({
		to: "mxsync",
		cmd: "syncOnce",
		param: {
			uid: uid,
			names: ["bookmarks", "fas", "pass"],
		},
	}).then(function (result) {
		if (result) {
			window.maxthon.send(null, { event: "onSyncOnce", data: result });
		}
	});
}

function loginEnd(uid) {
	jsController_call({
		to: "jsController",
		cmd: "login_end",
		param: {
			success: true,
			user_id: uid,
		},
	}).then(function (result) {
		if (result) {
			window.maxthon.send(null, { event: "onLoginEnd", data: result });
		}
	});
}
function callJsController({to,cmd,param,id}){
        jsController_call({
                to,
                cmd,
                param
            }).then(function (result) {
    		if (result) {
    			window.maxthon.send(null, { event: "onJsControllerRet", id,cmd,result });
    		}
    	});
}
function profileLoaded(uid) {
	jsController_call({
		to: "jsController",
		cmd: "profile_loaded",
		param: {
			success: true,
			user_id: uid,
		},
	}).then(function (result) {
		if (result) {
			window.maxthon.send(null, { event: "onProfileLoaded", data: result });
            console.log("send onProfileLoaded")
		}
	});
}

function userBalance() {
	jsController_call({
		to: "jsController",
		cmd: "user_balance",
		param: {
			asset: "all",
		},
	}).then(function (result) {
		if (result) {
			window.maxthon.send(null, { event: "onUserBalance", data: result });
		}
	});
}

function addRootNote(fileType, noteId, parentId, noteTitle, noteUrl, noteContent, targetClass) {
	jsController_call({
		to: "note",
		cmd: "addNote",
		param: {
			ft: fileType,
			id: noteId,
			pid: parentId,
			title: noteTitle,
			url: noteUrl,
			data: noteContent
		}
	}).then(function (results) {
		if (results) {
			results.target = targetClass;
			
			window.maxthon.send(null, { event: "onAddNote", data: results });
		}
	});
}

function addNote(fileType, parentId, noteTitle, noteUrl, noteContent, targetClass) {
	jsController_call({
		to: "note",
		cmd: "addNote",
		param: {
			ft: fileType,
			pid: parentId,
			title: noteTitle,
			url: noteUrl,
			data: noteContent
		}
	}).then(function (results) {
		if (results) {
			results.target = targetClass;

			window.maxthon.send(null, { event: "onAddNote", data: results });
		}
	});
}

function readNotes(noteIds) {
	jsController_call({
		to: "note",
		cmd: "readNotes",
		param: {
			ids: noteIds,
		}
	}).then(function (results) {
		if (results) {
			window.maxthon.send(null, { event: "onReadNotes", data: results });
		}
	});
}

function getNoteMeta(noteId) {
	jsController_call({
		to: "note",
		cmd: "getNoteMeta",
		param: {
			id: noteId,
		}
	}).then(function (results) {
		if (results) {
			window.maxthon.send(null, { event: "onGetNoteMeta", data: results });
		}
	});
}

function getNoteById(noteId, targetClass) {
	jsController_call({
		to: "note",
		cmd: "readNotes",
		param: {
			ids: [ noteId ],
		}
	}).then(function (results) {
		if (results) {
			results.target = targetClass;
			window.maxthon.send(null, { event: "onGetNoteById", data: results });
		}
	});
}

function getFolderById(parentId, targetClass) {
	jsController_call({
		to: "note",
		cmd: "readNotes",
		param: {
			ids: [ parentId ],
		}
	}).then(function (results) {
		if (results) {
			results.target = targetClass;

			window.maxthon.send(null, { event: "onGetFolderById", data: results });
		}
	});
}

function getInitialFolder(noteId, targetClass) {
	jsController_call({
		to: "note",
		cmd: "readNotes",
		param: {
			ids: [ noteId ],
		}
	}).then(function (results) {
		if (results) {
			results.target = targetClass;
			
			window.maxthon.send(null, { event: "onGetInitialFolder", data: results });
		}
	});
}

function getInitialParentFolder(parentId, targetClass) {
	jsController_call({
		to: "note",
		cmd: "readNotes",
		param: {
			ids: [ parentId ],
		}
	}).then(function (results) {
		if (results) {
			results.target = targetClass;
			
			window.maxthon.send(null, { event: "onGetInitialParentFolder", data: results });
		}
	});
}

function getFirstFolder(parentId, targetClass) {
	jsController_call({
		to: "note",
		cmd: "getNotesByFolder",
		param: {
			pid: parentId,
		}
	}).then(function (results) {
		if (results) {
			results.target = targetClass;

			window.maxthon.send(null, { event: "onGetFirstFolder", data: results });
		}
	});
}

function isNoteUpdated(noteId, modifiedDT) {
	jsController_call({
		to: "note",
		cmd: "isNoteUpdated",
		param: {
			id: noteId,
			mt: modifiedDT
		}
	}).then(function (results) {
		if (results) {
			window.maxthon.send(null, { event: "onIsNoteUpdated", data: results });
		}
	});
}

function saveNote(noteId, noteTitle, noteContent, noteSize, modifiedDT) {
	jsController_call({
		to: "note",
		cmd: "saveNote",
		param: {
			id: noteId,
			title: noteTitle,
			data: noteContent,
			ns: noteSize,
			mt: modifiedDT
		}
	}).then(function (results) {
		if (results) {
			window.maxthon.send(null, { event: "onSaveNote", data: results });
		}
	});
}

function updateTitle(noteId, noteTitle, targetClass) {
	jsController_call({
		to: "note",
		cmd: "updateTitle",
		param: {
			id: noteId,
			title: noteTitle
		}
	}).then(function (results) {
		if (results) {
			results.target = targetClass;
			window.maxthon.send(null, { event: "onUpdateTitle", data: results });
		}
	});
}

function updateUrl(noteId, noteUrl, targetClass) {
	jsController_call({
		to: "note",
		cmd: "updateUrl",
		param: {
			id: noteId,
			url: noteUrl
		}
	}).then(function (results) {
		if (results) {
			results.target = targetClass;
			window.maxthon.send(null, { event: "onUpdateUrl", data: results });
		}
	});
}

function getAllNotes(targetClass) {
	jsController_call({
		to: "note",
		cmd: "getAllNotes"
	}).then(function (results) {
		if (results) {
			results.target = targetClass;

			window.maxthon.send(null, { event: "onGetAllNotes", data: results });
		}
	});
}

function getRecentNotes(rowsLimit) {
	jsController_call({
		to: "note",
		cmd: "getEntriesByRecent",
		param: {
			limit: rowsLimit
		}
	}).then(function (results) {
		if (results) {
			window.maxthon.send(null, { event: "onGetRecentNotes", data: results });
		}
	});
}

function getTotalNotesCount(noteId, isInclSubFolders, targetClass) {
	jsController_call({
		to: "note",
		cmd: "getTotalNotesCount",
		param: {
			id: noteId,
			inclSubFolders: isInclSubFolders
		}
	}).then(function (results) {
		if (results) {
			results.target = targetClass;
			window.maxthon.send(null, { event: "onGetTotalNotesCount", data: results });
		}
	});
}

function getNotesByFolder(parentId) {
	jsController_call({
		to: "note",
		cmd: "getNotesByFolder",
		param: {
			pid: parentId
		}
	}).then(function (results) {
		if (results) {
			window.maxthon.send(null, { event: "onGetNotesByFolder", data: results });
		}
	});
}

function isNoteExists(noteId) {
	jsController_call({
		to: "note",
		cmd: "getNoteMeta",
		param: {
			id: noteId,
		}
	}).then(function (results) {
		if (results) {
			window.maxthon.send(null, { event: "onIsNoteExists", data: results });
		}
	});
}

function getRecentFolder() {
	jsController_call({
		to: "note",
		cmd: "getRecentNotes",
		param: {
			limit: 1
		}
	}).then(function (results) {
		if (results) {
			window.maxthon.send(null, { event: "onGetRecentFolder", data: results });
		}
	});
}

function getFolders(parentId, targetClass) {
	jsController_call({
		to: "note",
		cmd: "getNotesByFolder",
		param: {
			pid: parentId
		}
	}).then(function (results) {
		if (results) {
			results.target = targetClass;
			window.maxthon.send(null, { event: "onGetFolders", data: results });
		}
	});
}

function getSortedFolders(parentId, sortOption, depthLevel, filters, targetClass) {
	jsController_call({
		to: "note",
		cmd: "sortFolder",
		param: {
			pid: parentId,
			depth: depthLevel,
			sortOpt: sortOption,
			filter: filters
		}
	}).then(function (results) {
		if (results) {
			results.target = targetClass;

			window.maxthon.send(null, { event: "onGetSortedFolders", data: results });
		}
	});
}

function searchNotes(searchKeywords, targetClass) {
	jsController_call({
		to: "note",
		cmd: "searchNotes",
		param: {
			keywords: searchKeywords
		}
	}).then(function (results) {
		if (results) {
			results.target = targetClass;
			
			window.maxthon.send(null, { event: "onSearchNotes", data: results });
		}
	});
}

function setAsFavourite(noteIds, isFavourite) {
	jsController_call({
		to: "note",
		cmd: "setAsFavourite",
		param: {
			ids: noteIds,
			isFav: isFavourite
		}
	}).then(function (results) {
		if (results) {
			window.maxthon.send(null, { event: "onSetAsFavourite", data: results });
		}
	});
}

function getFavouriteNotes() {
	jsController_call({
		to: "note",
		cmd: "getFavouriteNotes",
		param: {
			ids: noteIds,
			isFav: isFavourite
		}
	}).then(function (results) {
		if (results) {
			window.maxthon.send(null, { event: "onGetFavouriteNotes", data: results });
		}
	});
}

function shareNotes(noteIds, isShareNote) {
	jsController_call({
		to: "note",
		cmd: "shareNotes",
		param: {
			ids: noteIds,
			isShare: isShareNote
		}
	}).then(function (results) {
		if (results) {
			window.maxthon.send(null, { event: "onShareNotes", data: results });
		}
	});
}

function getSharedNotes() {
	jsController_call({
		to: "note",
		cmd: "getSharedNotes",
		param: {
			ids: noteIds,
			isShare: isShareNote
		}
	}).then(function (results) {
		if (results) {
			window.maxthon.send(null, { event: "onGetShareNotes", data: results });
		}
	});
}

function getFolderNotePath(noteId) {
	jsController_call({
		to: "note",
		cmd: "getFolderNotePath",
		param: {
			id: noteId,
		}
	}).then(function (results) {
		if (results) {
			window.maxthon.send(null, { event: "onGetFolderNotePath", data: results });
		}
	});
}

function moveFolderNote(noteId, noteIds = null, parentId, sortOption = 0, customSort = -1, targetClass) {
	jsController_call({
		to: "note",
		cmd: "moveFolderNote",
		param: {
			id: noteId,
			ids: noteIds,
			pid: parentId,
			sortOpt: sortOption,
			eo: customSort
		}
	}).then(function (results) {
		if (results) {
			results.target = targetClass;
			window.maxthon.send(null, { event: "onMoveFolderNote", data: results });
		}
	});
}

function deleteFoldersNotes(noteIds, targetClass) {
	jsController_call({
		to: "note",
		cmd: "deleteFoldersNotes",
		param: {
			ids: noteIds
		}
	}).then(function (results) {
		if (results) {
			results.target = targetClass;

			window.maxthon.send(null, { event: "onDeleteFoldersNotes", data: results });
		}
	});
}

function getTrashBinItems() {
	jsController_call({
		to: "note",
		cmd: "sortFolder",
		param: {
			pid: 2,
			depth: 0,
			sortOpt: 0,
			filter: null
		}
	}).then(function (results) {
		if (results) {
			window.maxthon.send(null, { event: "onGetTrashBinItems", data: results });
		}
	});
}

function getTrashBinItems(targetClass) {
	jsController_call({
		to: "note",
		cmd: "sortFolder",
		param: {
			pid: 2,
			depth: 0,
			sortOpt: 0,
			filter: null
		}
	}).then(function (results) {
		if (results) {
			results.target = targetClass;
			
			window.maxthon.send(null, { event: "onGetTrashBinItems", data: results });
		}
	});
}

function getRestoreFolder(noteId, targetClass) {
	jsController_call({
		to: "note",
		cmd: "getRestoreFolder",
		param: {
			id: noteId
		}
	}).then(function (results) {
		if (results) {
			results.target = targetClass;
			window.maxthon.send(null, { event: "onGetRestoreFolder", data: results });
		}
	});
}

function restoreFolderNotes(noteIds, parentId, restoreOption, targetClass) {
	jsController_call({
		to: "note",
		cmd: "restoreNotes",
		param: {
			ids: noteIds,
			pidTo: parentId,
			restoreOpt: restoreOption
		}
	}).then(function (results) {
		if (results) {
			results.target = targetClass;
			window.maxthon.send(null, { event: "onRestoreFolderNotes", data: results });
		}
	});
}

function emptyTrash(noteIds, targetClass) {
	jsController_call({
		to: "note",
		cmd: "emptyTrash",
		param: {
			ids: noteIds
		}
	}).then(function (results) {
		if (results) {
			results.target = targetClass;
			window.maxthon.send(null, { event: "onEmptyTrash", data: results });
		}
	});
}

function getNews(session) {
	jsController_call({
		to: "news",
		cmd: "getNews",
		param: {
			'json': true,
			'session': session
		}
	}).then(function (results) {
		if (results) {
			window.maxthon.send(null, { event: "onGetNews", data: results });
		}
	});
}

function setNewsVisible(url) {
	jsController_call({
		to: "news",
		cmd: "setVisible",
		param: {
			'url': url
		}
	}).then(function (results) {
		if (results) {
			window.maxthon.send(null, { event: "onSetNewsVisible", data: results });
		}
	});
}

function testFunction(testValue) {
	console.log(testValue);
	return { value: testValue, code: 0 }
}