function completely(txtBox, config) {
    config = config || {};
    config.fontSize = config.fontSize || '15px';
    config.fontFamily = config.fontFamily || 'sans-serif';
    config.promptInnerHTML = config.promptInnerHTML || '';
    config.color = config.color || '#333';
    config.unmatchedColor = config.unmatchedColor || '#999999';
    config.backgroundColor = config.backgroundColor || '#fff';
    config.dropDownBorderColor = config.dropDownBorderColor || '#d0d0d0';
    config.dropDownZIndex = config.dropDownZIndex || '100';
    config.dropDownOnHoverBackgroundColor = config.dropDownOnHoverBackgroundColor || '#ddd';
    config.rowHeight = config.rowHeight || 40;
    config.marginLeft = config.marginLeft || 10;
    config.boardRadius = config.boardRadius || 3;

    var txtInput = txtBox;
    txtInput.autocomplete = 'off';
    var inputRect = txtInput.getBoundingClientRect();
    var dropDownLeft = inputRect.left;
    var dropDownTop = inputRect.bottom;
    var rootContainer = txtInput.parentNode;

    var dropDown = document.createElement('div');
    dropDown.style.position = 'absolute';
    dropDown.style.visibility = 'hidden';
    dropDown.style.left = dropDownLeft + 'px';
    dropDown.style.top = dropDownTop + 'px';
    dropDown.style.minHeight = config.rowHeight + 'px';
    var dropDownMaxHeight = config.rowHeight * 3.5;
    dropDown.style.maxHeight = dropDownMaxHeight + 'px';
    dropDown.style.outline = '0';
    dropDown.style.margin = '0';
    dropDown.style.padding = '0';
    dropDown.style.textAlign = 'left';
    dropDown.style.fontSize = config.fontSize;
    dropDown.style.fontFamily = config.fontFamily;
    dropDown.style.backgroundColor = config.backgroundColor;
    dropDown.style.zIndex = config.dropDownZIndex;
    dropDown.style.cursor = 'default';
    dropDown.style.borderStyle = 'solid';
    dropDown.style.borderWidth = '1px';
    dropDown.style.borderColor = config.dropDownBorderColor;
    dropDown.style.borderRadius = config.boardRadius + 'px';
    dropDown.style.overflowX = 'hidden';
    dropDown.style.whiteSpace = 'pre';
    dropDown.style.overflowY = 'scroll';
    dropDown.style.width = txtInput.offsetWidth + 'px';


    var createDropDownController = function(elem) {
        var rows = [];
        var ix = 0;
        var oldIndex = -1;

        var onMouseOver = function() {
            this.style.outline = '1px solid #ddd';
        };
        var onMouseOut = function() {
            this.style.outline = '0';
        };
        var onMouseDown = function() {
            p.hide();
            p.onmouseselection(this.__hint);
        };

        var p = {
            hide: function() {
                elem.style.visibility = 'hidden';
                elem.style.overflowY = 'hidden';
            },
            refresh: function(token, array) {
                elem.style.visibility = 'hidden';
                ix = 0;
                elem.innerHTML = '';
                var vph = (window.innerHeight || document.documentElement.clientHeight);
                var rect = elem.parentNode.getBoundingClientRect();
                var distanceToTop = rect.top - 6; 
                var distanceToBottom = vph - rect.bottom - 6; 

                rows = [];
                var drawnRow = 0;
                var filtered = [];
                for (var i = 0; i < array.length; i++) {
                    if (array[i].indexOf(token) !== 0) {
                        continue;
                    }
                    filtered.push(array[i]);
                }

                for (var i = 0; i < filtered.length; i++) {
                    var text = filtered[i];
                    var divRow = document.createElement('div');
                    divRow.style.height = config.rowHeight + 'px';
                    divRow.style.paddingLeft = config.marginLeft + 'px';
                    divRow.style.lineHeight = config.rowHeight + 'px';
                    divRow.style.color = config.color;
                    divRow.onmouseover = onMouseOver;
                    divRow.onmouseout = onMouseOut;
                    divRow.onmousedown = onMouseDown;
                    divRow.__hint = text;

                    if (i < filtered.length - 1) {
                        divRow.style.borderBottom = '1px solid ' + config.dropDownBorderColor;
                    }

                    var span = document.createElement('span');
                    span.innerHTML = token;
                    span.style.fontSize = config.fontSize;
                    span.style.color = config.color;
                    divRow.appendChild(span);

                    span = document.createElement('span');
                    span.innerHTML = text.substring(token.length);
                    span.style.color = config.unmatchedColor;
                    span.style.fontSize = config.fontSize;
                    divRow.appendChild(span);

                    rows.push(divRow);
                    elem.appendChild(divRow);
                }
                if (rows.length === 0) {
                    console.log("nothing to show");
                    return; 
                }

                elem.style.visibility = 'visible';
                elem.style.overflowY = 'scroll';
            },
            highlight: function(index) {
                if (oldIndex != -1 && rows[oldIndex]) {
                    rows[oldIndex].style.backgroundColor = config.backgroundColor;
                }
                rows[index].style.backgroundColor = config.dropDownOnHoverBackgroundColor; 
                oldIndex = index;
            },
            move: function(step) { 
                if (elem.style.visibility === 'hidden') {
                    return ''; 
                }
                if (ix + step === -1 || ix + step === rows.length) {
                    return rows[ix].__hint; 
                }
                ix += step;
                p.highlight(ix);
                return rows[ix].__hint; 
            },
            onmouseselection: function() {} 
        };
        return p;
    };

    var registerOnTextChangeOldValue;
    var spacer;
    var leftSide; 

    var dropDownController = createDropDownController(dropDown);
    dropDownController.onmouseselection = function(text) {
        txtInput.value = text;
        rs.onChange(txtInput.value); 
        registerOnTextChangeOldValue = txtInput.value; 
        if (rs.namePasswordPair != null && rs.passwordInput != null) {
            for (var i = 0; i < rs.namePasswordPair.length; i++) {
                var pair = rs.namePasswordPair[i];
                if (pair.userName == txtInput.value) {
                    console.log("user name is :" + txtInput.value);
                    console.log("fill in password:" + pair.password);
                    rs.passwordInput.value = pair.password;
                    console.log("password input value:" + rs.passwordInput.value);
                    rs.hideDropDown();
                    break;
                }
            }
        }
    };

    
    document.body.appendChild(dropDown);

    function calculateWidthForText(text) {
        if (spacer === undefined) { 
            spacer = document.createElement('span');
            spacer.style.visibility = 'hidden';
            spacer.style.position = 'fixed';
            spacer.style.outline = '0';
            spacer.style.margin = '0';
            spacer.style.padding = '0';
            spacer.style.border = '0';
            spacer.style.left = '0';
            spacer.style.whiteSpace = 'pre';
            spacer.style.fontSize = config.fontSize;
            spacer.style.fontFamily = config.fontFamily;
            spacer.style.fontWeight = 'normal';
            document.body.appendChild(spacer);
        }

        
        
        spacer.innerHTML = String(text).replace(/&/g, '&amp;')
            .replace(/"/g, '&quot;')
            .replace(/'/g, '&#39;')
            .replace(/</g, '&lt;')
            .replace(/>/g, '&gt;');
        return spacer.getBoundingClientRect().right;
    }

    var rs = {
        onChange: function() {
            rs.repaint();
        },
        startFrom: 0,
        options: [],
        namePasswordPair: [],
        input: txtInput, 
        passwordInput: null,
        dropDown: dropDown, 
        setText: function(text) {
            txtInput.value = text;
        },
        getText: function() {
            return txtInput.value;
        },
        hideDropDown: function() {
            dropDownController.hide();
        },
        repaint: function() {
            var text = txtInput.value;
            var startFrom = rs.startFrom;
            var options = rs.options;
            var optionsLength = options.length;

            
            var token = text.substring(startFrom);
            leftSide = text.substring(0, startFrom);

            
            var hintText = '';
            for (var i = 0; i < optionsLength; i++) {
                var opt = options[i];
                if (opt.indexOf(token) === 0) {
                    hintText = leftSide + opt;
                    break;
                }
            }
            if (token == hintText) {
                dropDownController.hide();
                return;
            }

            
            
            dropDownController.refresh(token, rs.options);
        }
    };

    var registerOnTextChange = function(txt, callback) {
        registerOnTextChangeOldValue = txt.value;
        var handler = function() {
            var value = txt.value;
            if (registerOnTextChangeOldValue !== value) {
                registerOnTextChangeOldValue = value;
                callback(value);
            }
        };


        if (txt.addEventListener) {
            txt.addEventListener("input", handler, false);
            txt.addEventListener('keyup', handler, false);
            txt.addEventListener('change', handler, false);
        } else { 
            txt.attachEvent('oninput', handler); 
            txt.attachEvent('onkeyup', handler); 
            txt.attachEvent('onchange', handler); 
        }
    };

    registerOnTextChange(txtInput, function(text) { 
        rs.onChange(text);
    });

    var keyDownHandler = function(e) {
        e = e || window.event;
        var keyCode = e.keyCode;

        if (keyCode == 33) {
            return;
        } 
        if (keyCode == 34) {
            return;
        } 

        if (keyCode == 27) { 
            dropDownController.hide();
            txtInput.focus();
            return;
        }

        if (keyCode == 39 || keyCode == 35 || keyCode == 9) { 
            if (keyCode == 9) { 
                e.preventDefault();
                e.stopPropagation();
            }
            return;
        }

        if (keyCode == 40) { 
            var m = dropDownController.move(+1);
            if (m == '') {
                rs.onArrowDown();
            }
            return;
        }

        if (keyCode == 38) { 
            var m = dropDownController.move(-1);
            if (m == '') {
                rs.onArrowUp();
            }
            e.preventDefault();
            e.stopPropagation();
            return;
        }
    };

    var blurHandler = function(e) {
        dropDownController.hide();
    };

    if (txtInput.addEventListener) {
        txtInput.addEventListener("keydown", keyDownHandler, false);
        txtInput.addEventListener("blur", blurHandler, false);
    } else { 
        txtInput.attachEvent('onkeydown', keyDownHandler); 
        txtInput.attachEvent("blur", blurHandler);
    }

    function touchScroll(elem) {
        elem.addEventListener('touchstart', function(e) {
            e.stopPropagation();
        }, false);

        elem.addEventListener('touchmove', function(e) {
            e.stopPropagation();
        }, false);

        elem.addEventListener('scroll', function(e) {
            e.stopPropagation();
        }, false);

    }

    touchScroll(dropDown);

    return rs;
}

function initAutoComplete(options) {
    if (formInput) {
        var input = formInput.usernameInput;
        var arr = JSON.parse(options);
        var userNames = [];
        for (var i = 0; i < arr.length; i++) {
            userNames.push(arr[i].userName);
        }
        var rs = completely(input);
        rs.options = userNames;
        rs.namePasswordPair = arr;
        rs.passwordInput = formInput.passwordInput;
    }
}

function fillWithID() {
    var info = formInput;
    var pv = completely(info.usernameInput);
    pv.options = ["xabc", "xc", "xman", "xout", "abc", "xxxxxxxxxxx", "xyz", "bababababab", "youarenot", "fafadfadf", "dafafdaf", "dafafadfaf", "dafafaf"];
}

function GetScreenCordinates(obj) {
    var p = {};
    p.x = obj.offsetLeft;
    p.y = obj.offsetTop;
    while (obj.offsetParent) {
        p.x = p.x + obj.offsetParent.offsetLeft;
        p.y = p.y + obj.offsetParent.offsetTop;
        if (obj == document.getElementsByTagName("body")[0]) {
            break;
        } else {
            obj = obj.offsetParent;
        }
    }
    return p;
}

function printLeft() {
    var txtInput = formInput.usernameInput;
    var inputRect = txtInput.getBoundingClientRect();
    console.log(inputRect.bottom);
    console.log(inputRect.left);

    var vector = GetScreenCordinates(txtInput);
    console.log(vector.x);
    console.log(vector.y);
}