if (typeof window.chrome == "undefined") {
    window.chrome = {};
}
window.chrome.send = function(fun, args) {
    let json = "{}";
    let callback = args[0];
    if (fun == "callQuickSendFunction") {
        fun = args[0]
        callback = args[1];
    } else if (args.length == 2) {
        json = args[1];
        if (typeof json == "object") {
            json = JSON.stringify(json)
        }
    }
    connectWebViewJavascriptBridge(function () {
        WebViewJavascriptBridge.callHandler(
            'callHandler',
            { "action": fun, "data": json},
            function (responseData) {
                if (typeof responseData != "undefined" && responseData != "") {
                    responseData = JSON.parse(responseData);
                }
                if (typeof window[callback] !== "undefined" && window[callback]!== null) {
                   window[callback](responseData);
                }
            }
        );
    });
};


(function () {
    connectWebViewJavascriptBridge(function () {
        WebViewJavascriptBridge.registerHandler(
            'onMaxthonQuickSendWebNotifyEventCallback',
            function(responseData, responseCallback) {
                if (typeof responseData != "undefined" && responseData != "") {
                    responseData = JSON.parse(responseData);
                }
                responseCallback(notifyQuickSendEvent(responseData));
            });
    });

    var readyEvent = document.createEvent('Events');
    readyEvent.initEvent('QuickSendReady');
    document.dispatchEvent(readyEvent);
})();