(function () {

    var LANGUAGE = 'zh-cn';
    var PRODUCT_TITLE = 'startpage_android';
    var STAT_URL = 'http://g.dcs.maxthon.com/mx4/web?data=';

    function getQueryString(name) {
        var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)", "i");
        var r = window.location.search.substr(1).match(reg);
        if (r != null) {
            return unescape(r[2]);
        } else {
            return '';
        }
    }

    function stringify(obj) {
        if (window.JSON) {
            return JSON.stringify(obj);
        }
        var t = typeof (obj);
        if (t != "object" || obj === null) {
            // simple data type
            if (t == "string") obj = '"' + obj + '"';
            return String(obj);
        } else {
            // recurse array or object
            var n, v, json = [], arr = (obj && obj.constructor == Array);

            // fix.
            var self = arguments.callee;

            for (n in obj) {
                v = obj[n];
                t = typeof(v);
                if (obj.hasOwnProperty(n)) {
                    if (t == "string") v = '"' + v + '"'; else if (t == "object" && v !== null)
                        // v = jQuery.stringify(v);
                        v = self(v);
                    json.push((arr ? "" : '"' + n + '":') + String(v));
                }
            }
            return (arr ? "[" : "{") + String(json) + (arr ? "]" : "}");
        }
    }

    if (window.mmbrowser) {
        var deviceid = window.mmbrowser.getDeviceId();
    } else {
        var deviceid = getQueryString('deviceid');
    }

    if (window.screen) {
        var resolution = window.screen.width + '*' + window.screen.height;
    }

    $(document).click(function(e) {
        var target = $(e.target);
        var elem = target.closest('a');
        var tags = ['a', 'span', 'input', 'img', 'button', 'i'];
        var targetTag = e.target.tagName.toLowerCase();

        if (elem.length === 0) return;

        if (target.closest('[data-s-disabled]').length) return;

        if ($.inArray(targetTag, tags) == -1) return;
        e.preventDefault();

        function getProperty(property, target) {
            var node = target.closest('[' + property + ']');
            return node.attr(property) || '';
        }

        var url, title = '';
        if (elem[0]) {
            url = elem.attr('href') || '';
            title = elem.attr('title') || '';
        }
        if (!url || url === '#') {
            url = getProperty( 'data-s-url', target );
        }
        if (!title && !elem.children().length) {
            title = elem.text();
        }

        var statisticData = {
            'l': LANGUAGE,
            'd': deviceid,
            'sv': '',
            'cv': '',
            'pt': getProperty('data-s-pt', target) || PRODUCT_TITLE,
            'dt': getProperty('data-s-dt', target) || 'content',
            'm': getProperty('data-s-m', target),
            'n': getProperty('data-s-n', target),
            'o': getProperty('data-s-o', target),
            'p': getProperty('data-s-p', target),
            'data': {
                'title': title,
                'url': url,
                'resolution': resolution || ''
            }
        }

        var src = encodeURIComponent(stringify(statisticData));
        var img = new Image();
        img.src = STAT_URL + src;
        img.onerror = function () {
            var href = getProperty('href', target);
            if (href) {
                window.location = href;
            }
        }
    })

})();