//const syncAPI = "http://localhost:17000"

async function mxSync_Call(para) {
    console.log("mxSync_Call:", para)
    const { mxsync } = MxSync.gl
    return await mxsync.onCall(para)
}

export class MxSync {
    static async create(gl) {
        if (await import("/lib/compressJson.min.js")) {
            gl.compressJson = window.compressJson
        } else {
            console.error("loading compressJson failed")
        }
        gl.jsondiff = await import("/lib/jsondiffpatch-with-text-diffs.js")
        gl.syncAPI = "https://syncapi.maxthon.com"
        const inst = new MxSync
        MxSync.gl = gl
        inst.gl = gl
        inst.clients = {}
        gl.mxsync = inst
        window.mxSync_Call = mxSync_Call
        return inst
    }
    async run() {
        const { api } = this.gl
        const { user_id } = await api.userInfo()
        if (api.browserInfo().version >= "7.1.8.7100") {
            this.names = { settings: {}, bookmarks: {} }
        }
        api.registerReceiver({ name: "mxsync", client: this })
        this.checkProxy()
        if (!user_id || user_id == 'undefined') {
            console.error("User not login. mxsync quit")
            return
        }
        //this.syncOnce()
    }
    async onPeerNotify(data) {
        if (data.type === 'dataUpdate') {
            await this.syncOnce({ names: [data.name] })
        }
    }
    async registerClient({ name, client }) {
        this.clients[name] = client
    }
    async onCall(para) {
        const { cmd, param } = para
        const { api } = this.gl
        //  const mxtoken = api.getCookie("MXTOKEN")
        //  if (!mxtoken) return { code: 100, err: "not logged-in" }

        switch (cmd) {
            case 'updateData': return await this.onUpdateData(param);
            case 'syncOnce': return await this.syncOnce(param);
            case 'getRemoteVersion': return await this.getAllRemoteVersions(param)
        }
        return this[cmd] ? await this[cmd](param) : null
    }
    async syncOnce(param) {
        const { api } = this.gl
        let user_id = param?.uid, names = param?.names
        if (this.syncing) {
            console.error("still in syncing")
            setTimeout(() => this.syncing = false, 1000 * 60) //reset after 1 min
            return { code: 100, msg: "still in syncing" }
        }
        if (!names) {
            console.error("no names")
            //return { code: 100, msg: "no names" }
            names = Object.keys(this.names)
        }
        console.log("syncOnce checking")
        if (!user_id)
            ({ user_id } = await api.userInfo())
        if (!user_id) {
            console.error("user not login, quit")
            return { code: 101, msg: 'user not login' }
        }
        this.syncing = true
        let remote = null
        try {
            await this.reportStat('start')
            remote = await this.getAllRemoteVersions(names)
            const local = await this.getLocalVersions(names || Object.keys(names))
            const toDownload = []
            const toUpload = []
            for (const key of names) {
                const vl = local[key]?.ver   //local version
                const vr = remote[key]?.ver //remote version
                if (typeof vl == 'undefined' || typeof vr === 'undefined') continue
                console.log(key, " vl:", vl, "vr:", vr)
                if (vr === 0 && vl != 0) { //upload
                    console.log("need upload")
                    toUpload.push(key)
                    continue
                }
                if (vr === 0 && vl === 0) { //both are 0, try to see if it has old data
                    toDownload.push(key)
                    continue
                }

                if (vr <= vl) continue
                console.log("need download")
                toDownload.push(key)
            }
            if (toDownload.length > 0) {
                await this.downloadData({ names: toDownload, uid: user_id })
            }
            if (toUpload.length > 0) {
                const items = await this.getLocalData(toUpload)
                await this.uploadData({ items, incVer: false, remote })
            }
            await this.reportStat('end')
        } catch (e) {
            api.postError("syncOnce exception:" + e.stack + e.message)
            this.syncing = false
            return { code: 100, err: e.message }
        }
        this.syncing = false
        return { code: 0, msg: "sync finish", remote }
    }
    async updateMaxthonData(param) {
        const { api } = this.gl
        api.debug('updateMaxthonData:', param)
        const res = await this.gl.api.callBrowser({ from: "mxsync_js", cmd: "newData", param })
        return res
    }
    async updateClientData({ name, uid, data, ver, merge = false }) {
        if (this.clients[name])
            return await this.clients[name].onSyncCall({ cmd: "newData", param: { name, uid, data, ver, merge } })
        return await this.updateMaxthonData({ name, uid, data, ver, merge })
    }
    async reportStat(stat) {
        const res = await this.gl.api.callBrowser({ from: "mxsync_js", cmd: "stats", param: { stat } })
        return res
    }
    async afterRestoreData({ name }) { //it's called after restore data from client
        const { note } = this.gl
        const { user_id } = await api.userInfo()
        if (!user_id) return { code: 1, msg: "no need for guest account" }
        if (name === 'notem') {
            await note.initDB()
        }
        const items = await this.getLocalData([name])
        const ret = await this.uploadData({ items, incVer: 2 })
        if (ret['notem']?.code == 0 && name === 'notem') {
            await note.setMetaVer(ret['notem'].ver)
            await note.checkAndUploadNotes()
        }
    }
    async getLocalData(names) {
        const ret = {}
        for (const name of names) {
            const res = await this.gl.api.callBrowser({ from: "mxsync_js", cmd: "getData", param: { name } })
            if (!res || res.code != 0) {
                console.error(res)
                continue
            }
            ret[name] = res.values
        }
        for (const name in this.clients) {
            if (names.includes(name)) {
                ret[name] = await this.clients[name].onSyncCall({ cmd: "getLocalData" })
            }
        }
        return ret
    }
    async getLocalVersions(names) {
        const res = await this.gl.api.callBrowser({ from: "mxsync_js", cmd: "getVersions", param: { names } })
        if (!res || res.code != 0) console.error(res)
        const ret = res?.values || {}
        for (const name in this.clients) {
            if (names.includes(name)) {
                ret[name] = { ver: await this.clients[name].onSyncCall({ cmd: "getLocalVersion" }) }
            }
        }
        return ret
    }
    async getAllRemoteVersions(param) {
        const names = param
        if (!names) {
            console.error("no names 1")
            return {}
        }
        const result = await this._postData({ path: 'vers', body: { names } })
        return result
    }
    async onUpdateData({ ver, uid, name, data, incVer = true }) {
        const { api } = this.gl
        api.debug("onUpdateData:", ver, uid, name, data)
        if (typeof ver === 'undefined') return { code: 100, err: "ver is missing" }
        const items = { [name]: { ver, data } }
        const res = await this.uploadData({ items, incVer })
        api.debug("uploadData return:", res)
        return res[name] ? res[name] : res
    }

    async mergeData({ name, data, datal }) {
        const { api } = this.gl
        if (typeof data === 'string') data = JSON.parse(data)
        if (typeof datal === 'string') datal = JSON.parse(datal)
        return api.merger.mergeAdvanced(data, datal)
    }
    diffEnabled(uid) {
        const { pl, ver } = this.gl
        if (pl === "win" && ver >= "7.1.8.9001") return true
        if (pl === 'mac' && ver >= '7.1.8.9001') return true
        if (pl === 'ios' && ver >= '7.3.4.411') return true
        if (pl === 'android' && ver >= '7.4.3.700') return true
        return [515485465, 55502206, 55555153].includes(+uid)
    }
    //incVer=2 means replace
    async uploadData({ items, incVer = true, remote = null }) {
        const { api, jsondiff, pl } = this.gl
        api.debug('uploadData:', items)
        if (Object.keys(items).length === 0) return { code: 100, err: "no items" }
        const { user_id } = await api.userInfo()

        let namesObj = null
        if (this.diffEnabled(user_id)) {
            namesObj = await this.getCache({ names: Object.keys(items) })
        }
        if (!remote && namesObj) {
            remote = await this.getAllRemoteVersions(Object.keys(items))
            if (remote.err) return remote
        }
        for (const name in items) {
            let { data } = items[name]
            if (!data) {
                console.error("uploadData: data is null")
                continue
            }
            if (typeof data === 'string') {
                const data1 = api.parseJson(data)
                if (!data1) {
                    console.error("invalid data", data)
                    delete items[name]
                    continue
                }
                data = data1
            }
            items[name].data = compressJson.compress(data)
            if (namesObj && namesObj[name] && (remote[name].ver == namesObj[name].fv) && incVer != 2) {
                const { fv, data: datal } = namesObj[name]
                const diffdata = jsondiff.diff(datal, data)
                if (diffdata) {
                    const diff = compressJson.compress(diffdata)
                    items[name].diff = { fv, data: diff }
                } else {
                    return { code: 101, err: "data no change" }
                }
            }
        }
        const postItems = {}
        Object.keys(items).forEach(key => {
            postItems[key] = Object.assign({}, items[key])
            if (items[key].diff) {
                console.log("uploadData use diff for:", key)
                delete postItems[key].data
            }
        })
        const ret = await this._postData({ path: "up", body: { items: postItems, incVer, pl } })
        const toDownload = []
        for (const name in ret) {
            if (ret[name].code === 1001) toDownload.push(name)
            if (ret[name].code === 0 && this.diffEnabled(user_id)) {
                const { data } = items[name]
                const json = compressJson.decompress(data)
                await this.saveCache({ name, json, ver: ret[name].ver })
            }
        }
        if (toDownload.length > 0) {
            setTimeout(() => this.downloadData({ names: toDownload, uid: user_id }), 100)
            return { code: 1, msg: "try later" }
        }
        return ret
    }
    async getCache({ names, withData = true }) {
        const { api } = this.gl
        const { user_id } = await api.userInfo()
        const name1 = {}
        for (const name of names) {
            const key = name + user_id + "_sync"
            let datal = await api.readData({ key })
            if (!datal) continue
            datal = api.parseJson(datal)
            name1[name] = { fv: datal ? datal.ver : null }
            if (withData) name1[name].data = datal.data
        }
        return Object.keys(name1).length === 0 ? null : name1
    }
    async deleteCache({ name }) {
        const { api } = this.gl
        const { user_id } = await api.userInfo()
        const key = name + user_id + "_sync"
        await api.removeData({ key })
    }

    async saveCache({ name, json, ver }) {
        const { api } = this.gl
        const { user_id } = await api.userInfo()
        const key = name + user_id + "_sync"
        await api.saveData({ key, value: { ver, data: json } })
    }
    async downloadData({ names, uid, forceMig = false }) {
        const { api, jsondiff } = this.gl
        console.log('downloadData:', names, uid)
        const { compressJson } = this.gl
        let namesObj = null
        if (this.diffEnabled(uid)) {
            namesObj = await this.getCache({ names, withData: false })
        }
        let items = await this._postData({ path: "down", body: { names, namesObj, forceMig } })
        if (items.err) {
            console.error("downloadData err:", items.err)
            return { code: 101, err: items.err }
        }
        for (const name in items) {
            let { v, encoding = 'c', data, err, code, diff, replace = false } = items[name]
            let json = null
            if (!err && diff) {
                const namesObj = await this.getCache({ names: [name] })
                if (!namesObj) continue
                console.log("downloadData diff:", name, "ver:", v)
                const datal = namesObj[name].data
                diff = compressJson.decompress(diff.data)
                try {
                    json = jsondiff.patch(datal, diff)
                } catch (e) {
                    await this.deleteCache({ name })
                    console.error("patch error:", e.message)
                    continue
                }
                data = JSON.stringify(json)
            }
            if (!err && encoding === 'c' && !diff) {
                json = compressJson.decompress(data)
                data = JSON.stringify(json)
            }
            if (code === 0 && data) {
                if (v > 0 && this.diffEnabled(uid)) { //save to cache
                    //await api.saveData({ key, value: { ver: v, data: json } })
                    await this.saveCache({ name, json, ver: v })
                }
                let res = await this.updateClientData({ name, uid, data, ver: v })
                console.log("updateClientData ret:", res)
                if (res.code === 1) {
                    let ver = v, data1 = data
                    if (!replace) {
                        api.debug("mergeData:", name, "data:", data, "datal:", res.values)
                        data1 = await this.mergeData({ name, data, datal: res.values })
                        api.debug('after merge:', data1)
                        const items = { [name]: { ver: v, data: data1 } }
                        const ret = await this.uploadData({ items })
                        ver = (ret[name] && ret[name].code == 0) ? ret[name].ver : v
                    }
                    res = await this.updateClientData({ name, uid, data: JSON.stringify(data1), ver, merge: true })
                }
            }
            err && console.error(name, err)
        }
    }
    async _postData({ path, body = {} }) {
        let { api, syncAPI, region } = this.gl
        let err = null
        const { user_id, device, region_domain } = await api.userInfo()
        if (!user_id) {
            err = "_postData error getting user_id"
            console.error(err)
            return { err }
        }
        const mxtoken = await api.getMXToken()
        api.debug("got mxtoken:", mxtoken)
        if (body) {
            body.from = device
            body.uid = user_id + ''
            body.region = region || region_domain
            body.os = await api.browserInfo().os
            body.mv = await api.browserInfo().version
        }
        const sBody = JSON.stringify(body)
        const usegzip = sBody.length > 2048
        const packedData = usegzip ? pako.gzip(sBody) : msgpackr.pack(body)
        const url = syncAPI + `/sync/` + path
        try {
            const headers = {
                'Content-Type': usegzip ? 'application/json' : 'application/msgpack',
                'mxtoken': mxtoken
            }
            if (usegzip) headers['Content-Encoding'] = 'gzip'
            const ret = await fetch(url, {
                method: "POST",
                headers,
                credentials: 'include',
                body: packedData
            })

            const result = await ret.json()
            return result
        } catch (e) {
            err = e.message
            console.error("_postData:", e.message)
            //retry
            if (!this.retryPost) this.retryPost = 1
            if (this.retryPost > 2 && region === 'cn')
                this.useProxyServer();
            if (++this.retryPost > 5) {
                api.postError("_postData err url:" + syncAPI + `/sync/` + path + " err:" + err)
                this.retryPost = 0
                return { err }
            }
            await api.wait(3000)
            return await this._postData({ path, body })
        }
        return { err }
    }
    async checkProxy() {
        const { api } = this.gl
        const value = await api.mxGetCookie({ name: "sync_proxy" });
        if (value) this.gl.syncAPI = "https://syncapi1.maxthon.com"
    }
    useProxyServer() {
        const { api } = this.gl
        this.gl.syncAPI = "https://syncapi1.maxthon.com";
        api.mxSetCookie({ name: "sync_proxy", value: "true", days: 1 })
        return this.gl.syncAPI
    }
    async getRemoteVersion({ name }) {
        const res = await this._postData({ path: "vers", body: { names: [name] } })
        return res
    }
}