import reconnectingWebsocket from '/lib/reconnecting-websocket@4.4.0.js'
//const mxPushAPI = "ws://mxpush.mxfast.com:8880/"
const mxPushAPI = "wss://push.mxfast.com/"

export class Messaging {
    static create(gl) {
        const inst = new Messaging
        inst.gl = gl
        return inst
    }
    async run() {
        const { api, mxsync } = this.gl
        const user = await api.userInfo()
        //console.log("userInfo",user)
        if (!user) {
            console.error('can not get user')
            return
        }
        let { user_id, device } = user
        if (!device) {
            console.error('no device')
            return { code: 100, msg: "no device" }
        }
        if (!user_id) {
            console.error('no user_id')
            return { code: 101, msg: "not login" }
        }

        const token = await api.getMXToken()
        if (!token) {
            console.error('not login')
            return { code: 101, msg: "not login" }
        }
        user_id = user_id + "_" + encodeURIComponent(device)
        const url = `${mxPushAPI}?uid=${user_id}&token=${token}`
        console.log("connecting to", url)
        const socket = new reconnectingWebsocket(url, [], { maxReconnectionDelay: 20000, maxRetries: 1000 });

        // 连接打开时的事件处理
        socket.onopen = function (event) {
            console.log('Connection opened:', event);
            //socket.send("hello from client");
        };
        // 接收消息的事件处理
        socket.onmessage = function (event) {
            console.log('Message received:', event.data);
            const item = api.parseJson(event.data)
            if (item) {
                const { _r, _id, to, cmd, data } = item
                if (to === 'mx' && !_r) {
                    api.notifyBrowser(data)
                }
                if (to === 'mxsync') {
                    mxsync.onPeerNotify(data)
                }
            }
        };
        // 连接关闭时的事件处理
        socket.onclose = function (event) {
            console.log('Connection closed:', event);
            const { code } = event
            if (code === 4001) { //auth error
                socket.close()
            }
        };
        socket.onerror = function (event) {
            console.error("WebSocket error observed:", event);
        }
    }

}