//import { Messaging } from "./messaging.js"
//import { Log } from "./log.js"
import { API } from "./api.js"
let gll = {}
let browser_ready = false
const browser_config = {
    sync: {
        bookmarks: {
            prov: 2
        },
        settings: {
            prov: 2
        },
        fas: {
            prov: 2
        },
        pass: {
            prov: 2
        }
    }
}
async function jsController_call(para) {
    if (!gll.api) {
        gll.api = await API.create({ gl: gll })
    }
    const { api } = gll
    if (para.cmd === 'browser_ready') {
        browser_ready = true
        await gll.app.onBrowserReady(para.param)
        return browser_config
    }
    if (para.cmd === 'login_end') { //other module continue to handle 
        await gll.app.onLoginEnd(para.param)
    }
    if (para.cmd === 'profile_loaded') { //other module continue to handle 
        await gll.app.onProfileLoaded(para.param)
    }
    if (api) {
        return await api.invokeCall(para)
    }
}
export class MxApp {
    static async Run({ region, platform, gl }) {
        gll = gl
        window.jsController_call = jsController_call
        window.onExternal_call = jsController_call
        gl.region = region
        gl.platform = platform
        gl.app = this
        this.region = region
        this.platform = platform
    }
    static async onBrowserReady(param) {
        const { ver, pl } = param
        const gl = gll
        gl.ver = ver, gl.pl = pl
        if (!gl.api)
            gl.api = await API.create({ gl })
        const api = gl.api
        window.api = api
        api.debug("browser_ready:", param)

        gl.dev = (await api.getCookie("controller_dev") === 'true')

        const el = document.querySelector("#ver_page")
        if (el) {
            el.innerText = "page version:" + api.ver
        }

        if (gl.region === 'cn' && ver >= "7.1.9.4000" && pl != "ios") {
            //surl
            const SURL = await api.loadClass({ name: "SURL" })
            if (SURL) {
                gl.surl = await SURL.create(gl)
                gl.surl.run()
            }
        }
        if (ver < "7.2.2.2100" && (pl == 'win' || pl == 'mac')) { //simulate this message for old version
            let { user_id } = await api.userInfo()
            if (!user_id) user_id = 0
            jsController_call({ cmd: "profile_loaded", param: { user_id } })
            //await this.onProfileLoaded({ user_id })
        }
        if (!gl.messaging) {
            const Messaging = await api.loadClass({ name: "Messaging" })
            gl.messaging = await Messaging.create(gl)
        }
        if (!gl.mxsync) {
            const MxSync = await api.loadClass({ name: "MxSync" })
            gl.mxsync = await MxSync.create(gl);
        }
        if (!gl.note) {
            const Note = await api.loadClass({ name: "Note" })
            gl.note = await Note.create(gl)
        }
        if (!gl.news) {
            const News = await api.loadClass({ name: "News" })
            gl.news = await News.create(gl)
        }
        if (!gl.util) {
            const Util = await api.loadClass({ name: "Util" })
            gl.util = await Util.create(gl)
        }
        api.callBrowser({ from: "jsController", event: "started" })

    }
    static async onLoginEnd(param) {
        const { api } = gll
        const { success, user_id } = param
        api.debug("login_end:", param)

    }
    static async onProfileLoaded(param) {
        const { user_id } = param
        const gl = gll
        const { pl, api, ver } = gl
        await api.userInfo(true)
        api.debug("profile_loaded:", param)

        if (!gl.log) {
            const Log = await api.loadClass({ name: "Log" })
            gl.log = Log.create(gl)
        }
        gl.log.run()
        if (user_id != 0) {

            gl.messaging.run()
            gl.mxsync.run()
        }

        gl.note.run()


    }
    static async RunTest({ gl }) {
        const { api } = gl
    }

}