/**
 * Copyright (C) 2015 Wasabeef
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var RE = {};

console.log("rich-editor");
RE.currentSelection = {
	"startContainer": 0,
	"startOffset": 0,
	"endContainer": 0,
	"endOffset": 0};

RE.titlePHValue = "";
RE.contentPHValue = "";
RE.urlPHValue = "";
RE.AndroidVersion = 0;

RE.editor = document.getElementById('editor');
RE.title = document.getElementById('title_input_id');

document.addEventListener("selectionchange", function() {
	RE.backupRange();
	
});

RE.setAndroidVersion = function(version){
	RE.AndroidVersion = version;
}

RE.selectNode = function(node){
	var range = document.createRange();
	range.selectNode(node);
	range.collapse(false);
	var selection = window.getSelection();
	selection.removeAllRanges();
	selection.addRange(range);
	//RE.getCommandState();
}

RE.hideEditor = function() {
	RE.editor.style.display = "none";
}

RE.showEditor = function() {
	RE.editor.style.display = "block";
}

RE.setData = function(contents){
	RE.setHtml(contents);
	RE.contents = RE.getHtml();
}

RE.setHtml = function(contents) {
	console.log("contents: " + contents);
	removeLoading();
	Note.topDiv.style.display = "";
	RE.editor.classList.remove("placeholder_text");
	RE.editor.classList.add("normal_text");
	if(Note.shouldShowLockIcon){
		document.getElementById("lock_img_id").style.display = "";
	}
	// var content = decodeURIComponent(contents.replace(/\+/g, '%20'));
	RE.editor.innerHTML = contents;
	console.log("setHtml:" + contents);
	if (RE.editor.firstChild === undefined) {
		console.log("setHtml: firstChildName undefined");
		//RE.editor.innerHTML = "<p></br></p>";
	}
	
	if (RE.editor.firstChild !== undefined) {
		console.log("setHtml: firstChildName:" + RE.editor.firstChild.tagName);
		if (RE.editor.firstChild.tagName === "P") {
			RE.editor.style.paddingTop = 0;
		}else{
			RE.editor.style.paddingTop = "16px";
		}
	}
	
	RE.editor.focus();
	
	RE.refreshImgClick();
	RE.refreshHrefClick();
}

RE.getHtml = function() {
	return RE.editor.innerHTML;
}

RE.getText = function() {
	return RE.editor.innerText;
}

RE.setEditable = function(editable) {
	console.log("RE.setEditable:" + editable);
	if (editable === "true") {
		console.log("editable (state): " + editable);
		RE.editor.style.webkitUserModify="read-write";
		//RE.editor.addEventListener("input", RE.callback);
	} else {
		console.log("editable (state): " + editable);
		RE.editor.style.webkitUserModify="read-only";
		//RE.editor.removeEventListener("input", RE.callback);
		Note.title.readOnly = "readOnly";
		Note.title.style.display = "none";
		Note.titleP.style.display = "inline-block";
	}
}

RE.setFontSize = function(size) {
	RE.editor.style.fontSize = size;
}

RE.setPadding = function(left, top, right, bottom) {
	RE.editor.style.paddingLeft = left;
	RE.editor.style.paddingTop = top;
	RE.editor.style.paddingRight = right;
	RE.editor.style.paddingBottom = bottom;
}

RE.setBackgroundColor = function(color) {
	document.body.style.backgroundColor = color;
}

RE.setWidth = function(size) {
	RE.editor.style.minWidth = size;
}

RE.setHeight = function(size) {
	document.body.style.minHeight = size;
}

RE.setTextAlign = function(align) {
	RE.editor.style.textAlign = align;
}

RE.setVerticalAlign = function(align) {
	RE.editor.style.verticalAlign = align;
}

RE.setContentEditable = function(editable) {
	RE.editor.contentEditable = editable;
}

RE.setContentPlaceholder = function(placeholder) {
	RE.editor.innerHTML = placeholder;
	RE.contentPHValue = placeholder;
	RE.editor.classList.remove("normal_text");
	RE.editor.classList.add("placeholder_text");
	// RE.editor.setAttribute("placeholder", placeholder);
}

RE.undo = function() {
	//document.execCommand('undo', false, null);
}

RE.redo = function() {
	//document.execCommand('redo', false, null);
}

RE.setBold = function() {
	document.execCommand("bold");
}

RE.setItalic = function() {
	document.execCommand('italic');
}

RE.setSubscript = function() {
	document.execCommand('subscript');
}

RE.setSuperscript = function() {
	document.execCommand('superscript');
}

RE.setStrikeThrough = function() {
	document.execCommand('strikeThrough');
}

RE.setUnderline = function() {
	console.log("setUnderline");
	document.execCommand('underline');
}

RE.setTextColor = function(color) {
	RE.restorerange();
	document.execCommand("styleWithCSS", null, true);
	document.execCommand('foreColor', false, color);
	document.execCommand("styleWithCSS", null, false);
}

RE.setTextBackgroundColor = function(color) {
	RE.restorerange();
	document.execCommand("styleWithCSS", null, true);
	document.execCommand('hiliteColor', false, color);
	document.execCommand("styleWithCSS", null, false);
}

RE.setHeading = function(heading) {
	//document.execCommand('formatBlock', false, '<h'+heading+'>');
}

RE.setIndent = function() {
	document.execCommand('indent');
}

RE.setOutdent = function() {
	document.execCommand('outdent');
}

RE.setJustifyLeft = function() {
	document.execCommand('justifyLeft', false, null);
}

RE.setJustifyCenter = function() {
	document.execCommand('justifyCenter', false, null);
}

RE.setJustifyRight = function() {
	document.execCommand('justifyRight', false, null);
}

RE.setBlockquote = function() {
	document.execCommand('formatBlock', false, '<blockquote>');
}

RE.insertImage = function(imgHtml) {
	console.log("imageHtml:"+imgHtml);
	RE.insertHTML(imgHtml);
	RE.refreshImgClick();
}

RE.replaceImageSrc = function(id, url) {
	console.log(document.getElementById(id).src);
	document.getElementById(id).src = url;
	console.log(document.getElementById(id).src);
}

RE.insertHTML = function(html) {
	console.log("insertLink")
	RE.restorerange();
	RE.editor.innerHTML = RE.editor.innerHTML + html;
	// document.execCommand('insertHTML', false, html);
}

RE.insertLink = function(url, title) {
	console.log("insertLink")
	RE.restorerange();
	var sel = document.getSelection();
	if (sel.toString().length != 0) {
		if (sel.rangeCount) {
			var el = document.createElement("a");
			el.setAttribute("href", url);
			el.setAttribute("title", title);
			
			var range = sel.getRangeAt(0).cloneRange();
			range.surroundContents(el);
			sel.removeAllRanges();
			sel.addRange(range);
		}
	}
	//RE.callback();
}

RE.insertUnorderedList = function() {
	RE.restorerange();
	document.execCommand('insertunorderedlist');
}

RE.insertOrderedList = function() {
	RE.restorerange();
	document.execCommand('insertorderedlist');
}

RE.prepareInsert = function() {
	RE.backupRange();
}

RE.backupRange = function(){
	var selection = window.getSelection();
	console.log("backupRange: " + selection.toString() + " rangeCount:"+selection.rangeCount);
	if (selection.rangeCount > 0) {
		var range = selection.getRangeAt(0);
		RE.currentSelection = {
			"startContainer": range.startContainer,
			"startOffset": range.startOffset,
			"endContainer": range.endContainer,
			"endOffset": range.endOffset};
		
		RE.printCurrentSelect(range);
	}
}

RE.printCurrentSelect = function(range){
	console.log("backuprange range:"+ range.startContainer + " offset:"+range.startOffset
			+" endContainer:"+range.endContainer+" endOffset:"+range.endOffset);
}

RE.restorerange = function(){
	var selection = window.getSelection();
	selection.removeAllRanges();
	var range = document.createRange();
	range.setStart(RE.currentSelection.startContainer, RE.currentSelection.startOffset);
	range.setEnd(RE.currentSelection.endContainer, RE.currentSelection.endOffset);
	selection.addRange(range);
	console.log("restorerange:" + selection + "rangeRange:"+range);
}

RE.removeFormat = function(){
	document.execCommand('removeFormat');
}

RE.focus = function() {
	/*var range = document.createRange();
	range.selectNodeContents(RE.editor);
	range.setStart(RE.editor, 0);
	range.collapse(false);
	var selection = window.getSelection();
	selection.removeAllRanges();
	selection.addRange(range);*/
	RE.editor.focus();
	
	if (RE.editor.innerHTML == RE.contentPHValue) {
		RE.editor.innerHTML = "";
		RE.editor.classList.remove("placeholder_text");
		RE.editor.classList.add("normal_text");
	}
}


RE.firstFocus = function() {
	console.log("firstFocus");
	var range = document.createRange();
	range.selectNodeContents(RE.editor);
	range.collapse(true);
	var selection = window.getSelection();
	selection.removeAllRanges();
	selection.addRange(range);
	/*RE.editor.focus();*/
}

RE.testFocus = function() {
	console.log("testFocus");
	//var range = document.createRange();
	//range.selectNodeContents(RE.editor.firstElementChild);
	// range.collapse(false);
	// var selection = window.getSelection();
	// selection.removeAllRanges();
	// selection.addRange(range);
	/*RE.editor.focus();*/
}

// Event Listeners
// RE.editor.addEventListener("input", RE.callback);
// RE.editor.addEventListener("keyup", function(e) {
//
// });
// RE.editor.addEventListener("click", );
// RE.editor.addEventListener("focus", RE.testFocus);

RE.refreshImgClick = function(){
	var img = RE.editor.getElementsByTagName("img");
	for(var n = 0; n < img.length; n++){
		console.log("add img event:"+img[n].getAttribute("src"));
		img[n].addEventListener('click', RE.imgClick);
	}
}

RE.imgClick = function(){
	console.log("img click:"+this + " parentCode:"+this.parentNode + " src:"+this.getAttribute("src"));
	RE.selectNode(this);
	if (window.NoteJs !== undefined) {
		window.NoteJs.onImgClick(this.getAttribute("src"));
	}
}


RE.refreshHrefClick = function(){
	var a = RE.editor.getElementsByTagName("a");
	console.log("refreshHrefClick:"+a);
	for(var n = 0; n < a.length; n++){
		if(a[n].getAttribute("href")){
			console.log("add href event:"+a[n].getAttribute("href"));
			a[n].addEventListener('click', RE.hrefClick);
		}
	}
}

RE.hrefClick=function(){
	console.log("href click:"+this + " parentCode:"+this.parentNode + " src:"+this.getAttribute("href"));
	RE.selectNode(this);
	if (window.NoteJs !== undefined) {
		window.NoteJs.onHrefClick(this.getAttribute("href"));
	}
}

